/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.LeafState;
import com.intellij.ui.tree.Reference;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StructureTreeModel<Structure extends AbstractTreeStructure>
extends AbstractTreeModel
implements Disposable,
InvokerSupplier,
ChildrenProvider<TreeNode> {
    private static final TreePath ROOT_INVALIDATED = new TreePath(new DefaultMutableTreeNode());
    private static final Logger LOG = Logger.getInstance(StructureTreeModel.class);
    private final Reference<Node> root;
    private final String description;
    private final Invoker invoker;
    private final Structure structure;
    private volatile Comparator<? super Node> comparator;

    private StructureTreeModel(@NotNull Structure structure, boolean background) {
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(0);
        }
        this.root = new Reference();
        this.structure = structure;
        this.description = StructureTreeModel.format(structure.toString());
        this.invoker = background ? new Invoker.BackgroundThread(this) : new Invoker.EDT(this);
    }

    public StructureTreeModel(@NotNull Structure structure) {
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(1);
        }
        this(structure, true);
    }

    public StructureTreeModel(@NotNull Structure structure, @NotNull Comparator<? super NodeDescriptor> comparator2) {
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(2);
        }
        if (comparator2 == null) {
            StructureTreeModel.$$$reportNull$$$0(3);
        }
        this(structure);
        this.comparator = StructureTreeModel.wrapToNodeComparator(comparator2);
    }

    @NotNull
    private static Comparator<? super Node> wrapToNodeComparator(@NotNull Comparator<? super NodeDescriptor> comparator2) {
        if (comparator2 == null) {
            StructureTreeModel.$$$reportNull$$$0(4);
        }
        Comparator comparator3 = (node1, node2) -> comparator2.compare(((Node)node1).getDescriptor(), ((Node)node2).getDescriptor());
        if (comparator3 == null) {
            StructureTreeModel.$$$reportNull$$$0(5);
        }
        return comparator3;
    }

    public final void setComparator(@Nullable Comparator<? super NodeDescriptor> comparator2) {
        if (this.disposed) {
            return;
        }
        if (comparator2 != null) {
            this.comparator = StructureTreeModel.wrapToNodeComparator(comparator2);
            this.invalidate();
        } else if (this.comparator != null) {
            this.comparator = null;
            this.invalidate();
        }
    }

    public void dispose() {
        this.comparator = null;
        Node node = this.root.set(null);
        if (node != null) {
            node.dispose();
        }
        this.treeStructureChanged(null, null, null);
        super.dispose();
    }

    @Override
    @NotNull
    public final Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            StructureTreeModel.$$$reportNull$$$0(6);
        }
        return invoker;
    }

    private boolean isValidThread() {
        if (this.invoker.isValidThread()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException("StructureTreeModel is used from unexpected thread"));
        return false;
    }

    @NotNull
    private <Result> Promise<Result> onValidThread(@NotNull Function<Structure, Result> function) {
        if (function == null) {
            StructureTreeModel.$$$reportNull$$$0(7);
        }
        AsyncPromise promise = new AsyncPromise();
        this.invoker.runOrInvokeLater(() -> {
            Object result2;
            if (!this.disposed && (result2 = function.apply(this.structure)) != null) {
                promise.setResult(result2);
            }
            if (!promise.isDone()) {
                promise.cancel();
            }
        }).onError(arg_0 -> ((AsyncPromise)promise).setError(arg_0));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            StructureTreeModel.$$$reportNull$$$0(8);
        }
        return asyncPromise;
    }

    @NotNull
    private <Result> Promise<Result> onValidThread(@NotNull TreePath path, @NotNull Function<Node, Result> function) {
        Object component;
        if (path == null) {
            StructureTreeModel.$$$reportNull$$$0(9);
        }
        if (function == null) {
            StructureTreeModel.$$$reportNull$$$0(10);
        }
        if ((component = path.getLastPathComponent()) instanceof Node) {
            Node node = (Node)component;
            Promise<Object> promise = this.onValidThread(structure -> this.disposed || this.isNodeRemoved(node) ? null : function.apply(node));
            if (promise == null) {
                StructureTreeModel.$$$reportNull$$$0(11);
            }
            return promise;
        }
        Promise promise = Promises.rejectedPromise((String)("unexpected node: " + component));
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(12);
        }
        return promise;
    }

    @NotNull
    private <Result> Promise<Result> onValidThread(@NotNull Object element, @NotNull Function<Node, Result> function) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(13);
        }
        if (function == null) {
            StructureTreeModel.$$$reportNull$$$0(14);
        }
        Promise<Object> promise = this.onValidThread(structure -> {
            Node node = this.root.get();
            if (node == null) {
                return null;
            }
            if (node.matches(element)) {
                return function.apply(node);
            }
            ArrayDeque<Object> stack = new ArrayDeque<Object>();
            Object e = element;
            while (e != null) {
                stack.push(e);
                e = structure.getParentElement(e);
            }
            if (!node.matches(stack.pop())) {
                return null;
            }
            while (!stack.isEmpty()) {
                if ((node = node.findChild(stack.pop())) != null) continue;
                return null;
            }
            return function.apply(node);
        });
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(15);
        }
        return promise;
    }

    @NotNull
    public final Promise<?> invalidate() {
        Promise<TreePath> promise = this.onValidThread(structure -> this.invalidateInternal(null, true));
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(16);
        }
        return promise;
    }

    @NotNull
    public final Promise<TreePath> invalidate(@NotNull TreePath path, boolean structure) {
        if (path == null) {
            StructureTreeModel.$$$reportNull$$$0(17);
        }
        Promise<TreePath> promise = this.onValidThread(path, (Node node) -> this.invalidateInternal((Node)node, structure));
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(18);
        }
        return promise;
    }

    @NotNull
    public final Promise<TreePath> invalidate(@NotNull Object element, boolean structure) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(19);
        }
        Promise<TreePath> promise = this.onValidThread(element, (Node node) -> this.invalidateInternal((Node)node, structure));
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(20);
        }
        return promise;
    }

    @Nullable
    private TreePath invalidateInternal(@Nullable Node node, boolean structure) {
        assert (this.invoker.isValidThread());
        while (node != null && !this.isValid(node)) {
            LOG.debug("invalid element cannot be updated: ", new Object[]{node});
            node = (Node)node.getParent();
            structure = true;
        }
        if (node == null) {
            node = this.root.get();
            if (node != null) {
                node.invalidate();
            }
            this.root.invalidate();
            LOG.debug("root invalidated: ", new Object[]{node});
            this.treeStructureChanged(null, null, null);
            return ROOT_INVALIDATED;
        }
        boolean updated = node.update();
        if (structure) {
            node.invalidate();
            TreePath path = TreePathUtil.pathToTreeNode(node);
            this.treeStructureChanged(path, null, null);
            return path;
        }
        if (updated) {
            TreePath path = TreePathUtil.pathToTreeNode(node);
            this.treeNodesChanged(path, null, null);
            return path;
        }
        return null;
    }

    public final void expand(@NotNull Object element, @NotNull JTree tree, @NotNull Consumer<? super TreePath> consumer) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(21);
        }
        if (tree == null) {
            StructureTreeModel.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            StructureTreeModel.$$$reportNull$$$0(23);
        }
        this.promiseVisitor(element).onSuccess(visitor -> TreeUtil.expand((JTree)tree, (TreeVisitor)visitor, (Consumer)consumer));
    }

    public final void makeVisible(@NotNull Object element, @NotNull JTree tree, @NotNull Consumer<? super TreePath> consumer) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(24);
        }
        if (tree == null) {
            StructureTreeModel.$$$reportNull$$$0(25);
        }
        if (consumer == null) {
            StructureTreeModel.$$$reportNull$$$0(26);
        }
        this.promiseVisitor(element).onSuccess(visitor -> TreeUtil.makeVisible((JTree)tree, (TreeVisitor)visitor, (Consumer)consumer));
    }

    public final void select(@NotNull Object element, @NotNull JTree tree, @NotNull Consumer<? super TreePath> consumer) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(27);
        }
        if (tree == null) {
            StructureTreeModel.$$$reportNull$$$0(28);
        }
        if (consumer == null) {
            StructureTreeModel.$$$reportNull$$$0(29);
        }
        this.promiseVisitor(element).onSuccess(visitor -> TreeUtil.select((JTree)tree, (TreeVisitor)visitor, (Consumer)consumer));
    }

    @NotNull
    public final Promise<TreeVisitor> promiseVisitor(@NotNull Object element) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(30);
        }
        Promise<TreeVisitor> promise = this.onValidThread(structure -> new TreeVisitor.ByTreePath(TreePathUtil.pathToCustomNode(element, arg_0 -> ((AbstractTreeStructure)structure).getParentElement(arg_0)), node -> node instanceof Node ? ((Node)node).getElement() : null));
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(31);
        }
        return promise;
    }

    public final TreeNode getRoot() {
        if (this.disposed || !this.isValidThread()) {
            return null;
        }
        if (!this.root.isValid()) {
            Node newRoot = this.getValidRoot();
            this.root.set(newRoot);
            LOG.debug("root updated: ", new Object[]{newRoot});
        }
        return this.root.get();
    }

    private Node getNode(Object object, boolean validateChildren) {
        if (this.disposed || !(object instanceof Node) || !this.isValidThread()) {
            return null;
        }
        Node node = (Node)object;
        if (this.isNodeRemoved(node)) {
            return null;
        }
        if (validateChildren) {
            this.validateChildren(node);
        }
        return node;
    }

    private void validateChildren(@NotNull Node node) {
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(32);
        }
        if (!node.children.isValid()) {
            List<Node> newChildren = this.getValidChildren(node);
            List<Node> oldChildren = node.children.set(newChildren);
            if (oldChildren != null) {
                oldChildren.forEach(child2 -> child2.setParent(null));
            }
            if (newChildren != null) {
                newChildren.forEach(child2 -> child2.setParent(node));
            }
            LOG.debug("children updated: ", new Object[]{node});
        }
    }

    private boolean isNodeRemoved(@NotNull Node node) {
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(33);
        }
        return !node.isNodeAncestor(this.root.get());
    }

    @Override
    public final List<TreeNode> getChildren(Object object) {
        List list2;
        Node node = this.getNode(object, true);
        List list3 = list2 = node == null ? null : (List)node.children.get();
        if (list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        list2.forEach(rec$ -> ((Node)rec$).update());
        return Collections.unmodifiableList(list2);
    }

    public final int getChildCount(Object object) {
        Node node = this.getNode(object, true);
        return node == null ? 0 : node.getChildCount();
    }

    public final TreeNode getChild(Object object, int index) {
        Node node = this.getNode(object, true);
        return node == null ? null : node.getChildAt(index);
    }

    public final boolean isLeaf(Object object) {
        Node node = this.getNode(object, false);
        return node == null || node.isLeaf(this::validateChildren);
    }

    public final int getIndexOfChild(Object object, Object child2) {
        return object instanceof Node && child2 instanceof Node ? ((Node)object).getIndex((TreeNode)child2) : -1;
    }

    public void valueForPathChanged(TreePath path, Object value) {
    }

    private boolean isValid(@NotNull Node node) {
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(34);
        }
        return StructureTreeModel.isValid(this.structure, node.getElement());
    }

    private static boolean isValid(@NotNull AbstractTreeStructure structure, Object element) {
        AbstractTreeNode node;
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(35);
        }
        if (element == null) {
            return false;
        }
        if (element instanceof AbstractTreeNode && null == (node = (AbstractTreeNode)element).getValue()) {
            return false;
        }
        if (element instanceof ValidateableNode && !(node = (ValidateableNode)element).isValid()) {
            return false;
        }
        return structure.isValid(element);
    }

    @Nullable
    private Node getValidRoot() {
        Object element = this.structure.getRootElement();
        if (!StructureTreeModel.isValid(this.structure, element)) {
            return null;
        }
        Node newNode = new Node((AbstractTreeStructure)this.structure, element, null);
        Node oldNode = this.root.get();
        if (oldNode != null && oldNode.canReuse(newNode, element)) {
            return oldNode;
        }
        return newNode;
    }

    @Nullable
    private List<Node> getValidChildren(@NotNull Node node) {
        NodeDescriptor descriptor;
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(36);
        }
        if ((descriptor = node.getDescriptor()) == null) {
            return null;
        }
        Object parent = descriptor.getElement();
        if (!StructureTreeModel.isValid(this.structure, parent)) {
            return null;
        }
        Object[] elements = this.structure.getChildElements(parent);
        if (elements.length == 0) {
            return null;
        }
        ArrayList<Node> list2 = new ArrayList<Node>(elements.length);
        for (Object object : elements) {
            if (!StructureTreeModel.isValid(this.structure, object)) continue;
            list2.add(new Node((AbstractTreeStructure)this.structure, object, descriptor));
        }
        Comparator<? super Node> comparator2 = this.comparator;
        if (comparator2 != null) {
            try {
                list2.sort(comparator2);
            }
            catch (IllegalArgumentException exception) {
                StringBuilder sb = new StringBuilder("unexpected sorting failed in ");
                sb.append(this);
                for (Node next : list2) {
                    sb.append('\n').append(next);
                }
                LOG.error(sb.toString(), (Throwable)exception);
            }
        }
        HashMap map2 = new HashMap();
        node.getChildren().forEach(child2 -> {
            Object element = ((Node)child2).getElement();
            if (element != null) {
                map2.put(element, child2);
            }
        });
        for (int i = 0; i < list2.size(); ++i) {
            Node node2 = (Node)list2.get(i);
            Node oldNode = (Node)map2.get(node2.getElement());
            if (oldNode == null || !oldNode.canReuse(node2, null)) continue;
            list2.set(i, oldNode);
        }
        return list2;
    }

    @Deprecated
    public final TreeNode getRootImmediately() {
        if (!this.root.isValid()) {
            this.root.set(this.getValidRoot());
        }
        return this.root.get();
    }

    public String toString() {
        return this.description;
    }

    @NotNull
    private static String format(@NotNull String prefix) {
        if (prefix == null) {
            StructureTreeModel.$$$reportNull$$$0(37);
        }
        for (StackTraceElement element : new Exception().getStackTrace()) {
            if (StructureTreeModel.class.getName().equals(element.getClassName())) continue;
            String string = prefix + " @ " + element.getFileName() + " : " + element.getLineNumber();
            if (string == null) {
                StructureTreeModel.$$$reportNull$$$0(38);
            }
            return string;
        }
        String string = prefix;
        if (string == null) {
            StructureTreeModel.$$$reportNull$$$0(39);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 31: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 31: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 31: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/StructureTreeModel";
                break;
            }
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/StructureTreeModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapToNodeComparator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "onValidThread";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "invalidate";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseVisitor";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapToNodeComparator";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 31: 
            case 38: 
            case 39: {
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onValidThread";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "makeVisible";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "promiseVisitor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "validateChildren";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isNodeRemoved";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getValidChildren";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 31: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Node
    extends DefaultMutableTreeNode {
        private final Reference<List<Node>> children;
        private final LeafState leafState;
        private final int hashCode;

        private Node(@NotNull AbstractTreeStructure structure, @NotNull Object element, NodeDescriptor parent) {
            if (structure == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (element == null) {
                Node.$$$reportNull$$$0(1);
            }
            this(structure.createDescriptor(element, parent), structure.getLeafState(element), element.hashCode());
        }

        private Node(@NotNull NodeDescriptor descriptor, @NotNull LeafState leafState, int hashCode) {
            if (descriptor == null) {
                Node.$$$reportNull$$$0(2);
            }
            if (leafState == null) {
                Node.$$$reportNull$$$0(3);
            }
            super(descriptor, leafState != LeafState.ALWAYS);
            this.children = new Reference();
            this.leafState = leafState;
            this.hashCode = hashCode;
            if (leafState == LeafState.ALWAYS) {
                this.children.set(null);
            }
            this.update();
        }

        private void dispose() {
            this.setParent(null);
            List list2 = this.children.set(null);
            if (list2 != null) {
                list2.forEach(Node::dispose);
            }
        }

        private boolean canReuse(@NotNull Node node, Object element) {
            if (node == null) {
                Node.$$$reportNull$$$0(4);
            }
            if (this.leafState != node.leafState || this.hashCode != node.hashCode) {
                return false;
            }
            if (element != null && !this.matches(element)) {
                return false;
            }
            this.userObject = node.userObject;
            return true;
        }

        private boolean update() {
            NodeDescriptor descriptor = this.getDescriptor();
            return descriptor != null && descriptor.update();
        }

        private void invalidate() {
            if (this.leafState != LeafState.ALWAYS) {
                this.children.invalidate();
                LOG.debug("node invalidated: ", new Object[]{this});
                this.getChildren().forEach(Node::invalidate);
            }
        }

        private boolean matches(@NotNull Object element) {
            if (element == null) {
                Node.$$$reportNull$$$0(5);
            }
            return this.matches(element, element.hashCode());
        }

        private boolean matches(@NotNull Object element, int hashCode) {
            if (element == null) {
                Node.$$$reportNull$$$0(6);
            }
            return this.hashCode == hashCode && element.equals(this.getElement());
        }

        private Node findChild(@NotNull Object element) {
            List<Node> list2;
            if (element == null) {
                Node.$$$reportNull$$$0(7);
            }
            if ((list2 = this.children.get()) != null) {
                if (!list2.isEmpty()) {
                    int hashCode = element.hashCode();
                    Optional<Node> result2 = list2.stream().filter(node -> node.matches(element, hashCode)).findFirst();
                    if (result2.isPresent()) {
                        return result2.get();
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.debug("node '", new Object[]{this.getElement(), "' have no child: ", element});
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.debug("node '", new Object[]{this.getElement(), "' have no loaded children"});
            }
            return null;
        }

        @NotNull
        private List<Node> getChildren() {
            List<Node> list2 = this.children.get();
            List<Node> list3 = list2 != null ? list2 : Collections.emptyList();
            if (list3 == null) {
                Node.$$$reportNull$$$0(8);
            }
            return list3;
        }

        private NodeDescriptor getDescriptor() {
            Object object = this.getUserObject();
            return object instanceof NodeDescriptor ? (NodeDescriptor)object : null;
        }

        private Object getElement() {
            NodeDescriptor descriptor = this.getDescriptor();
            return descriptor == null ? null : descriptor.getElement();
        }

        @Override
        public void setUserObject(Object object) {
            throw new UnsupportedOperationException("cannot modify node");
        }

        @Override
        public void setAllowsChildren(boolean value) {
            throw new UnsupportedOperationException("cannot modify node");
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException("cannot clone node");
        }

        @Override
        public void insert(MutableTreeNode child2, int index) {
            throw new UnsupportedOperationException("cannot insert node");
        }

        @Override
        public void remove(int index) {
            throw new UnsupportedOperationException("cannot remove node");
        }

        public Enumeration children() {
            return Collections.enumeration(this.getChildren());
        }

        @Override
        public TreeNode getChildAt(int index) {
            List<Node> list2 = this.getChildren();
            return 0 <= index && index < list2.size() ? (TreeNode)list2.get(index) : null;
        }

        @Override
        public int getChildCount() {
            return this.getChildren().size();
        }

        @Override
        public boolean isLeaf() {
            return this.isLeaf(null);
        }

        private boolean isLeaf(@Nullable Consumer<Node> validator) {
            if (null == this.getParent()) {
                return false;
            }
            if (this.leafState == LeafState.ALWAYS) {
                return true;
            }
            if (this.leafState == LeafState.NEVER) {
                return false;
            }
            if (this.leafState == LeafState.DEFAULT && validator != null) {
                validator.accept(this);
            }
            return this.children.isValid() && super.isLeaf();
        }

        @Override
        public int getIndex(@NotNull TreeNode child2) {
            if (child2 == null) {
                Node.$$$reportNull$$$0(9);
            }
            return child2 instanceof Node && this.isNodeChild(child2) ? this.getChildren().indexOf(child2) : -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structure";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leafState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/StructureTreeModel$Node";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/StructureTreeModel$Node";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canReuse";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findChild";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndex";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

