/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ProfilingInfo;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.NotNullList;
import gnu.trove.TLongArrayList;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedValueBase<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.CachedValueImpl");
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"cachedValue");
    private volatile SoftReference<Data<T>> myData;

    private Data<T> computeData(@Nullable CachedValueProvider.Result<T> result2) {
        ProfilingInfo profilingInfo;
        long[] inferredTimeStamps;
        Object[] inferredDependencies;
        Object value = result2 == null ? null : result2.getValue();
        Object[] dependencies = this.getDependencies(result2);
        if (dependencies == null) {
            inferredDependencies = null;
            inferredTimeStamps = null;
        } else {
            TLongArrayList timeStamps = new TLongArrayList(dependencies.length);
            NotNullList deps = new NotNullList(dependencies.length);
            this.collectDependencies(timeStamps, (List<Object>)deps, dependencies);
            inferredDependencies = ArrayUtil.toObjectArray((Collection)deps);
            inferredTimeStamps = timeStamps.toNativeArray();
        }
        if (result2 != null && CachedValueProfiler.canProfile() && (profilingInfo = CachedValueProfiler.getInstance().getTemporaryInfo(result2)) != null) {
            return new ProfilingData(value, inferredDependencies, inferredTimeStamps, profilingInfo);
        }
        return new Data<Object>(value, inferredDependencies, inferredTimeStamps);
    }

    @Nullable
    private synchronized Data<T> cacheOrGetData(@Nullable Data<T> expected, @Nullable Data<T> updatedValue) {
        if (expected != this.getRawData()) {
            return null;
        }
        if (updatedValue != null) {
            this.myData = new SoftReference(updatedValue);
            return updatedValue;
        }
        return expected;
    }

    private synchronized void setData(@Nullable Data<T> data) {
        this.myData = new SoftReference(data);
    }

    @Nullable
    protected Object[] getDependencies(CachedValueProvider.Result<T> result2) {
        return result2 == null ? null : result2.getDependencyItems();
    }

    @Nullable
    protected Object[] getDependenciesPlusValue(CachedValueProvider.Result<? extends T> result2) {
        if (result2 == null) {
            return null;
        }
        Object[] items = result2.getDependencyItems();
        Object value = result2.getValue();
        return value == null ? items : ArrayUtil.append((Object[])items, (Object)value);
    }

    public void clear() {
        this.setData(null);
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull() != null;
    }

    @Nullable
    public final Data<T> getUpToDateOrNull() {
        Data<T> data = this.getRawData();
        if (data != null) {
            if (this.isUpToDate(data)) {
                return data;
            }
            if (data instanceof ProfilingData) {
                ((ProfilingData)data).myProfilingInfo.valueDisposed();
            }
        }
        return null;
    }

    @Nullable
    final Data<T> getRawData() {
        return (Data)SoftReference.dereference(this.myData);
    }

    protected boolean isUpToDate(@NotNull Data data) {
        if (data == null) {
            CachedValueBase.$$$reportNull$$$0(0);
        }
        if (data.myTimeStamps == null) {
            return true;
        }
        for (int i = 0; i < data.myDependencies.length; ++i) {
            Object dependency = data.myDependencies[i];
            if (dependency == null || !this.isDependencyOutOfDate(dependency, data.myTimeStamps[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(Object dependency, long oldTimeStamp) {
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private void collectDependencies(TLongArrayList timeStamps, List<Object> resultingDeps, Object[] dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == null || dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                this.collectDependencies(timeStamps, resultingDeps, (Object[])dependency);
                continue;
            }
            resultingDeps.add(dependency);
            timeStamps.add(this.getTimeStamp(dependency));
        }
    }

    protected long getTimeStamp(Object dependency) {
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        LOG.error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(CachedValueProvider.Result<T> result2) {
        Data<T> data = this.computeData(result2);
        this.setData(data);
        this.valueUpdated(result2.getDependencyItems());
        return data.getValue();
    }

    protected void valueUpdated(@Nullable Object[] dependencies) {
    }

    public abstract boolean isFromMyProject(Project var1);

    @Nullable
    protected <P> T getValueWithLock(P param) {
        Data data = this.getUpToDateOrNull();
        if (data != null) {
            return data.getValue();
        }
        RecursionGuard.StackStamp stamp = ourGuard.markStack();
        Computable calcData = () -> this.computeData(this.doCompute(param));
        data = (Data)ourGuard.doPreventingRecursion((Object)this, true, calcData);
        if (data == null) {
            data = (Data)calcData.compute();
        } else if (stamp.mayCacheNow()) {
            boolean reuse;
            Data<T> alreadyComputed;
            Data<T> toReturn;
            while ((toReturn = this.cacheOrGetData(alreadyComputed, (reuse = (alreadyComputed = this.getRawData()) != null && this.isUpToDate(alreadyComputed)) ? null : data)) == null) {
            }
            this.valueUpdated(((Data)toReturn).myDependencies);
            return toReturn.getValue();
        }
        return data.getValue();
    }

    protected abstract <P> CachedValueProvider.Result<T> doCompute(P var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/util/CachedValueBase", "isUpToDate"));
    }

    private static class ProfilingData<T>
    extends Data<T> {
        @NotNull
        private final ProfilingInfo myProfilingInfo;

        private ProfilingData(T value, Object[] dependencies, long[] timeStamps, @NotNull ProfilingInfo profilingInfo) {
            if (profilingInfo == null) {
                ProfilingData.$$$reportNull$$$0(0);
            }
            super(value, dependencies, timeStamps);
            this.myProfilingInfo = profilingInfo;
        }

        @Override
        public T getValue() {
            this.myProfilingInfo.valueUsed();
            return super.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilingInfo", "com/intellij/util/CachedValueBase$ProfilingData", "<init>"));
        }
    }

    protected static class Data<T>
    implements Getter<T> {
        private final T myValue;
        private final Object[] myDependencies;
        private final long[] myTimeStamps;

        Data(T value, Object[] dependencies, long[] timeStamps) {
            this.myValue = value;
            this.myDependencies = dependencies;
            this.myTimeStamps = timeStamps;
        }

        public final T get() {
            return this.getValue();
        }

        public T getValue() {
            return this.myValue;
        }
    }
}

