/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.PopupUtilsKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a+\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\b\u0012H\u0002\u001a$\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\n\b\u0000\u0010\u0014\u0018\u0001*\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0082\b\u00a2\u0006\u0002\u0010\u0016\u001a\f\u0010\u0017\u001a\u00020\u0011*\u00020\u0010H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0011*\u00020\u0010H\u0002\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002\u001a\f\u0010\u001c\u001a\u00020\u0011*\u00020\u0010H\u0002\u001a\f\u0010\u001d\u001a\u00020\u0011*\u00020\u0010H\u0002\u00a8\u0006\u001e"}, d2={"getBestBalloonPosition", "Lcom/intellij/ui/awt/RelativePoint;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getBestBalloonPositionInsideComponent", "getBestBalloonPositionInsideEditor", "getBestBalloonPositionInsideGutter", "getBestBalloonPositionInsideList", "getBestBalloonPositionInsideTable", "getBestBalloonPositionInsideTree", "getBestPopupPosition", "getBestPopupPositionInsideComponent", "getBestPopupPositionInsideGutter", "getBestPositionInsideGutter", "location", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "Ljava/awt/Point;", "Lkotlin/ExtensionFunctionType;", "getFocusComponent", "C", "Ljavax/swing/JComponent;", "(Lcom/intellij/openapi/actionSystem/DataContext;)Ljavax/swing/JComponent;", "bottomCenter", "center", "getCaretVisualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "Lcom/intellij/openapi/editor/Editor;", "position", "topCenter", "intellij.platform.ide.impl"})
public final class PopupUtilsKt {
    @NotNull
    public static final RelativePoint getBestPopupPosition(@NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        RelativePoint relativePoint = PopupUtilsKt.getBestPopupPositionInsideGutter(context);
        if (relativePoint == null) {
            relativePoint = PopupUtilsKt.getBestPopupPositionInsideComponent(context);
        }
        return relativePoint;
    }

    @NotNull
    public static final RelativePoint getBestBalloonPosition(@NotNull DataContext context) {
        RelativePoint relativePoint;
        RelativePoint relativePoint2;
        RelativePoint relativePoint3;
        RelativePoint relativePoint4;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        RelativePoint relativePoint5 = PopupUtilsKt.getBestBalloonPositionInsideGutter(context);
        if (relativePoint5 == null) {
            relativePoint5 = relativePoint4 = PopupUtilsKt.getBestBalloonPositionInsideEditor(context);
        }
        if (relativePoint5 == null) {
            relativePoint4 = relativePoint3 = PopupUtilsKt.getBestBalloonPositionInsideList(context);
        }
        if (relativePoint4 == null) {
            relativePoint3 = relativePoint2 = PopupUtilsKt.getBestBalloonPositionInsideTree(context);
        }
        if (relativePoint3 == null) {
            relativePoint2 = relativePoint = PopupUtilsKt.getBestBalloonPositionInsideTable(context);
        }
        if (relativePoint2 == null) {
            relativePoint = PopupUtilsKt.getBestBalloonPositionInsideComponent(context);
        }
        return relativePoint;
    }

    private static final RelativePoint getBestPopupPositionInsideGutter(DataContext context) {
        return PopupUtilsKt.getBestPositionInsideGutter(context, (Function1<? super Rectangle, ? extends Point>)((Function1)getBestPopupPositionInsideGutter.1.INSTANCE));
    }

    private static final RelativePoint getBestPopupPositionInsideComponent(DataContext context) {
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(context);
        Intrinsics.checkExpressionValueIsNotNull((Object)relativePoint, (String)"JBPopupFactory.getInstan\u2026estPopupLocation(context)");
        return relativePoint;
    }

    private static final RelativePoint getBestBalloonPositionInsideGutter(DataContext context) {
        return PopupUtilsKt.getBestPositionInsideGutter(context, (Function1<? super Rectangle, ? extends Point>)((Function1)getBestBalloonPositionInsideGutter.1.INSTANCE));
    }

    private static final RelativePoint getBestPositionInsideGutter(DataContext context, Function1<? super Rectangle, ? extends Point> location) {
        JComponent jComponent;
        boolean $i$f$getFocusComponent = false;
        Component component$iv = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
        if (component$iv instanceof EditorGutterComponentEx) {
            jComponent = (JComponent)component$iv;
        } else {
            JFrame frame$iv;
            JFrame jFrame;
            Project project$iv;
            Project project = project$iv = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project != null) {
                Project project2;
                Project it$iv = project2 = project;
                boolean bl = false;
                jFrame = WindowManager.getInstance().getFrame(it$iv);
            } else {
                jFrame = null;
            }
            JFrame jFrame2 = frame$iv = jFrame;
            JRootPane focusOwner$iv = jFrame2 != null ? jFrame2.getRootPane() : null;
            jComponent = focusOwner$iv instanceof EditorGutterComponentEx ? (JComponent)focusOwner$iv : null;
        }
        EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)jComponent;
        if (editorGutterComponentEx == null) {
            return null;
        }
        EditorGutterComponentEx component = editorGutterComponentEx;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"CommonDataKeys.EDITOR.ge\u2026a(context) ?: return null");
        Editor editor2 = editor;
        Integer n = (Integer)context.getData(EditorGutterComponentEx.LOGICAL_LINE_AT_CURSOR);
        if (n == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"context.getData(LOGICAL_\u2026AT_CURSOR) ?: return null");
        int logicalLine = n;
        Point point = (Point)context.getData(EditorGutterComponentEx.ICON_CENTER_POSITION);
        if (point == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"context.getData(ICON_CEN\u2026_POSITION) ?: return null");
        Point iconCenterPosition = point;
        GutterMark gutterMark = component.getGutterRenderer(iconCenterPosition);
        if (gutterMark == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gutterMark, (String)"component.getGutterRende\u2026rPosition) ?: return null");
        GutterMark renderer2 = gutterMark;
        int visualLine = EditorUtil.logicalToVisualLine(editor2, logicalLine);
        Rectangle visibleArea = component.getVisibleRect();
        int n2 = iconCenterPosition.x;
        Icon icon = renderer2.getIcon();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"renderer.icon");
        int x = n2 - icon.getIconWidth() / 2;
        int n3 = visualLine * editor2.getLineHeight();
        Icon icon2 = renderer2.getIcon();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"renderer.icon");
        Rectangle rect = new Rectangle(x, n3, icon2.getIconWidth(), editor2.getLineHeight());
        if (!visibleArea.contains(rect)) {
            component.scrollRectToVisible(rect);
        }
        return new RelativePoint((Component)component, (Point)location.invoke((Object)rect));
    }

    private static final RelativePoint getBestBalloonPositionInsideEditor(DataContext context) {
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"CommonDataKeys.EDITOR.ge\u2026a(context) ?: return null");
        Editor editor2 = editor;
        JComponent jComponent = editor2.getContentComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"editor.contentComponent");
        JComponent contentComponent = jComponent;
        if (contentComponent != component) {
            return null;
        }
        VisualPosition caretVisualPosition = PopupUtilsKt.getCaretVisualPosition(editor2);
        Point point = editor2.visualPositionToXY(caretVisualPosition);
        Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"editor.visualPositionToXY(caretVisualPosition)");
        Point caretPosition = point;
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)scrollingModel, (String)"editor.scrollingModel");
        Rectangle rectangle = scrollingModel.getVisibleArea();
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"editor.scrollingModel.visibleArea");
        Rectangle visibleArea = rectangle;
        Rectangle rect = new Rectangle(caretPosition, new Dimension(EditorUtil.getDefaultCaretWidth(), editor2.getLineHeight()));
        if (!visibleArea.contains(rect)) {
            ((JComponent)component).scrollRectToVisible(rect);
        }
        return new RelativePoint((Component)contentComponent, caretPosition);
    }

    private static final VisualPosition getCaretVisualPosition(@NotNull Editor $receiver) {
        VisualPosition anchorPosition = (VisualPosition)$receiver.getUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION);
        if (anchorPosition != null) {
            return anchorPosition;
        }
        CaretModel caretModel = $receiver.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"caretModel");
        if (caretModel.isUpToDate()) {
            CaretModel caretModel2 = $receiver.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel2, (String)"caretModel");
            VisualPosition visualPosition = caretModel2.getVisualPosition();
            Intrinsics.checkExpressionValueIsNotNull((Object)visualPosition, (String)"caretModel.visualPosition");
            return visualPosition;
        }
        CaretModel caretModel3 = $receiver.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel3, (String)"caretModel");
        VisualPosition visualPosition = $receiver.offsetToVisualPosition(caretModel3.getOffset());
        Intrinsics.checkExpressionValueIsNotNull((Object)visualPosition, (String)"offsetToVisualPosition(caretModel.offset)");
        return visualPosition;
    }

    private static final RelativePoint getBestBalloonPositionInsideList(DataContext context) {
        int[] selectedIndices;
        JComponent jComponent;
        boolean $i$f$getFocusComponent = false;
        Component component$iv = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
        if (component$iv instanceof JList) {
            jComponent = (JComponent)component$iv;
        } else {
            JFrame frame$iv;
            JFrame jFrame;
            Project project$iv;
            Project project = project$iv = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project != null) {
                Project project2;
                Project it$iv = project2 = project;
                boolean bl = false;
                jFrame = WindowManager.getInstance().getFrame(it$iv);
            } else {
                jFrame = null;
            }
            JFrame jFrame2 = frame$iv = jFrame;
            JRootPane focusOwner$iv = jFrame2 != null ? jFrame2.getRootPane() : null;
            jComponent = focusOwner$iv instanceof JList ? (JComponent)focusOwner$iv : null;
        }
        JList jList = (JList)jComponent;
        if (jList == null) {
            return null;
        }
        JList component = jList;
        Rectangle visibleRect = component.getVisibleRect();
        int firstVisibleIndex = component.getFirstVisibleIndex();
        int lastVisibleIndex = component.getLastVisibleIndex();
        for (int index : selectedIndices = component.getSelectedIndices()) {
            int n = index;
            if (firstVisibleIndex > n || lastVisibleIndex < n) continue;
            Rectangle cellBounds = component.getCellBounds(index, index);
            Point position = new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y);
            return new RelativePoint((Component)component, position);
        }
        return null;
    }

    private static final RelativePoint getBestBalloonPositionInsideTree(DataContext context) {
        Object focusOwner$iv;
        Object frame$iv;
        JComponent jComponent;
        boolean $i$f$getFocusComponent = false;
        Component component$iv = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
        if (component$iv instanceof JTree) {
            jComponent = (JComponent)component$iv;
        } else {
            JFrame jFrame;
            Project project$iv;
            Project project = project$iv = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project != null) {
                Project project2;
                Project it$iv = project2 = project;
                boolean bl = false;
                jFrame = WindowManager.getInstance().getFrame(it$iv);
            } else {
                jFrame = null;
            }
            frame$iv = jFrame;
            JFrame jFrame2 = frame$iv;
            focusOwner$iv = jFrame2 != null ? jFrame2.getRootPane() : null;
            jComponent = focusOwner$iv instanceof JTree ? (JComponent)focusOwner$iv : null;
        }
        JTree jTree = (JTree)jComponent;
        if (jTree == null) {
            return null;
        }
        JTree component = jTree;
        Rectangle visibleRect = component.getVisibleRect();
        int[] nArray = component.getSelectionRows();
        if (nArray == null) {
            return null;
        }
        int[] selectionRows = nArray;
        focusOwner$iv = ArraysKt.sorted((int[])selectionRows).iterator();
        while (focusOwner$iv.hasNext()) {
            int row2 = ((Number)focusOwner$iv.next()).intValue();
            Rectangle rowBounds = component.getRowBounds(row2);
            if (!visibleRect.contains(rowBounds)) continue;
            Component component2 = component;
            Rectangle rectangle = rowBounds;
            Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"rowBounds");
            return new RelativePoint(component2, PopupUtilsKt.topCenter(rectangle));
        }
        Rectangle rectangle = visibleRect;
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"visibleRect");
        Point visibleCenter = PopupUtilsKt.center(rectangle);
        Function1 distance2 = (Function1)new Function1<Integer, Double>(visibleCenter, component){
            final /* synthetic */ Point $visibleCenter;
            final /* synthetic */ JTree $component;

            public final double invoke(int it) {
                Rectangle rectangle = this.$component.getRowBounds(it);
                Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"component.getRowBounds(it)");
                return this.$visibleCenter.distance(PopupUtilsKt.access$center(rectangle));
            }
            {
                this.$visibleCenter = point;
                this.$component = jTree;
                super(1);
            }
        };
        int[] $receiver$iv = selectionRows;
        frame$iv = $receiver$iv;
        Comparator comparator2 = new Comparator<T>(distance2){
            final /* synthetic */ Function1 $selector;
            {
                this.$selector = function1;
            }

            public final int compare(T a, T b) {
                return ComparisonsKt.compareValues((Comparable)((Comparable)this.$selector.invoke(a)), (Comparable)((Comparable)this.$selector.invoke(b)));
            }
        };
        Integer n = (Integer)CollectionsKt.firstOrNull((List)ArraysKt.sortedWith((int[])frame$iv, (Comparator)comparator2));
        if (n == null) {
            return null;
        }
        int nearestRow = n;
        Rectangle rowBounds = component.getRowBounds(nearestRow);
        Dimension dimension = new Dimension(Math.min(visibleRect.width, rowBounds.width), rowBounds.height);
        Rectangle rectangle2 = rowBounds;
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle2, (String)"rowBounds");
        component.scrollRectToVisible(new Rectangle(PopupUtilsKt.position(rectangle2), dimension));
        return new RelativePoint((Component)component, PopupUtilsKt.topCenter(rowBounds));
    }

    private static final RelativePoint getBestBalloonPositionInsideTable(DataContext context) {
        JComponent jComponent;
        boolean $i$f$getFocusComponent = false;
        Component component$iv = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
        if (component$iv instanceof JTable) {
            jComponent = (JComponent)component$iv;
        } else {
            JFrame frame$iv;
            JFrame jFrame;
            Project project$iv;
            Project project = project$iv = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project != null) {
                Project project2;
                Project it$iv = project2 = project;
                boolean bl = false;
                jFrame = WindowManager.getInstance().getFrame(it$iv);
            } else {
                jFrame = null;
            }
            JFrame jFrame2 = frame$iv = jFrame;
            JRootPane focusOwner$iv = jFrame2 != null ? jFrame2.getRootPane() : null;
            jComponent = focusOwner$iv instanceof JTable ? (JComponent)focusOwner$iv : null;
        }
        JTable jTable = (JTable)jComponent;
        if (jTable == null) {
            return null;
        }
        JTable component = jTable;
        Rectangle visibleRect = component.getVisibleRect();
        TableColumnModel tableColumnModel = component.getColumnModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)tableColumnModel, (String)"component.columnModel");
        ListSelectionModel listSelectionModel = tableColumnModel.getSelectionModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionModel, (String)"component.columnModel.selectionModel");
        int column = listSelectionModel.getLeadSelectionIndex();
        ListSelectionModel listSelectionModel2 = component.getSelectionModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionModel2, (String)"component.selectionModel");
        int n = listSelectionModel2.getLeadSelectionIndex();
        ListSelectionModel listSelectionModel3 = component.getSelectionModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionModel3, (String)"component.selectionModel");
        int row2 = Math.max(n, listSelectionModel3.getAnchorSelectionIndex());
        Rectangle rect = component.getCellRect(row2, column, false);
        if (!visibleRect.intersects(rect)) {
            component.scrollRectToVisible(rect);
        }
        Component component2 = component;
        Rectangle rectangle = rect;
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"rect");
        return new RelativePoint(component2, PopupUtilsKt.position(rectangle));
    }

    private static final RelativePoint getBestBalloonPositionInsideComponent(DataContext context) {
        JComponent jComponent;
        boolean $i$f$getFocusComponent = false;
        Component component$iv = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
        if (component$iv instanceof JComponent) {
            jComponent = (JComponent)component$iv;
        } else {
            JFrame frame$iv;
            JFrame jFrame;
            Project project$iv;
            Project project = project$iv = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project != null) {
                Project project2;
                Project it$iv = project2 = project;
                boolean bl = false;
                jFrame = WindowManager.getInstance().getFrame(it$iv);
            } else {
                jFrame = null;
            }
            JFrame jFrame2 = frame$iv = jFrame;
            JRootPane focusOwner$iv = jFrame2 != null ? jFrame2.getRootPane() : null;
            jComponent = focusOwner$iv instanceof JComponent ? (JComponent)focusOwner$iv : null;
        }
        if (jComponent == null) {
            Intrinsics.throwNpe();
        }
        JComponent component = jComponent;
        Component component2 = component;
        Rectangle rectangle = component.getVisibleRect();
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"component.visibleRect");
        return new RelativePoint(component2, PopupUtilsKt.center(rectangle));
    }

    private static final <C extends JComponent> C getFocusComponent(DataContext context) {
        JFrame frame;
        JFrame jFrame;
        Project project;
        int $i$f$getFocusComponent = 0;
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
        Intrinsics.reifiedOperationMarker((int)3, (String)"C");
        if (component instanceof JComponent) {
            return (C)((JComponent)component);
        }
        Project project2 = project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project2 != null) {
            Project project3;
            Project it = project3 = project2;
            boolean bl = false;
            jFrame = WindowManager.getInstance().getFrame(it);
        } else {
            jFrame = null;
        }
        JFrame jFrame2 = frame = jFrame;
        JRootPane focusOwner = jFrame2 != null ? jFrame2.getRootPane() : null;
        Intrinsics.reifiedOperationMarker((int)3, (String)"C");
        if (focusOwner instanceof JComponent) {
            return (C)focusOwner;
        }
        return null;
    }

    private static final Point topCenter(@NotNull Rectangle $receiver) {
        return new Point((int)$receiver.getCenterX(), $receiver.y);
    }

    private static final Point bottomCenter(@NotNull Rectangle $receiver) {
        return new Point((int)$receiver.getCenterX(), $receiver.y + $receiver.height);
    }

    private static final Point center(@NotNull Rectangle $receiver) {
        return new Point((int)$receiver.getCenterX(), (int)$receiver.getCenterY());
    }

    private static final Point position(@NotNull Rectangle $receiver) {
        return new Point($receiver.x, $receiver.y);
    }

    public static final /* synthetic */ Point access$bottomCenter(Rectangle $receiver) {
        return PopupUtilsKt.bottomCenter($receiver);
    }

    public static final /* synthetic */ Point access$topCenter(Rectangle $receiver) {
        return PopupUtilsKt.topCenter($receiver);
    }

    public static final /* synthetic */ Point access$center(Rectangle $receiver) {
        return PopupUtilsKt.center($receiver);
    }
}

