/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AdditionalIndexableFileSet
implements IndexableFileSet {
    private final Project myProject;
    private volatile Set<VirtualFile> cachedFiles;
    private volatile Set<VirtualFile> cachedDirectories;
    private volatile IndexableSetContributor[] myExtensions;

    public AdditionalIndexableFileSet(@NotNull Project project, IndexableSetContributor ... extensions) {
        if (project == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(0);
        }
        if (extensions == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myExtensions = extensions;
    }

    public AdditionalIndexableFileSet(@NotNull Project project) {
        if (project == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    AdditionalIndexableFileSet(IndexableSetContributor ... extensions) {
        if (extensions == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(3);
        }
        this.myProject = null;
        this.myExtensions = extensions;
    }

    public AdditionalIndexableFileSet() {
        this.myProject = null;
    }

    @NotNull
    private Set<VirtualFile> getDirectories() {
        Set<VirtualFile> directories = this.cachedDirectories;
        if (directories == null || VfsUtilCore.hasInvalidFiles(directories) || VfsUtilCore.hasInvalidFiles(this.cachedFiles)) {
            directories = this.collectFilesAndDirectories();
        }
        Set<VirtualFile> set2 = directories;
        if (set2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @NotNull
    private Set<VirtualFile> collectFilesAndDirectories() {
        if (this.myExtensions == null) {
            this.myExtensions = (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions();
        }
        THashSet files2 = new THashSet();
        THashSet directories = new THashSet();
        for (IndexableSetContributor contributor : this.myExtensions) {
            for (VirtualFile root : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                (root.isDirectory() ? directories : files2).add(root);
            }
            if (this.myProject == null) continue;
            Set projectRoots = IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)contributor, (Project)this.myProject);
            for (VirtualFile root : projectRoots) {
                (root.isDirectory() ? directories : files2).add(root);
            }
        }
        this.cachedFiles = files2;
        this.cachedDirectories = directories;
        THashSet tHashSet = directories;
        if (tHashSet == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(5);
        }
        return tHashSet;
    }

    public boolean isInSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(6);
        }
        return VfsUtilCore.isUnder((VirtualFile)file2, this.getDirectories()) || this.cachedFiles.contains(file2);
    }

    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
        if (file2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(7);
        }
        if (iterator == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(8);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!AdditionalIndexableFileSet.this.isInSet(file2)) {
                    return false;
                }
                if (!file2.isDirectory()) {
                    iterator.processFile(file2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/AdditionalIndexableFileSet$1", "visitFile"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/AdditionalIndexableFileSet";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/AdditionalIndexableFileSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilesAndDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInSet";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexableFilesIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

