/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.CompressionUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.ContentHashesSupport;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.ByteSequenceDataExternalizer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class SnapshotInputMappings<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(SnapshotInputMappings.class);
    private static final boolean doReadSavedPersistentData = SystemProperties.getBooleanProperty((String)"idea.read.saved.persistent.index", (boolean)true);
    private final ID<Key, Value> myIndexId;
    private final VfsAwareMapReduceIndex.MapDataExternalizer<Key, Value> myMapExternalizer;
    private final DataIndexer<Key, Value, Input> myIndexer;
    private volatile PersistentHashMap<Integer, ByteArraySequence> myContents;
    private volatile PersistentHashMap<Integer, Integer> myInputsSnapshotMapping;
    private volatile PersistentHashMap<Integer, String> myIndexingTrace;
    private final boolean myIsPsiBackedIndex;
    private static final Key<Integer> ourSavedContentHashIdKey = Key.create((String)"saved.content.hash.id");
    private static final Key<Integer> ourSavedUncommittedHashIdKey = Key.create((String)"saved.uncommitted.hash.id");
    private static final ThreadLocalCachedByteArray ourSpareByteArray = new ThreadLocalCachedByteArray();

    SnapshotInputMappings(IndexExtension<Key, Value, Input> indexExtension) throws IOException {
        this.myIndexId = (ID)indexExtension.getName();
        this.myIsPsiBackedIndex = indexExtension instanceof PsiDependentIndex;
        this.myMapExternalizer = new VfsAwareMapReduceIndex.MapDataExternalizer<Key, Value>(indexExtension);
        this.myIndexer = indexExtension.getIndexer();
        this.createMaps();
    }

    @NotNull
    Map<Key, Value> readInputKeys(int inputId) throws IOException {
        ByteArraySequence byteSequence;
        Integer currentHashId = this.readInputHashId(inputId);
        if (currentHashId != null && (byteSequence = this.readContents(currentHashId)) != null) {
            Map<Key, Value> map2 = this.deserializeSavedPersistentData(byteSequence);
            if (map2 == null) {
                SnapshotInputMappings.$$$reportNull$$$0(0);
            }
            return map2;
        }
        Map map3 = Collections.emptyMap();
        if (map3 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(1);
        }
        return map3;
    }

    @NotNull
    Snapshot<Key, Value> readPersistentDataOrMap(@NotNull Input content) {
        int hashId;
        if (content == null) {
            SnapshotInputMappings.$$$reportNull$$$0(2);
        }
        Map data = null;
        boolean havePersistentData = false;
        boolean skippedReadingPersistentDataButMayHaveIt = false;
        try {
            FileContent fileContent = (FileContent)content;
            hashId = this.getHashOfContent(fileContent);
            if (doReadSavedPersistentData) {
                if (this.myContents == null || !this.myContents.isBusyReading() || DebugAssertions.EXTRA_SANITY_CHECKS) {
                    ByteArraySequence bytes = this.readContents(hashId);
                    if (bytes != null) {
                        Map contentData;
                        boolean sameValueForSavedIndexedResultAndCurrentOne;
                        data = this.deserializeSavedPersistentData(bytes);
                        havePersistentData = true;
                        if (DebugAssertions.EXTRA_SANITY_CHECKS && !(sameValueForSavedIndexedResultAndCurrentOne = (contentData = this.myIndexer.map(content)).equals(data))) {
                            DebugAssertions.error((String)"Unexpected difference in indexing of %s by index %s, file type %s, charset %s\ndiff %s\nprevious indexed info %s", (Object[])new Object[]{fileContent.getFile(), this.myIndexId, fileContent.getFileType().getName(), ((FileContentImpl)fileContent).getCharset(), this.buildDiff(data, contentData), this.myIndexingTrace.get((Object)hashId)});
                        }
                    }
                } else {
                    skippedReadingPersistentDataButMayHaveIt = true;
                }
            } else {
                havePersistentData = this.myContents.containsMapping((Object)hashId);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (data == null) {
            data = this.myIndexer.map(content);
            if (DebugAssertions.DEBUG) {
                MapReduceIndex.checkValuesHaveProperEqualsAndHashCode((Map)data, this.myIndexId, this.myMapExternalizer.myValueExternalizer);
            }
        }
        if (!havePersistentData) {
            boolean saved = this.savePersistentData(data, hashId, skippedReadingPersistentDataButMayHaveIt);
            if (DebugAssertions.EXTRA_SANITY_CHECKS && saved) {
                FileContent fileContent = (FileContent)content;
                try {
                    this.myIndexingTrace.put((Object)hashId, (Object)(((FileContentImpl)fileContent).getCharset() + "," + fileContent.getFileType().getName() + "," + fileContent.getFile().getPath() + "," + ExceptionUtil.getThrowableText((Throwable)new Throwable())));
                }
                catch (IOException ex) {
                    LOG.error((Throwable)ex);
                }
            }
        }
        Snapshot snapshot = new Snapshot(data, hashId);
        if (snapshot == null) {
            SnapshotInputMappings.$$$reportNull$$$0(3);
        }
        return snapshot;
    }

    void putInputHash(int inputId, int hashId) {
        try {
            if (SharedIndicesData.ourFileSharedIndicesEnabled) {
                SharedIndicesData.associateFileData(inputId, this.myIndexId, hashId, EnumeratorIntegerDescriptor.INSTANCE);
            }
            if (this.myInputsSnapshotMapping != null) {
                this.myInputsSnapshotMapping.put((Object)inputId, (Object)hashId);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void flush() {
        if (this.myContents != null) {
            this.myContents.force();
        }
        if (this.myInputsSnapshotMapping != null) {
            this.myInputsSnapshotMapping.force();
        }
        if (this.myIndexingTrace != null) {
            this.myIndexingTrace.force();
        }
    }

    public void clear() throws IOException {
        List<File> baseDirs = ContainerUtil.list((Object[])new PersistentHashMap[]{this.myContents, this.myIndexingTrace, this.myInputsSnapshotMapping}).stream().filter(Objects::nonNull).map(PersistentHashMap::getBaseFile).collect(Collectors.toList());
        try {
            this.close();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        baseDirs.forEach(PersistentHashMap::deleteFilesStartingWith);
        this.createMaps();
    }

    public void close() throws IOException {
        if (this.myContents != null) {
            this.myContents.close();
        }
        if (this.myInputsSnapshotMapping != null) {
            this.myInputsSnapshotMapping.close();
        }
        if (this.myIndexingTrace != null) {
            this.myIndexingTrace.close();
        }
    }

    private void createMaps() throws IOException {
        this.myContents = this.createContentsIndex();
        this.myIndexingTrace = DebugAssertions.EXTRA_SANITY_CHECKS ? this.createIndexingTrace() : null;
        this.myInputsSnapshotMapping = !SharedIndicesData.ourFileSharedIndicesEnabled || SharedIndicesData.DO_CHECKS ? this.createInputSnapshotMapping() : null;
    }

    private PersistentHashMap<Integer, ByteArraySequence> createContentsIndex() throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled && !SharedIndicesData.DO_CHECKS) {
            return null;
        }
        File saved = new File(IndexInfrastructure.getPersistentIndexRootDir(this.myIndexId), "values");
        try {
            return new PersistentHashMap(saved, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)ByteSequenceDataExternalizer.INSTANCE);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)saved);
            throw ex;
        }
    }

    private PersistentHashMap<Integer, Integer> createInputSnapshotMapping() throws IOException {
        File fileIdToHashIdFile = new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "fileIdToHashId");
        try {
            return new PersistentHashMap<Integer, Integer>(fileIdToHashIdFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE, 4096){

                protected boolean wantNonNegativeIntegralValues() {
                    return true;
                }
            };
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)fileIdToHashIdFile);
            throw ex;
        }
    }

    private PersistentHashMap<Integer, String> createIndexingTrace() throws IOException {
        File mapFile = new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "indextrace");
        try {
            return new PersistentHashMap(mapFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<String>(){

                public void save(@NotNull DataOutput out, String value) throws IOException {
                    if (out == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    out.write((byte[])CompressionUtil.compressStringRawBytes((CharSequence)value));
                }

                public String read(@NotNull DataInput in) throws IOException {
                    if (in == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    byte[] b = new byte[((InputStream)((Object)in)).available()];
                    in.readFully(b);
                    return (String)CompressionUtil.uncompressStringRawBytes((Object)b);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "out";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "in";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/util/indexing/SnapshotInputMappings$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "save";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "read";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, 4096);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)mapFile);
            throw ex;
        }
    }

    private Integer readInputHashId(int inputId) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            Integer hashId = (Integer)SharedIndicesData.recallFileData(inputId, this.myIndexId, EnumeratorIntegerDescriptor.INSTANCE);
            if (hashId == null) {
                hashId = 0;
            }
            if (this.myInputsSnapshotMapping == null) {
                return hashId;
            }
            Integer hashIdFromInputSnapshotMapping = (Integer)this.myInputsSnapshotMapping.get((Object)inputId);
            if (hashId == 0 && hashIdFromInputSnapshotMapping != 0 || !Comparing.equal((Object)hashIdFromInputSnapshotMapping, (Object)hashId)) {
                SharedIndicesData.associateFileData(inputId, this.myIndexId, hashIdFromInputSnapshotMapping, EnumeratorIntegerDescriptor.INSTANCE);
                if (hashId != 0) {
                    LOG.error("Unexpected indexing diff with hash id " + this.myIndexId + ", file:" + IndexInfrastructure.findFileById(PersistentFS.getInstance(), inputId) + "," + hashIdFromInputSnapshotMapping + "," + hashId);
                }
                hashId = hashIdFromInputSnapshotMapping;
            }
            return hashId;
        }
        return (Integer)this.myInputsSnapshotMapping.get((Object)inputId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArraySequence readContents(Integer hashId) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (SharedIndicesData.DO_CHECKS) {
                PersistentHashMap<Integer, ByteArraySequence> persistentHashMap = this.myContents;
                synchronized (persistentHashMap) {
                    ByteArraySequence contentBytes = SharedIndicesData.recallContentData(hashId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
                    ByteArraySequence contentBytesFromContents = (ByteArraySequence)this.myContents.get((Object)hashId);
                    if (contentBytes == null && contentBytesFromContents != null || !Comparing.equal((Object)contentBytesFromContents, (Object)contentBytes)) {
                        SharedIndicesData.associateContentData(hashId, this.myIndexId, contentBytesFromContents, ByteSequenceDataExternalizer.INSTANCE);
                        if (contentBytes != null) {
                            LOG.error("Unexpected indexing diff with hash id " + this.myIndexId + "," + hashId);
                        }
                        contentBytes = contentBytesFromContents;
                    }
                    return contentBytes;
                }
            }
            return SharedIndicesData.recallContentData(hashId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
        }
        return (ByteArraySequence)this.myContents.get((Object)hashId);
    }

    private Map<Key, Value> deserializeSavedPersistentData(ByteArraySequence bytes) throws IOException {
        DataInputStream stream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes.getBytes(), bytes.getOffset(), bytes.getLength()));
        return this.myMapExternalizer.read(stream);
    }

    private Integer getHashOfContent(FileContent content) throws IOException {
        Integer previouslyCalculatedContentHashId;
        FileType fileType = content.getFileType();
        if (this.myIsPsiBackedIndex && content instanceof FileContentImpl) {
            PsiDocumentManager psiDocumentManager;
            Document document;
            Integer previouslyCalculatedUncommittedHashId = (Integer)content.getUserData(ourSavedUncommittedHashIdKey);
            if (previouslyCalculatedUncommittedHashId == null && (document = FileDocumentManager.getInstance().getCachedDocument(content.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)content.getProject())).isUncommited(document)) {
                PsiFile file2 = psiDocumentManager.getCachedPsiFile(document);
                Charset charset = ((FileContentImpl)content).getCharset();
                if (file2 != null) {
                    previouslyCalculatedUncommittedHashId = ContentHashesSupport.calcContentHashIdWithFileType(file2.getText().getBytes(charset), charset, fileType);
                    content.putUserData(ourSavedUncommittedHashIdKey, (Object)previouslyCalculatedUncommittedHashId);
                }
            }
            if (previouslyCalculatedUncommittedHashId != null) {
                return previouslyCalculatedUncommittedHashId;
            }
        }
        if ((previouslyCalculatedContentHashId = (Integer)content.getUserData(ourSavedContentHashIdKey)) == null) {
            byte[] hash;
            byte[] byArray = hash = content instanceof FileContentImpl ? ((FileContentImpl)content).getHash() : null;
            if (hash == null) {
                if (fileType.isBinary()) {
                    previouslyCalculatedContentHashId = ContentHashesSupport.calcContentHashId(content.getContent(), fileType);
                } else {
                    Charset charset = content instanceof FileContentImpl ? ((FileContentImpl)content).getCharset() : null;
                    previouslyCalculatedContentHashId = ContentHashesSupport.calcContentHashIdWithFileType(content.getContent(), charset, fileType);
                }
            } else {
                previouslyCalculatedContentHashId = ContentHashesSupport.enumerateHash(hash);
            }
            content.putUserData(ourSavedContentHashIdKey, (Object)previouslyCalculatedContentHashId);
        }
        return previouslyCalculatedContentHashId;
    }

    private StringBuilder buildDiff(Map<Key, Value> data, Map<Key, Value> contentData) {
        Value value;
        StringBuilder moreInfo = new StringBuilder();
        if (contentData.size() != data.size()) {
            moreInfo.append("Indexer has different number of elements, previously ").append(data.size()).append(" after ").append(contentData.size()).append("\n");
        } else {
            moreInfo.append("total ").append(contentData.size()).append(" entries\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : contentData.entrySet()) {
            if (!data.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("Previous data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value = data.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value)) continue;
            moreInfo.append("Previous data has different value for key:").append(keyValueEntry.getKey()).append(", new value ").append(keyValueEntry.getValue()).append(", oldValue:").append(value).append("\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : data.entrySet()) {
            if (!contentData.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("New data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value = contentData.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value)) continue;
            moreInfo.append("New data has different value for key:").append(keyValueEntry.getKey()).append(" new value ").append(value).append(", oldValue:").append(keyValueEntry.getValue()).append("\n");
        }
        return moreInfo;
    }

    private boolean savePersistentData(Map<Key, Value> data, int id, boolean delayedReading) {
        try {
            if (delayedReading && this.myContents.containsMapping((Object)id)) {
                return false;
            }
            BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(ourSpareByteArray.getBuffer(4 * data.size()));
            DataOutputStream stream = new DataOutputStream((OutputStream)out);
            this.myMapExternalizer.save((DataOutput)stream, data);
            this.saveContents(id, out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContents(int id, BufferExposingByteArrayOutputStream out) throws IOException {
        ByteArraySequence byteSequence = out.toByteArraySequence();
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (SharedIndicesData.DO_CHECKS) {
                PersistentHashMap<Integer, ByteArraySequence> persistentHashMap = this.myContents;
                synchronized (persistentHashMap) {
                    this.myContents.put((Object)id, (Object)byteSequence);
                    SharedIndicesData.associateContentData(id, this.myIndexId, byteSequence, ByteSequenceDataExternalizer.INSTANCE);
                }
            } else {
                SharedIndicesData.associateContentData(id, this.myIndexId, byteSequence, ByteSequenceDataExternalizer.INSTANCE);
            }
        } else {
            this.myContents.put((Object)id, (Object)byteSequence);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/SnapshotInputMappings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "readInputKeys";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/SnapshotInputMappings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readPersistentDataOrMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readPersistentDataOrMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Snapshot<Key, Value> {
        private final Map<Key, Value> myData;
        private final int hashId;

        private Snapshot(@NotNull Map<Key, Value> data, int id) {
            if (data == null) {
                Snapshot.$$$reportNull$$$0(0);
            }
            this.myData = data;
            this.hashId = id;
        }

        @NotNull
        Map<Key, Value> getData() {
            Map<Key, Value> map2 = this.myData;
            if (map2 == null) {
                Snapshot.$$$reportNull$$$0(1);
            }
            return map2;
        }

        int getHashId() {
            return this.hashId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/SnapshotInputMappings$Snapshot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/SnapshotInputMappings$Snapshot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

