/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogRepoSizeCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        DataPack dataPack;
        VcsProjectLog projectLog;
        VcsLogData logData;
        if (project == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(0);
        }
        if ((logData = (projectLog = VcsProjectLog.getInstance(project)).getDataManager()) != null && (dataPack = logData.getDataPack()).isFull()) {
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            MultiMap<VcsKey, VirtualFile> groupedRoots = VcsLogRepoSizeCollector.groupRootsByVcs(dataPack.getLogProviders());
            HashSet usages = ContainerUtil.newHashSet((Object[])new UsageDescriptor[]{new UsageDescriptor("dataInitialized")});
            usages.add(StatisticsUtilKt.getCountingUsage("commit.count", permanentGraph.getAllCommits().size(), Arrays.asList(0, 1, 100, 1000, 10000, 100000, 500000, 1000000)));
            usages.add(StatisticsUtilKt.getCountingUsage("branches.count", dataPack.getRefsModel().getBranches().size(), Arrays.asList(0, 1, 10, 50, 100, 500, 1000, 5000, 10000, 20000, 50000)));
            usages.add(StatisticsUtilKt.getCountingUsage("users.count", logData.getAllUsers().size(), Arrays.asList(0, 1, 10, 50, 100, 500, 1000, 5000, 10000, 20000, 50000)));
            for (VcsKey vcs : groupedRoots.keySet()) {
                String vcsKey = VcsLogRepoSizeCollector.getVcsKeySafe(vcs);
                usages.add(StatisticsUtilKt.getCountingUsage(vcsKey + ".root.count", groupedRoots.get((Object)vcs).size(), Arrays.asList(0, 1, 2, 5, 8, 15, 30, 50, 100, 300, 500)));
            }
            HashSet hashSet = usages;
            if (hashSet == null) {
                VcsLogRepoSizeCollector.$$$reportNull$$$0(1);
            }
            return hashSet;
        }
        Set<UsageDescriptor> set2 = Collections.emptySet();
        if (set2 == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @NotNull
    private static String getVcsKeySafe(@NotNull VcsKey vcs) {
        if (vcs == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(3);
        }
        if (PluginInfoDetectorKt.getPluginInfo(vcs.getClass()).isDevelopedByJetBrains()) {
            String string = UsageDescriptorKeyValidator.ensureProperKey(vcs.getName().toLowerCase());
            if (string == null) {
                VcsLogRepoSizeCollector.$$$reportNull$$$0(4);
            }
            return string;
        }
        if ("third.party" == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(5);
        }
        return "third.party";
    }

    @NotNull
    private static MultiMap<VcsKey, VirtualFile> groupRootsByVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(6);
        }
        MultiMap result2 = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsKey vcs = entry.getValue().getSupportedVcs();
            result2.putValue((Object)vcs, (Object)root);
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(7);
        }
        return multiMap;
    }

    @Override
    @NotNull
    public String getGroupId() {
        if ("vcs.log.data" == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(8);
        }
        return "vcs.log.data";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsKeySafe";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "groupRootsByVcs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVcsKeySafe";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "groupRootsByVcs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

