/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.filter.VcsStructureChooser;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.FilterPair;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StructureFilterPopupComponent
extends FilterPopupComponent<FilterPair<VcsLogStructureFilter, VcsLogRootFilter>, FilterModel.PairFilterModel<VcsLogStructureFilter, VcsLogRootFilter>> {
    private static final int FILTER_LABEL_LENGTH = 30;
    private static final int CHECKBOX_ICON_SIZE = 15;
    private static final FileByNameComparator FILE_BY_NAME_COMPARATOR = new FileByNameComparator();
    private static final FilePathByPathComparator FILE_PATH_BY_PATH_COMPARATOR = new FilePathByPathComparator();
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;

    StructureFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull FilterModel.PairFilterModel<VcsLogStructureFilter, VcsLogRootFilter> filterModel, @NotNull VcsLogColorManager colorManager) {
        if (uiProperties == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(0);
        }
        if (filterModel == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(1);
        }
        if (colorManager == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(2);
        }
        super("Paths", filterModel);
        this.myUiProperties = uiProperties;
        this.myColorManager = colorManager;
    }

    private static VcsLogRootFilter getRootFilter(@Nullable FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            return null;
        }
        return filter.getFilter2();
    }

    private static VcsLogStructureFilter getStructureFilter(@Nullable FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            return null;
        }
        return filter.getFilter1();
    }

    @NotNull
    private Collection<VirtualFile> getFilterRoots(@Nullable VcsLogRootFilter filter) {
        Set<VirtualFile> set2 = filter != null ? filter.getRoots() : this.getAllRoots();
        if (set2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    private static Collection<FilePath> getFilterFiles(@Nullable VcsLogStructureFilter filter) {
        Collection<Object> collection = filter != null ? filter.getFiles() : Collections.emptySet();
        if (collection == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    protected String getText(@NotNull FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(5);
        }
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter(filter);
        VcsLogStructureFilter structureFilter = StructureFilterPopupComponent.getStructureFilter(filter);
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(this.getAllRoots(), rootFilter, structureFilter);
        Collection<VirtualFile> roots = this.getFilterRoots(rootFilter);
        Collection<FilePath> files2 = StructureFilterPopupComponent.getFilterFiles(structureFilter);
        if (files2.isEmpty()) {
            String string = StructureFilterPopupComponent.getTextFromRoots(roots, visibleRoots.size() == this.getAllRoots().size());
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = StructureFilterPopupComponent.getTextFromFilePaths(files2, "folders", false);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getTextFromRoots(@NotNull Collection<? extends VirtualFile> files2, boolean full) {
        if (files2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(8);
        }
        String string = StructureFilterPopupComponent.getText(files2, "roots", FILE_BY_NAME_COMPARATOR, VirtualFile::getName, full);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getTextFromFilePaths(@NotNull Collection<? extends FilePath> files2, @NotNull String category, boolean full) {
        if (files2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(10);
        }
        if (category == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(11);
        }
        String string = StructureFilterPopupComponent.getText(files2, category, FILE_PATH_BY_PATH_COMPARATOR, file2 -> StringUtil.shortenPathWithEllipsis((String)file2.getPresentableUrl(), (int)30), full);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static <F> String getText(@NotNull Collection<? extends F> files2, @NotNull String category, @NotNull Comparator<? super F> comparator2, @NotNull NotNullFunction<? super F, String> getText2, boolean full) {
        if (files2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(13);
        }
        if (category == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(14);
        }
        if (comparator2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(15);
        }
        if (getText2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(16);
        }
        if (full) {
            if ("All" == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(17);
            }
            return "All";
        }
        if (files2.isEmpty()) {
            String string = "No " + category;
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(18);
            }
            return string;
        }
        F firstFile = Collections.min(files2, comparator2);
        String firstFileName = (String)getText2.fun(firstFile);
        if (files2.size() == 1) {
            String string = firstFileName;
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = firstFileName + " + " + (files2.size() - 1);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(21);
        }
        return this.getToolTip(this.getFilterRoots(StructureFilterPopupComponent.getRootFilter(filter)), StructureFilterPopupComponent.getFilterFiles(StructureFilterPopupComponent.getStructureFilter(filter)));
    }

    @NotNull
    private String getToolTip(@NotNull Collection<? extends VirtualFile> roots, @NotNull Collection<? extends FilePath> files2) {
        if (roots == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(22);
        }
        if (files2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(23);
        }
        String tooltip = "";
        if (roots.isEmpty()) {
            tooltip = tooltip + "No Roots Selected";
        } else if (roots.size() != this.getAllRoots().size()) {
            tooltip = tooltip + "Roots:\n" + StructureFilterPopupComponent.getTooltipTextForRoots(roots);
        }
        if (!files2.isEmpty()) {
            if (!tooltip.isEmpty()) {
                tooltip = tooltip + "\n";
            }
            tooltip = tooltip + "Folders:\n" + StructureFilterPopupComponent.getTooltipTextForFilePaths(files2);
        }
        String string = tooltip;
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static String getTooltipTextForRoots(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(25);
        }
        String string = StructureFilterPopupComponent.getTooltipTextForFiles(files2, FILE_BY_NAME_COMPARATOR, VirtualFile::getName);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static String getTooltipTextForFilePaths(@NotNull Collection<? extends FilePath> files2) {
        if (files2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(27);
        }
        String string = StructureFilterPopupComponent.getTooltipTextForFiles(files2, FILE_PATH_BY_PATH_COMPARATOR, FilePath::getPresentableUrl);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static <F> String getTooltipTextForFiles(@NotNull Collection<? extends F> files2, @NotNull Comparator<? super F> comparator2, @NotNull NotNullFunction<? super F, String> getText2) {
        if (files2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(29);
        }
        if (comparator2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(30);
        }
        if (getText2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(31);
        }
        List filesToDisplay = ContainerUtil.sorted(files2, comparator2);
        filesToDisplay = ContainerUtil.getFirstItems((List)filesToDisplay, (int)10);
        String tooltip = StringUtil.join((Collection)filesToDisplay, getText2, (String)"\n");
        if (files2.size() > 10) {
            tooltip = tooltip + "\n...";
        }
        String string = tooltip;
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    protected ActionGroup createActionGroup() {
        Set<VirtualFile> roots = this.getAllRoots();
        ArrayList<SelectVisibleRootAction> rootActions = new ArrayList<SelectVisibleRootAction>();
        if (this.myColorManager.isMultipleRoots()) {
            for (VirtualFile root : ContainerUtil.sorted(roots, (Comparator)FILE_BY_NAME_COMPARATOR)) {
                rootActions.add(new SelectVisibleRootAction(root));
            }
        }
        ArrayList<SelectFromHistoryAction> structureActions = new ArrayList<SelectFromHistoryAction>();
        for (VcsLogStructureFilter filter : this.getRecentFilters()) {
            structureActions.add(new SelectFromHistoryAction(filter));
        }
        if (roots.size() > 15) {
            return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator("Recent"), new DefaultActionGroup(structureActions), new Separator("Roots"), new DefaultActionGroup(rootActions)});
        }
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator("Roots"), new DefaultActionGroup(rootActions), new Separator("Recent"), new DefaultActionGroup(structureActions)});
    }

    @NotNull
    private List<VcsLogStructureFilter> getRecentFilters() {
        List<List<String>> filterValues = this.myUiProperties.getRecentlyFilteredGroups(this.myName);
        List list2 = ContainerUtil.map2List(filterValues, values -> VcsLogClassicFilterUi.FileFilterModel.createStructureFilter(values));
        if (list2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(33);
        }
        return list2;
    }

    private Set<VirtualFile> getAllRoots() {
        return ((FilterModel.PairFilterModel)this.myFilterModel).getDataPack().getLogProviders().keySet();
    }

    private boolean isVisible(@NotNull VirtualFile root) {
        VcsLogRootFilter rootFilter;
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(34);
        }
        if ((rootFilter = StructureFilterPopupComponent.getRootFilter((FilterPair)((FilterModel.PairFilterModel)this.myFilterModel).getFilter())) != null) {
            return rootFilter.getRoots().contains(root);
        }
        return true;
    }

    private void setVisible(@NotNull VirtualFile root, boolean visible) {
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(35);
        }
        Set<VirtualFile> roots = this.getAllRoots();
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter((FilterPair)((FilterModel.PairFilterModel)this.myFilterModel).getFilter());
        Collection<Object> visibleRoots = rootFilter == null ? (visible ? roots : ContainerUtil.subtract(roots, Collections.singleton(root))) : (visible ? ContainerUtil.union(new HashSet(rootFilter.getRoots()), Collections.singleton(root)) : ContainerUtil.subtract((Collection)rootFilter.getRoots(), Collections.singleton(root)));
        ((FilterModel.PairFilterModel)this.myFilterModel).setFilter(new FilterPair<Object, VcsLogRootFilter>(null, VcsLogFilterObject.fromRoots(visibleRoots)));
    }

    private void setVisibleOnly(@NotNull VirtualFile root) {
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(36);
        }
        ((FilterModel.PairFilterModel)this.myFilterModel).setFilter(new FilterPair<Object, VcsLogRootFilter>(null, VcsLogFilterObject.fromRoot(root)));
    }

    @NotNull
    private static String getStructureActionText(@NotNull VcsLogStructureFilter filter) {
        if (filter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(37);
        }
        String string = StructureFilterPopupComponent.getTextFromFilePaths(filter.getFiles(), "items", filter.getFiles().isEmpty());
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(38);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent";
                break;
            }
            case 5: 
            case 21: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 15: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 16: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getText";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterFiles";
                break;
            }
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFromRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFromFilePaths";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTip";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTextForRoots";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTextForFilePaths";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTextForFiles";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentFilters";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureActionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 38: {
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromFilePaths";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getToolTip";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForRoots";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForFilePaths";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForFiles";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setVisible";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setVisibleOnly";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getStructureActionText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SelectFromHistoryAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final VcsLogStructureFilter myFilter;
        @NotNull
        private final Icon myIcon;
        @NotNull
        private final Icon myEmptyIcon;

        private SelectFromHistoryAction(VcsLogStructureFilter filter) {
            if (filter == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(0);
            }
            super(StructureFilterPopupComponent.getStructureActionText(filter), StructureFilterPopupComponent.getTooltipTextForFilePaths(filter.getFiles()).replace("\n", " "), null);
            this.myFilter = filter;
            this.myIcon = JBUI.scale((JBUI.JBIcon)new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, 15, 15));
            this.myEmptyIcon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)15));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(1);
            }
            return StructureFilterPopupComponent.getStructureFilter((FilterPair)((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter()) == this.myFilter;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(2);
            }
            ((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).setFilter(new FilterPair<VcsLogStructureFilter, Object>(this.myFilter, null));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (this.isSelected(e)) {
                presentation.setIcon(this.myIcon);
            } else {
                presentation.setIcon(this.myEmptyIcon);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFromHistoryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SelectFoldersAction
    extends DumbAwareAction {
        static final String STRUCTURE_FILTER_TEXT = "Select Folders...";

        SelectFoldersAction() {
            super(STRUCTURE_FILTER_TEXT);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectFoldersAction.$$$reportNull$$$0(0);
            }
            Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
            VcsLogDataPack dataPack = ((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).getDataPack();
            VcsLogStructureFilter structureFilter = StructureFilterPopupComponent.getStructureFilter((FilterPair)((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter());
            Collection<Object> files2 = structureFilter == null ? Collections.emptySet() : ContainerUtil.mapNotNull((Collection)structureFilter.getFiles(), FilePath::getVirtualFile);
            VcsStructureChooser chooser = new VcsStructureChooser(project, "Select Files or Folders to Filter by", files2, new ArrayList<VirtualFile>(dataPack.getLogProviders().keySet()));
            if (chooser.showAndGet()) {
                VcsLogStructureFilter newFilter = VcsLogFilterObject.fromVirtualFiles(chooser.getSelectedFiles());
                ((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).setFilter(new FilterPair<VcsLogStructureFilter, Object>(newFilter, null));
                StructureFilterPopupComponent.this.myUiProperties.addRecentlyFilteredGroup(StructureFilterPopupComponent.this.myName, VcsLogClassicFilterUi.FileFilterModel.getFilterValues(newFilter));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectFoldersAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFoldersAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CheckboxColorIcon
    extends ColorIcon {
        private final int mySize;
        private boolean mySelected;
        private SizedIcon mySizedIcon;

        CheckboxColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                CheckboxColorIcon.$$$reportNull$$$0(0);
            }
            super(size, color);
            this.mySize = size;
            this.mySizedIcon = new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, this.mySize, this.mySize);
        }

        public void prepare(boolean selected) {
            this.mySelected = selected;
        }

        @NotNull
        public CheckboxColorIcon withIconPreScaled(boolean preScaled) {
            this.mySizedIcon = (SizedIcon)this.mySizedIcon.withIconPreScaled(preScaled);
            CheckboxColorIcon checkboxColorIcon = (CheckboxColorIcon)super.withIconPreScaled(preScaled);
            if (checkboxColorIcon == null) {
                CheckboxColorIcon.$$$reportNull$$$0(1);
            }
            return checkboxColorIcon;
        }

        public void paintIcon(Component component, Graphics g, int i, int j) {
            super.paintIcon(component, g, i, j);
            if (this.mySelected) {
                this.mySizedIcon.paintIcon(component, g, i, j);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$CheckboxColorIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$CheckboxColorIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withIconPreScaled";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class SelectVisibleRootAction
    extends ToggleAction
    implements DumbAware,
    KeepingPopupOpenAction {
        @NotNull
        private final CheckboxColorIcon myIcon;
        @NotNull
        private final VirtualFile myRoot;

        private SelectVisibleRootAction(VirtualFile root) {
            if (root == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(0);
            }
            super(root.getName(), root.getPresentableUrl(), null);
            this.myRoot = root;
            this.myIcon = (CheckboxColorIcon)JBUI.scale((JBUI.JBIcon)new CheckboxColorIcon(15, (Color)VcsLogGraphTable.getRootBackgroundColor(this.myRoot, StructureFilterPopupComponent.this.myColorManager)));
            this.getTemplatePresentation().setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)15)));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(1);
            }
            return StructureFilterPopupComponent.this.isVisible(this.myRoot);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(2);
            }
            if (!this.isEnabled()) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else if ((e.getModifiers() & this.getMask()) != 0) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else {
                StructureFilterPopupComponent.this.setVisible(this.myRoot, state);
            }
        }

        @JdkConstants.InputEventMask
        private int getMask() {
            return SystemInfo.isMac ? 4 : 2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            this.updateIcon();
            e.getPresentation().setIcon((Icon)((Object)this.myIcon));
            e.getPresentation().putClientProperty("ToolTipText", (Object)(KeyEvent.getKeyModifiersText(this.getMask()) + "+Click to see only \"" + e.getPresentation().getText() + "\""));
        }

        private void updateIcon() {
            this.myIcon.prepare(StructureFilterPopupComponent.this.isVisible(this.myRoot) && this.isEnabled());
        }

        private boolean isEnabled() {
            return StructureFilterPopupComponent.getStructureFilter((FilterPair)((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter()) == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectVisibleRootAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FilePathByPathComparator
    implements Comparator<FilePath> {
        private FilePathByPathComparator() {
        }

        @Override
        public int compare(FilePath o1, FilePath o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    }

    private static class FileByNameComparator
    implements Comparator<VirtualFile> {
        private FileByNameComparator() {
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

