/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.xdebugger.impl.settings.DataViewsConfigurableUi;
import com.intellij.xdebugger.impl.settings.DebuggerConfigurable;
import com.intellij.xdebugger.impl.settings.MergedCompositeConfigurable;
import com.intellij.xdebugger.impl.settings.XDebuggerDataViewSettings;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SubCompositeConfigurable
implements SearchableConfigurable.Parent {
    protected DataViewsConfigurableUi root;
    protected Configurable[] children;
    protected JComponent rootComponent;

    SubCompositeConfigurable() {
    }

    public boolean hasOwnContent() {
        return true;
    }

    @Nullable
    public String getHelpTopic() {
        this.getConfigurables();
        return this.children != null && this.children.length == 1 ? this.children[0].getHelpTopic() : null;
    }

    public final void disposeUIResources() {
        this.root = null;
        this.rootComponent = null;
        if (this.isChildrenMerged()) {
            for (Configurable child2 : this.children) {
                child2.disposeUIResources();
            }
        }
        this.children = null;
    }

    protected XDebuggerDataViewSettings getSettings() {
        return null;
    }

    @Nullable
    protected abstract DataViewsConfigurableUi createRootUi();

    @NotNull
    protected abstract DebuggerSettingsCategory getCategory();

    private boolean isChildrenMerged() {
        return this.children != null && this.children.length == 1;
    }

    @NotNull
    public final Configurable[] getConfigurables() {
        if (this.children == null) {
            List<Configurable> configurables = DebuggerConfigurable.getConfigurables(this.getCategory());
            this.children = configurables.toArray(new Configurable[0]);
        }
        Configurable[] configurableArray = this.isChildrenMerged() ? DebuggerConfigurable.EMPTY_CONFIGURABLES : this.children;
        if (configurableArray == null) {
            SubCompositeConfigurable.$$$reportNull$$$0(0);
        }
        return configurableArray;
    }

    @Nullable
    public final JComponent createComponent() {
        if (this.rootComponent == null) {
            if (this.root == null) {
                this.root = this.createRootUi();
            }
            this.getConfigurables();
            if (this.isChildrenMerged()) {
                if (this.children.length == 0) {
                    this.rootComponent = this.root == null ? null : this.root.getComponent();
                } else if (this.root == null && this.children.length == 1) {
                    this.rootComponent = this.children[0].createComponent();
                } else {
                    JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
                    if (this.root != null) {
                        JComponent c = this.root.getComponent();
                        c.setBorder(MergedCompositeConfigurable.BOTTOM_INSETS);
                        panel2.add(c);
                    }
                    for (Configurable configurable : this.children) {
                        JComponent component = configurable.createComponent();
                        if (component == null) continue;
                        if (this.children[0] != configurable || !MergedCompositeConfigurable.isTargetedToProduct(configurable)) {
                            component.setBorder((Border)IdeBorderFactory.createTitledBorder((String)configurable.getDisplayName(), (boolean)false));
                        }
                        panel2.add(component);
                    }
                    this.rootComponent = panel2;
                }
            } else {
                this.rootComponent = this.root == null ? null : this.root.getComponent();
            }
        }
        return this.rootComponent;
    }

    public final void reset() {
        if (this.root != null) {
            this.root.reset(this.getSettings());
        }
        if (this.isChildrenMerged()) {
            for (Configurable child2 : this.children) {
                child2.reset();
            }
        }
    }

    public final boolean isModified() {
        if (this.root != null && this.root.isModified(this.getSettings())) {
            return true;
        }
        if (this.isChildrenMerged()) {
            for (Configurable child2 : this.children) {
                if (!child2.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public final void apply() throws ConfigurationException {
        if (this.root != null) {
            this.root.apply(this.getSettings());
            DebuggerConfigurableProvider.EXTENSION_POINT.extensions().forEach(provider -> provider.generalApplied(this.getCategory()));
        }
        if (this.isChildrenMerged()) {
            for (Configurable child2 : this.children) {
                if (!child2.isModified()) continue;
                child2.apply();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/settings/SubCompositeConfigurable", "getConfigurables"));
    }
}

