/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.config;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.config.ConfigFileSearcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ConfigFilesTreeBuilder {
    private final JTree myTree;
    private static final Comparator<PsiFile> FILE_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());

    public ConfigFilesTreeBuilder(JTree tree) {
        this.myTree = tree;
        ConfigFilesTreeBuilder.installSearch(tree);
    }

    public Set<PsiFile> buildTree(DefaultMutableTreeNode root, ConfigFileSearcher ... searchers) {
        HashSet<PsiFile> psiFiles = new HashSet<PsiFile>();
        MultiMap files2 = new MultiMap();
        MultiMap jars = new MultiMap();
        MultiMap virtualFiles = new MultiMap();
        for (ConfigFileSearcher searcher : searchers) {
            files2.putAllValues(searcher.getFilesByModules());
            jars.putAllValues(searcher.getJars());
            virtualFiles.putAllValues(searcher.getVirtualFiles());
        }
        psiFiles.addAll(this.buildModuleNodes((MultiMap<Module, PsiFile>)files2, (MultiMap<VirtualFile, PsiFile>)jars, root));
        for (Map.Entry entry : virtualFiles.entrySet()) {
            DefaultMutableTreeNode node = this.createFileNode(entry.getKey());
            ArrayList list2 = new ArrayList((Collection)entry.getValue());
            Collections.sort(list2, FILE_COMPARATOR);
            for (PsiFile file2 : list2) {
                node.add(this.createFileNode(file2));
            }
            root.add(node);
        }
        return psiFiles;
    }

    public DefaultMutableTreeNode addFile(VirtualFile file2) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        DefaultMutableTreeNode treeNode = this.createFileNode(file2);
        root.add(treeNode);
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        model.nodeStructureChanged(root);
        return treeNode;
    }

    public Set<PsiFile> buildModuleNodes(MultiMap<Module, PsiFile> files2, MultiMap<VirtualFile, PsiFile> jars, DefaultMutableTreeNode root) {
        HashSet<PsiFile> psiFiles = new HashSet<PsiFile>();
        ArrayList modules = new ArrayList(files2.keySet());
        Collections.sort(modules, ModulesAlphaComparator.INSTANCE);
        for (Module module : modules) {
            DefaultMutableTreeNode moduleNode = this.createFileNode(module);
            root.add(moduleNode);
            if (!files2.containsKey((Object)module)) continue;
            ArrayList moduleFiles = new ArrayList(files2.get((Object)module));
            MultiMap filesByType = new MultiMap();
            for (PsiFile file2 : moduleFiles) {
                filesByType.putValue((Object)file2.getFileType(), (Object)file2);
            }
            if (ConfigFilesTreeBuilder.hasNonEmptyGroups((MultiMap<FileType, PsiFile>)filesByType)) {
                for (Map.Entry entry : filesByType.entrySet()) {
                    DefaultMutableTreeNode fileTypeNode = this.createFileNode(entry.getKey());
                    moduleNode.add(fileTypeNode);
                    this.addChildrenFiles(psiFiles, fileTypeNode, new ArrayList((Collection)entry.getValue()));
                }
                continue;
            }
            this.addChildrenFiles(psiFiles, moduleNode, moduleFiles);
        }
        ArrayList sortedJars = new ArrayList(jars.keySet());
        Collections.sort(sortedJars, (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
        for (VirtualFile file3 : sortedJars) {
            ArrayList list2;
            PsiFile jar;
            if (!file3.isValid() || (jar = ((PsiFile)(list2 = new ArrayList(jars.get((Object)file3))).get(0)).getManager().findFile(file3)) == null) continue;
            DefaultMutableTreeNode jarNode = this.createFileNode(jar);
            root.add(jarNode);
            Collections.sort(list2, FILE_COMPARATOR);
            for (PsiFile psiFile : list2) {
                jarNode.add(this.createFileNode(psiFile));
                psiFiles.add(psiFile);
            }
        }
        return psiFiles;
    }

    private static String getFileTypeNodeName(FileType fileType) {
        return fileType.getName() + " files";
    }

    private static boolean hasNonEmptyGroups(MultiMap<FileType, PsiFile> filesByType) {
        long nonEmptyGroups = filesByType.entrySet().stream().map(Map.Entry::getValue).filter(files2 -> files2 != null && !files2.isEmpty()).limit(2L).count();
        return nonEmptyGroups > 1L;
    }

    private void addChildrenFiles(@NotNull Set<? super PsiFile> psiFiles, DefaultMutableTreeNode parentNode, @NotNull List<? extends PsiFile> moduleFiles) {
        if (psiFiles == null) {
            ConfigFilesTreeBuilder.$$$reportNull$$$0(0);
        }
        if (moduleFiles == null) {
            ConfigFilesTreeBuilder.$$$reportNull$$$0(1);
        }
        Collections.sort(moduleFiles, FILE_COMPARATOR);
        for (PsiFile psiFile : moduleFiles) {
            DefaultMutableTreeNode fileNode = this.createFileNode(psiFile);
            parentNode.add(fileNode);
            psiFiles.add((PsiFile)psiFile);
        }
    }

    protected DefaultMutableTreeNode createFileNode(Object file2) {
        return new DefaultMutableTreeNode(file2);
    }

    public static void renderNode(Object value, boolean expanded, ColoredTreeCellRenderer renderer2) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return;
        }
        Object object = ((DefaultMutableTreeNode)value).getUserObject();
        if (object instanceof FileType) {
            FileType fileType = (FileType)object;
            Icon icon = fileType.getIcon();
            renderer2.setIcon(icon);
            renderer2.append(ConfigFilesTreeBuilder.getFileTypeNodeName(fileType), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (object instanceof Module) {
            Module module = (Module)object;
            Icon icon = ModuleType.get((Module)module).getIcon();
            renderer2.setIcon(icon);
            String moduleName = module.getName();
            renderer2.append(moduleName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (object instanceof PsiFile) {
            PsiFile psiFile = (PsiFile)object;
            Icon icon = psiFile.getIcon(0);
            renderer2.setIcon(icon);
            String fileName2 = psiFile.getName();
            renderer2.append(fileName2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null) {
                ConfigFilesTreeBuilder.renderPath(renderer2, virtualFile);
            }
        } else if (object instanceof VirtualFile) {
            VirtualFile file2 = (VirtualFile)object;
            renderer2.setIcon(VirtualFilePresentation.getIcon((VirtualFile)file2));
            renderer2.append(file2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            ConfigFilesTreeBuilder.renderPath(renderer2, file2);
        }
    }

    private static void renderPath(ColoredTreeCellRenderer renderer2, VirtualFile virtualFile) {
        String path = virtualFile.getPath();
        int i = path.indexOf("!/");
        if (i >= 0) {
            path = path.substring(i + "!/".length());
        }
        renderer2.append(" (" + StringUtil.trimEnd((String)StringUtil.trimEnd((String)path, (String)virtualFile.getName()), (String)"/") + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public static void installSearch(JTree tree) {
        new TreeSpeedSearch(tree, (Convertor<? super TreePath, String>)((Convertor)treePath -> {
            Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            if (object instanceof Module) {
                return ((Module)object).getName();
            }
            if (object instanceof PsiFile) {
                return ((PsiFile)object).getName();
            }
            if (object instanceof VirtualFile) {
                return ((VirtualFile)object).getName();
            }
            return "";
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleFiles";
                break;
            }
        }
        objectArray[1] = "com/intellij/xml/config/ConfigFilesTreeBuilder";
        objectArray[2] = "addChildrenFiles";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

