/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.FieldCache;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SchemaReferencesProvider;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementsGroupProcessor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XmlSchemaTagsProcessor;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComplexTypeDescriptor
extends TypeDescriptor {
    protected final XmlNSDescriptorImpl myDocumentDescriptor;
    private static final FieldCache<XmlElementDescriptor[], ComplexTypeDescriptor, Object, XmlElement> myElementDescriptorsCache = new FieldCache<XmlElementDescriptor[], ComplexTypeDescriptor, Object, XmlElement>(){

        protected XmlElementDescriptor[] compute(ComplexTypeDescriptor complexTypeDescriptor, XmlElement p) {
            return complexTypeDescriptor.doCollectElements();
        }

        protected XmlElementDescriptor[] getValue(ComplexTypeDescriptor complexTypeDescriptor, Object p) {
            return complexTypeDescriptor.myElementDescriptors;
        }

        protected void putValue(XmlElementDescriptor[] xmlElementDescriptors, ComplexTypeDescriptor complexTypeDescriptor, Object p) {
            ComplexTypeDescriptor.access$102(complexTypeDescriptor, xmlElementDescriptors);
        }
    };
    private static final FieldCache<XmlAttributeDescriptor[], ComplexTypeDescriptor, Object, XmlElement> myAttributeDescriptorsCache = new FieldCache<XmlAttributeDescriptor[], ComplexTypeDescriptor, Object, XmlElement>(){

        protected final XmlAttributeDescriptor[] compute(ComplexTypeDescriptor complexTypeDescriptor, XmlElement p) {
            return complexTypeDescriptor.doCollectAttributes();
        }

        protected final XmlAttributeDescriptor[] getValue(ComplexTypeDescriptor complexTypeDescriptor, Object o) {
            return complexTypeDescriptor.myAttributeDescriptors;
        }

        protected final void putValue(XmlAttributeDescriptor[] xmlAttributeDescriptors, ComplexTypeDescriptor complexTypeDescriptor, Object p) {
            ComplexTypeDescriptor.access$302(complexTypeDescriptor, xmlAttributeDescriptors);
        }
    };
    private final Map<String, CachedValue<CanContainAttributeType>> myAnyAttributeCache = ConcurrentFactoryMap.createMap(key -> CachedValuesManager.getManager((Project)this.myTag.getProject()).createCachedValue(() -> {
        THashSet dependencies = new THashSet();
        CanContainAttributeType type = this._canContainAttribute((String)key, this.myTag, null, (Set<String>)new THashSet(), (Set<Object>)dependencies);
        if (dependencies.isEmpty()) {
            dependencies.add((Object)this.myTag.getContainingFile());
        }
        if (DumbService.isDumb((Project)this.myTag.getProject())) {
            dependencies.add((Object)DumbService.getInstance((Project)this.myTag.getProject()).getModificationTracker());
        }
        return CachedValueProvider.Result.create((Object)((Object)type), (Object[])ArrayUtil.toObjectArray((Collection)dependencies));
    }, false));
    private volatile XmlElementDescriptor[] myElementDescriptors;
    private volatile XmlAttributeDescriptor[] myAttributeDescriptors;
    @NonNls
    private static final String PROHIBITED_ATTR_VALUE = "prohibited";
    @NonNls
    private static final String OTHER_NAMESPACE_ATTR_VALUE = "##other";
    @NonNls
    private static final String TRUE_ATTR_VALUE = "true";
    @NonNls
    private static final String REF_ATTR_NAME = "ref";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";
    @NonNls
    private static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    private static final String ATTRIBUTE_TAG_NAME = "attribute";
    private boolean myHasAnyInContentModel;
    @NonNls
    private static final String RESTRICTION_TAG_NAME = "restriction";
    @NonNls
    private static final String EXTENSION_TAG_NAME = "extension";
    @NonNls
    private static final String BASE_ATTR_NAME = "base";

    public ComplexTypeDescriptor(XmlNSDescriptorImpl documentDescriptor, XmlTag tag) {
        super(tag);
        this.myDocumentDescriptor = documentDescriptor;
    }

    @Override
    @NotNull
    public XmlTag getDeclaration() {
        XmlTag xmlTag = super.getDeclaration();
        if (xmlTag == null) {
            ComplexTypeDescriptor.$$$reportNull$$$0(0);
        }
        return xmlTag;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return XmlElementsGroupProcessor.computeGroups(this.myDocumentDescriptor, this.myTag);
    }

    public XmlElementDescriptor[] getElements(XmlElement context) {
        return (XmlElementDescriptor[])myElementDescriptorsCache.get(null, (Object)this, (Object)context);
    }

    private XmlElementDescriptor[] doCollectElements() {
        LinkedHashMap<String, XmlElementDescriptor> map2 = new LinkedHashMap<String, XmlElementDescriptor>(5);
        this.createProcessor(map2).startProcessing(this.myTag);
        ComplexTypeDescriptor.addSubstitutionGroups(map2, this.myDocumentDescriptor, new HashSet());
        ComplexTypeDescriptor.filterAbstractElements(map2);
        return map2.values().toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    protected XmlSchemaTagsProcessor createProcessor(final Map<String, XmlElementDescriptor> map2) {
        return new XmlSchemaTagsProcessor(this.myDocumentDescriptor, new String[0]){

            @Override
            protected void tagStarted(XmlTag tag, String tagName, XmlTag context, @Nullable XmlTag ref) {
                String refName = ref == null ? null : ref.getAttributeValue(ComplexTypeDescriptor.REF_ATTR_NAME);
                ComplexTypeDescriptor.this.addElementDescriptor(tag, tagName, map2, refName);
            }
        };
    }

    protected void addElementDescriptor(XmlTag tag, String tagName, Map<String, XmlElementDescriptor> map2, @Nullable String refName) {
        if (ELEMENT_TAG_NAME.equals(tagName) && tag.getAttribute(NAME_ATTR_NAME) != null) {
            XmlElementDescriptor element = this.myDocumentDescriptor.createElementDescriptor(tag);
            String name = refName == null ? element.getName() : refName;
            ComplexTypeDescriptor.addElementDescriptor(map2, element, name);
        }
    }

    private static void addSubstitutionGroups(Map<String, XmlElementDescriptor> result2, XmlNSDescriptorImpl nsDescriptor, Set<? super XmlNSDescriptorImpl> visited) {
        block0: while (true) {
            for (XmlElementDescriptor xmlElementDescriptor : result2.values()) {
                XmlElementDescriptorImpl descriptor = (XmlElementDescriptorImpl)xmlElementDescriptor;
                XmlElementDescriptor[] substitutes = nsDescriptor.getSubstitutes(descriptor.getName(), descriptor.getNamespace());
                boolean toContinue = false;
                for (XmlElementDescriptor substitute : substitutes) {
                    if (result2.get(substitute.getName()) != null) continue;
                    toContinue = true;
                    result2.put(substitute.getName(), substitute);
                }
                if (!toContinue) continue;
                continue block0;
            }
            break;
        }
        visited.add(nsDescriptor);
        for (XmlTag tag : nsDescriptor.getTag().getSubTags()) {
            PsiMetaData metaData;
            XmlDocument document;
            PsiElement element;
            PsiReference reference;
            XmlAttributeValue valueElement;
            XmlAttribute location;
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, "include") && !XmlNSDescriptorImpl.equalsToSchemaName(tag, "import") || (location = tag.getAttribute("schemaLocation")) == null || (valueElement = location.getValueElement()) == null || (reference = valueElement.getReference()) == null || !((element = reference.resolve()) instanceof XmlFile) || (document = ((XmlFile)element).getDocument()) == null || !((metaData = document.getMetaData()) instanceof XmlNSDescriptorImpl) || visited.contains(metaData)) continue;
            ComplexTypeDescriptor.addSubstitutionGroups(result2, (XmlNSDescriptorImpl)metaData, visited);
        }
    }

    private static void filterAbstractElements(Map<String, XmlElementDescriptor> result2) {
        Iterator<XmlElementDescriptor> iterator = result2.values().iterator();
        while (iterator.hasNext()) {
            XmlElementDescriptorImpl descriptor = (XmlElementDescriptorImpl)iterator.next();
            if (!descriptor.isAbstract()) continue;
            iterator.remove();
        }
    }

    public XmlAttributeDescriptor[] getAttributes(@Nullable XmlElement context) {
        return (XmlAttributeDescriptor[])myAttributeDescriptorsCache.get(null, (Object)this, (Object)context);
    }

    private XmlAttributeDescriptor[] doCollectAttributes() {
        final ArrayList result2 = new ArrayList();
        XmlSchemaTagsProcessor processor2 = new XmlSchemaTagsProcessor(this.myDocumentDescriptor, new String[]{ELEMENT_TAG_NAME}){

            @Override
            protected void tagStarted(XmlTag tag, String tagName, XmlTag context, XmlTag ref) {
                if (ComplexTypeDescriptor.ATTRIBUTE_TAG_NAME.equals(tagName)) {
                    String name = tag.getAttributeValue(ComplexTypeDescriptor.NAME_ATTR_NAME);
                    if (name == null) {
                        return;
                    }
                    String use = null;
                    if (ComplexTypeDescriptor.ATTRIBUTE_TAG_NAME.equals(context.getLocalName())) {
                        use = context.getAttributeValue("use");
                    }
                    if (use == null) {
                        use = tag.getAttributeValue("use");
                    }
                    if (ComplexTypeDescriptor.PROHIBITED_ATTR_VALUE.equals(use)) {
                        ComplexTypeDescriptor.removeAttributeDescriptor(result2, name, null);
                    } else {
                        XmlAttributeDescriptorImpl descriptor = ComplexTypeDescriptor.this.myDocumentDescriptor.createAttributeDescriptor(tag);
                        descriptor.myUse = use;
                        if (ref != null) {
                            descriptor.myReferenceName = ref.getAttributeValue(ComplexTypeDescriptor.REF_ATTR_NAME);
                        }
                        ComplexTypeDescriptor.addAttributeDescriptor(result2, descriptor);
                    }
                }
            }
        };
        processor2.startProcessing(this.myTag);
        return result2.toArray(XmlAttributeDescriptor.EMPTY);
    }

    public XmlNSDescriptorImpl getNsDescriptor() {
        return this.myDocumentDescriptor;
    }

    protected static void addElementDescriptor(Map<String, XmlElementDescriptor> result2, XmlElementDescriptor element, String name) {
        result2.remove(name);
        result2.put(name, element);
    }

    private static void removeAttributeDescriptor(List<XmlAttributeDescriptorImpl> result2, String name, String referenceName) {
        Iterator<XmlAttributeDescriptorImpl> iterator = result2.iterator();
        while (iterator.hasNext()) {
            XmlAttributeDescriptorImpl descriptor = iterator.next();
            if (!descriptor.getName().equals(name) || referenceName != null && !referenceName.equals(descriptor.myReferenceName)) continue;
            iterator.remove();
        }
    }

    private static void addAttributeDescriptor(List<XmlAttributeDescriptorImpl> result2, XmlAttributeDescriptorImpl descriptor) {
        ComplexTypeDescriptor.removeAttributeDescriptor(result2, descriptor.getName(), descriptor.myReferenceName);
        result2.add(descriptor);
    }

    public boolean canContainTag(String localName, String namespace, XmlElement context) {
        return this._canContainTag(localName, namespace, this.myTag, context, new HashSet<XmlTag>(5), new CurrentContextInfo(this.myDocumentDescriptor, this.myDocumentDescriptor.getDefaultNamespace()), false);
    }

    static CurrentContextInfo getContextInfo(CurrentContextInfo info, String ref) {
        XmlTag rootTag = info.documentDescriptor.getTag();
        XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getNSDescriptorToSearchIn(rootTag, ref, info.documentDescriptor);
        String ns = nsDescriptor == info.documentDescriptor ? rootTag.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(ref)) : nsDescriptor.getDefaultNamespace();
        if (Comparing.equal((String)info.expectedDefaultNs, (String)ns) && info.documentDescriptor == nsDescriptor) {
            return info;
        }
        return new CurrentContextInfo(nsDescriptor, ns);
    }

    private boolean _canContainTag(String localName, String namespace, XmlTag tag, XmlElement context, Set<XmlTag> visited, CurrentContextInfo info, boolean restriction) {
        String ref;
        if (visited.contains(tag)) {
            return false;
        }
        visited.add(tag);
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "any")) {
            if (!restriction) {
                this.myHasAnyInContentModel = true;
            }
            if (OTHER_NAMESPACE_ATTR_VALUE.equals(tag.getAttributeValue("namespace"))) {
                return namespace == null || !namespace.equals(info.expectedDefaultNs);
            }
            return true;
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "group")) {
            XmlTag groupTag;
            ref = tag.getAttributeValue(REF_ATTR_NAME);
            if (ref != null && (groupTag = info.documentDescriptor.findGroup(ref)) != null && this._canContainTag(localName, namespace, groupTag, context, visited, ComplexTypeDescriptor.getContextInfo(info, ref), restriction)) {
                return true;
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag, RESTRICTION_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, EXTENSION_TAG_NAME)) {
            ComplexTypeDescriptor complexTypeDescriptor;
            TypeDescriptor descriptor;
            String base = tag.getAttributeValue(BASE_ATTR_NAME);
            if (base != null && (descriptor = info.documentDescriptor.findTypeDescriptor(base)) instanceof ComplexTypeDescriptor && (complexTypeDescriptor = (ComplexTypeDescriptor)descriptor)._canContainTag(localName, namespace, complexTypeDescriptor.myTag, context, visited, ComplexTypeDescriptor.getContextInfo(info, base), restriction || XmlNSDescriptorImpl.equalsToSchemaName(tag, RESTRICTION_TAG_NAME))) {
                this.myHasAnyInContentModel |= complexTypeDescriptor.myHasAnyInContentModel;
                return true;
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag, ELEMENT_TAG_NAME)) {
            PsiElement psiElement;
            XmlAttributeValue element;
            ref = tag.getAttribute(REF_ATTR_NAME);
            XmlTag descriptorTag = tag;
            if (ref != null && (element = ref.getValueElement()) != null && (psiElement = SchemaReferencesProvider.createTypeOrElementOrAttributeReference((PsiElement)element).resolve()) instanceof XmlTag) {
                descriptorTag = (XmlTag)psiElement;
            }
            if (TRUE_ATTR_VALUE.equals(descriptorTag.getAttributeValue("abstract"))) {
                String substitutionValue;
                XmlNSDescriptor _nsDescriptor = tag.getNSDescriptor(namespace, true);
                if (_nsDescriptor == null && context instanceof XmlTag) {
                    _nsDescriptor = ((XmlTag)context).getNSDescriptor(namespace, true);
                }
                XmlNSDescriptorImpl nsDescriptor = _nsDescriptor instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)_nsDescriptor : null;
                XmlElementDescriptor descriptor = nsDescriptor != null ? nsDescriptor.getElementDescriptor(localName, namespace) : null;
                String name = descriptorTag.getAttributeValue(NAME_ATTR_NAME);
                if (descriptor != null && name != null && (substitutionValue = ((XmlTag)descriptor.getDeclaration()).getAttributeValue("substitutionGroup")) != null && name.equals(XmlUtil.findLocalNameByQualifiedName(substitutionValue))) {
                    return true;
                }
            }
        }
        for (XmlTag subTag : tag.getSubTags()) {
            if (!this._canContainTag(localName, namespace, subTag, context, visited, info, restriction)) continue;
            return true;
        }
        return false;
    }

    public CanContainAttributeType canContainAttribute(String namespace, @Nullable String qName) {
        if (qName == null) {
            return (CanContainAttributeType)((Object)this.myAnyAttributeCache.get(namespace).getValue());
        }
        return this._canContainAttribute(namespace, this.myTag, qName, (Set<String>)new THashSet(), null);
    }

    private CanContainAttributeType _canContainAttribute(String namespace, @NotNull XmlTag tag, @Nullable String qName, Set<String> visited, @Nullable Set<Object> dependencies) {
        XmlTag[] subTags;
        String base;
        if (tag == null) {
            ComplexTypeDescriptor.$$$reportNull$$$0(1);
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "anyAttribute")) {
            if (dependencies != null) {
                dependencies.add(tag.getContainingFile());
            }
            String ns = tag.getAttributeValue("namespace");
            CanContainAttributeType canContainAttributeType = CanContainAttributeType.CanContainButDoNotSkip;
            if ("skip".equals(tag.getAttributeValue("processContents"))) {
                canContainAttributeType = CanContainAttributeType.CanContainButSkip;
            }
            if (OTHER_NAMESPACE_ATTR_VALUE.equals(ns)) {
                return !namespace.equals(this.myDocumentDescriptor.getDefaultNamespace()) ? canContainAttributeType : CanContainAttributeType.CanNotContain;
            }
            if ("##any".equals(ns)) {
                return CanContainAttributeType.CanContainAny;
            }
            return canContainAttributeType;
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "attributeGroup")) {
            String ref = tag.getAttributeValue(REF_ATTR_NAME);
            if (ref != null && !visited.contains(ref)) {
                visited.add(ref);
                XmlTag groupTag = this.myDocumentDescriptor.findAttributeGroup(ref);
                if (groupTag != null) {
                    CanContainAttributeType containAttributeType;
                    if (dependencies != null) {
                        dependencies.add(groupTag.getContainingFile());
                    }
                    if ((containAttributeType = this._canContainAttribute(namespace, groupTag, qName, visited, dependencies)) != CanContainAttributeType.CanNotContain) {
                        return containAttributeType;
                    }
                }
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag, ATTRIBUTE_TAG_NAME)) {
            if (qName != null && qName.equals(tag.getAttributeValue(REF_ATTR_NAME))) {
                return CanContainAttributeType.CanContainButDoNotSkip;
            }
        } else if ((XmlNSDescriptorImpl.equalsToSchemaName(tag, RESTRICTION_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, EXTENSION_TAG_NAME)) && (base = tag.getAttributeValue(BASE_ATTR_NAME)) != null && !visited.contains(base)) {
            visited.add(base);
            TypeDescriptor descriptor = this.myDocumentDescriptor.findTypeDescriptor(base);
            if (descriptor instanceof ComplexTypeDescriptor) {
                CanContainAttributeType containAttributeType;
                ComplexTypeDescriptor complexTypeDescriptor = (ComplexTypeDescriptor)descriptor;
                if (dependencies != null) {
                    XmlTag declaration = complexTypeDescriptor.getDeclaration();
                    dependencies.add(declaration.getContainingFile());
                }
                if ((containAttributeType = complexTypeDescriptor._canContainAttribute(namespace, complexTypeDescriptor.getDeclaration(), qName, visited, dependencies)) != CanContainAttributeType.CanNotContain) {
                    return containAttributeType;
                }
            }
        }
        for (XmlTag subTag : subTags = tag.getSubTags()) {
            CanContainAttributeType containAttributeType = this._canContainAttribute(namespace, subTag, qName, visited, dependencies);
            if (containAttributeType == CanContainAttributeType.CanNotContain) continue;
            return containAttributeType;
        }
        return CanContainAttributeType.CanNotContain;
    }

    public boolean hasAnyInContentModel() {
        return this.myHasAnyInContentModel;
    }

    public int getContentType() {
        if ("simpleType".equals(this.myTag.getLocalName()) || TRUE_ATTR_VALUE.equals(this.myTag.getAttributeValue("mixed"))) {
            return 3;
        }
        if (this.getElements(null).length > 0) {
            return 2;
        }
        for (XmlTag tag : this.myTag.getSubTags()) {
            if (!"simpleContent".equals(tag.getLocalName())) continue;
            return 3;
        }
        return 0;
    }

    public String toString() {
        return this.myTag.getAttributeValue(NAME_ATTR_NAME);
    }

    static /* synthetic */ XmlElementDescriptor[] access$102(ComplexTypeDescriptor x0, XmlElementDescriptor[] x1) {
        x0.myElementDescriptors = x1;
        return x1;
    }

    static /* synthetic */ XmlAttributeDescriptor[] access$302(ComplexTypeDescriptor x0, XmlAttributeDescriptor[] x1) {
        x0.myAttributeDescriptors = x1;
        return x1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/impl/schema/ComplexTypeDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/impl/schema/ComplexTypeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_canContainAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum CanContainAttributeType {
        CanContainButSkip,
        CanContainButDoNotSkip,
        CanContainAny,
        CanNotContain;

    }

    static class CurrentContextInfo {
        final XmlNSDescriptorImpl documentDescriptor;
        final String expectedDefaultNs;

        CurrentContextInfo(XmlNSDescriptorImpl _nsDescriptor, String _ns) {
            this.documentDescriptor = _nsDescriptor;
            this.expectedDefaultNs = _ns;
        }
    }
}

