/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Override
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)sourceElement);
        if (elementType != JsonElementTypes.DOUBLE_QUOTED_STRING && elementType != JsonElementTypes.SINGLE_QUOTED_STRING) {
            return null;
        }
        JsonStringLiteral literal = (JsonStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, JsonStringLiteral.class);
        if (literal == null) {
            return null;
        }
        PsiElement parent = literal.getParent();
        if (literal.getReferences().length == 0 && parent instanceof JsonProperty && ((JsonProperty)parent).getNameElement() == literal) {
            PsiElement target2;
            PsiFile containingFile = literal.getContainingFile();
            JsonSchemaService service2 = JsonSchemaService.Impl.get(literal.getProject());
            VirtualFile file2 = containingFile.getVirtualFile();
            if (file2 == null || !service2.isApplicableToFile(file2)) {
                return null;
            }
            JsonPointerPosition steps = JsonOriginalPsiWalker.INSTANCE.findPosition(literal, true);
            if (steps == null) {
                return null;
            }
            JsonSchemaObject schemaObject = service2.getSchemaObject(containingFile);
            if (schemaObject != null && (target2 = new JsonSchemaResolver(sourceElement.getProject(), schemaObject, steps).findNavigationTarget(((JsonProperty)parent).getValue())) != null) {
                return new PsiElement[]{target2};
            }
        }
        return null;
    }
}

