/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.lexer;

import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.kohsuke.rngom.util.Utf16;

class EscapePreprocessor
extends FilterReader {
    private final TIntArrayList myQueuedChars;
    private final TIntIntHashMap myLengthMap;
    private int myOffset;

    EscapePreprocessor(Reader reader, int startOffset, TIntIntHashMap map2) {
        super(reader);
        this.myOffset = startOffset;
        this.myQueuedChars = new TIntArrayList();
        this.myLengthMap = map2;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = this.read();
        if (i == -1) {
            return -1;
        }
        cbuf[off] = (char)i;
        return 1;
    }

    @Override
    public int read() throws IOException {
        if (this.myQueuedChars.size() > 0) {
            return this.consume();
        }
        int i = super.read();
        if (i == -1) {
            return -1;
        }
        ++this.myOffset;
        switch (i) {
            case 13: {
                assert (false) : "Unexpected newline character";
                if (this.peek() == 10) {
                    this.consume();
                    this.myLengthMap.put(this.myOffset - 1, 2);
                }
            }
            case 10: {
                return 0;
            }
            case 92: {
                int x;
                int n = 0;
                while ((x = this.peek()) == 120) {
                    ++n;
                }
                if (n > 0 && x == 123) {
                    ++n;
                } else {
                    return i;
                }
                int value = 0;
                while (EscapePreprocessor.isHexChar((char)(x = this.peek()))) {
                    ++n;
                    value <<= 4;
                    value |= Character.digit(x, 16);
                }
                if (x == 125) {
                    ++n;
                }
                this.consume(n);
                this.myLengthMap.put(this.myOffset - 1, n);
                this.myOffset += n;
                if (value <= 65535) {
                    return value;
                }
                this.myQueuedChars.add((int)Utf16.surrogate2((int)value));
                return Utf16.surrogate1((int)value);
            }
        }
        return i;
    }

    private static boolean isHexChar(char i) {
        if (Character.isDigit(i)) {
            return true;
        }
        char c = Character.toLowerCase(i);
        return c >= 'a' && c <= 'f';
    }

    private int consume() {
        if (this.myQueuedChars.size() > 0) {
            ++this.myOffset;
            return this.myQueuedChars.remove(0);
        }
        return -1;
    }

    private void consume(int n) {
        this.myQueuedChars.remove(0, n);
    }

    private int peek() throws IOException {
        int i = super.read();
        if (i == -1) {
            return -1;
        }
        this.myQueuedChars.add(i);
        return i;
    }
}

