/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

class AliasedAnnotationHolder
implements AnnotationHolder {
    private final AnnotationHolder myHolder;
    private final GrAnnotation myAlias;
    private final GrCodeReferenceElement myReference;

    AliasedAnnotationHolder(@NotNull AnnotationHolder holder, @NotNull GrAnnotation alias) {
        if (holder == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(0);
        }
        if (alias == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(1);
        }
        this.myHolder = holder;
        this.myAlias = alias;
        this.myReference = this.myAlias.getClassReference();
    }

    @NotNull
    private PsiElement findCodeElement(@NotNull PsiElement elt) {
        if (elt == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(2);
        }
        if (PsiTreeUtil.isAncestor((PsiElement)this.myAlias, (PsiElement)elt, (boolean)true)) {
            PsiElement psiElement = elt;
            if (psiElement == null) {
                AliasedAnnotationHolder.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        GrCodeReferenceElement grCodeReferenceElement = this.myReference;
        if (grCodeReferenceElement == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(4);
        }
        return grCodeReferenceElement;
    }

    public Annotation createErrorAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        if (elt == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(5);
        }
        PsiElement codeElement = this.findCodeElement(elt);
        return this.myHolder.createErrorAnnotation(codeElement, message);
    }

    public Annotation createErrorAnnotation(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(6);
        }
        return this.createErrorAnnotation(node.getPsi(), message);
    }

    public Annotation createErrorAnnotation(@NotNull TextRange range, @Nullable String message) {
        if (range == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createWarningAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        if (elt == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(8);
        }
        return this.myHolder.createWarningAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createWarningAnnotation(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(9);
        }
        return this.myHolder.createWarningAnnotation(node.getPsi(), message);
    }

    public Annotation createWarningAnnotation(@NotNull TextRange range, @Nullable String message) {
        if (range == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createWeakWarningAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        if (elt == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(11);
        }
        return this.myHolder.createWeakWarningAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(12);
        }
        return this.myHolder.createWarningAnnotation(node.getPsi(), message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull TextRange range, @Nullable String message) {
        if (range == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createInfoAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        if (elt == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(14);
        }
        return this.myHolder.createInfoAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createInfoAnnotation(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(15);
        }
        return this.myHolder.createInfoAnnotation(node.getPsi(), message);
    }

    public Annotation createInfoAnnotation(@NotNull TextRange range, @Nullable String message) {
        if (range == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message) {
        if (severity == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(17);
        }
        if (range == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(18);
        }
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message, @Nullable String htmlTooltip) {
        if (severity == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(19);
        }
        if (range == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(20);
        }
        throw new UnsupportedOperationException("unsupported");
    }

    @NotNull
    public AnnotationSession getCurrentAnnotationSession() {
        AnnotationSession annotationSession = this.myHolder.getCurrentAnnotationSession();
        if (annotationSession == null) {
            AliasedAnnotationHolder.$$$reportNull$$$0(21);
        }
        return annotationSession;
    }

    public boolean isBatchMode() {
        return this.myHolder.isBatchMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 3: 
            case 4: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeElement";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentAnnotationSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findCodeElement";
                break;
            }
            case 3: 
            case 4: 
            case 21: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createErrorAnnotation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createWarningAnnotation";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createWeakWarningAnnotation";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createInfoAnnotation";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

