/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.noReturnMethod;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ThrowingInstruction;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class MissingReturnInspection
extends GroovySuppressableInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("no.return.display.name", new Object[0]);
        if (string == null) {
            MissingReturnInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static PsiType getExpectedClosureReturnType(GrClosableBlock closure) {
        ArrayList<PsiType> expectedReturnTypes = new ArrayList<PsiType>();
        PsiElement parent2 = closure.getParent();
        if (parent2 instanceof GrArgumentList && parent2.getParent() instanceof GrMethodCall || parent2 instanceof GrMethodCall) {
            GroovyResolveResult[] variants;
            GrMethodCall call = (GrMethodCall)(parent2 instanceof GrArgumentList ? parent2.getParent() : parent2);
            for (GroovyResolveResult variant : variants = call.getCallVariants(null)) {
                PsiType[] parameters;
                PsiParameter parameter;
                PsiType type2;
                Pair<PsiParameter, PsiType> pair;
                Map<GrExpression, Pair<PsiParameter, PsiType>> map2 = GrClosureSignatureUtil.mapArgumentsToParameters(variant, closure, true, true, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments());
                if (map2 == null || (pair = map2.get(closure)) == null || !TypesUtil.isPsiClassTypeToClosure(type2 = (parameter = (PsiParameter)pair.getFirst()).getType()) || (parameters = ((PsiClassType)type2).getParameters()).length != 1) continue;
                expectedReturnTypes.add(parameters[0]);
            }
        } else {
            for (PsiType expectedType : GroovyExpectedTypesProvider.getDefaultExpectedTypes(closure)) {
                PsiType[] parameters;
                if (!TypesUtil.isPsiClassTypeToClosure(expectedType) || (parameters = ((PsiClassType)expectedType).getParameters()).length != 1) continue;
                expectedReturnTypes.add(parameters[0]);
            }
        }
        for (PsiType type3 : expectedReturnTypes) {
            if (!PsiType.VOID.equals((Object)type3) && !PsiType.VOID.equals((Object)PsiPrimitiveType.getUnboxedType((PsiType)type3))) continue;
            return PsiType.VOID;
        }
        return TypesUtil.getLeastUpperBoundNullable(expectedReturnTypes, closure.getManager());
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean onTheFly) {
        if (problemsHolder == null) {
            MissingReturnInspection.$$$reportNull$$$0(1);
        }
        GroovyPsiElementVisitor groovyPsiElementVisitor = new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                if (closure == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitClosure(closure);
                MissingReturnInspection.check(closure, problemsHolder, ReturnStatus.getReturnStatus(closure));
            }

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitMethod(method);
                GrOpenBlock block = method.getBlock();
                if (block != null) {
                    MissingReturnInspection.check(block, problemsHolder, ReturnStatus.getReturnStatus(method));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "closure";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/noReturnMethod/MissingReturnInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClosure";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (groovyPsiElementVisitor == null) {
            MissingReturnInspection.$$$reportNull$$$0(2);
        }
        return groovyPsiElementVisitor;
    }

    private static void check(GrCodeBlock block, ProblemsHolder holder, ReturnStatus returnStatus) {
        if (MissingReturnInspection.methodMissesSomeReturns(block, returnStatus)) {
            MissingReturnInspection.addNoReturnMessage(block, holder);
        }
    }

    public static boolean methodMissesSomeReturns(@NotNull GrControlFlowOwner block, final @NotNull ReturnStatus returnStatus) {
        if (block == null) {
            MissingReturnInspection.$$$reportNull$$$0(3);
        }
        if (returnStatus == null) {
            MissingReturnInspection.$$$reportNull$$$0(4);
        }
        if (returnStatus == ReturnStatus.shouldNotReturnValue) {
            return false;
        }
        final Ref alwaysHaveReturn = new Ref((Object)true);
        final Ref sometimesHaveReturn = new Ref((Object)false);
        final Ref hasExplicitReturn = new Ref((Object)false);
        ControlFlowUtils.visitAllExitPoints(block, new ControlFlowUtils.ExitPointVisitor(){

            @Override
            public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                if (instruction instanceof ThrowingInstruction) {
                    if (returnStatus == ReturnStatus.mustReturnValue) {
                        sometimesHaveReturn.set((Object)true);
                    }
                    return true;
                }
                if (instruction instanceof MaybeReturnInstruction && ((MaybeReturnInstruction)instruction).mayReturnValue()) {
                    sometimesHaveReturn.set((Object)true);
                    return true;
                }
                if (instruction.getElement() instanceof GrReturnStatement && returnValue != null) {
                    sometimesHaveReturn.set((Object)true);
                    hasExplicitReturn.set((Object)true);
                    return true;
                }
                alwaysHaveReturn.set((Object)false);
                return true;
            }
        });
        if (returnStatus == ReturnStatus.mustReturnValue && !((Boolean)sometimesHaveReturn.get()).booleanValue()) {
            return true;
        }
        return (Boolean)sometimesHaveReturn.get() != false && (Boolean)alwaysHaveReturn.get() == false;
    }

    private static void addNoReturnMessage(GrCodeBlock block, ProblemsHolder holder) {
        PsiElement lastChild = block.getLastChild();
        if (lastChild == null) {
            return;
        }
        TextRange range = lastChild.getTextRange();
        if (!lastChild.isValid() || !lastChild.isPhysical() || range.getStartOffset() >= range.getEndOffset()) {
            return;
        }
        holder.registerProblem(lastChild, GroovyInspectionBundle.message("no.return.message", new Object[0]), new LocalQuickFix[0]);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GroovyMissingReturnStatement" == null) {
            MissingReturnInspection.$$$reportNull$$$0(5);
        }
        return "GroovyMissingReturnStatement";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/noReturnMethod/MissingReturnInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/noReturnMethod/MissingReturnInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "methodMissesSomeReturns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ReturnStatus {
        mustReturnValue,
        shouldReturnValue,
        shouldNotReturnValue;


        public static ReturnStatus getReturnStatus(PsiElement subject) {
            if (subject instanceof GrClosableBlock) {
                PsiClass resolved;
                PsiType inferredReturnType = MissingReturnInspection.getExpectedClosureReturnType((GrClosableBlock)subject);
                if (inferredReturnType instanceof PsiClassType && (resolved = ((PsiClassType)inferredReturnType).resolve()) != null && !(resolved instanceof PsiTypeParameter)) {
                    return mustReturnValue;
                }
                return inferredReturnType != null && !PsiType.VOID.equals((Object)inferredReturnType) ? shouldReturnValue : shouldNotReturnValue;
            }
            if (subject instanceof GrMethod) {
                return ((GrMethod)subject).getReturnTypeElementGroovy() != null && !PsiType.VOID.equals((Object)((GrMethod)subject).getReturnType()) ? mustReturnValue : shouldNotReturnValue;
            }
            return shouldNotReturnValue;
        }
    }
}

