/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.text.StringFactory;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.ApplicationStatementUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrSyntheticCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrSyntheticExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrSyntheticTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public class PsiImplUtil {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil");
    private static final String MAIN_METHOD = "main";
    public static final Key<SoftReference<PsiCodeBlock>> PSI_CODE_BLOCK = Key.create((String)"Psi_code_block");
    public static final Key<SoftReference<PsiTypeElement>> PSI_TYPE_ELEMENT = Key.create((String)"psi.type.element");
    public static final Key<SoftReference<PsiExpression>> PSI_EXPRESSION = Key.create((String)"psi.expression");

    private PsiImplUtil() {
    }

    @Nullable
    private static GrLiteral getRegexAtTheBeginning(PsiElement expr) {
        for (PsiElement firstChild = expr; firstChild != null; firstChild = firstChild.getFirstChild()) {
            if (!(firstChild instanceof GrLiteral) || !GrStringUtil.isRegex((GrLiteral)firstChild)) continue;
            return (GrLiteral)firstChild;
        }
        return null;
    }

    private static boolean isAfterIdentifier(PsiElement el) {
        PsiElement prev = PsiUtil.getPreviousNonWhitespaceToken(el);
        return prev != null && prev.getNode().getElementType() == GroovyTokenTypes.mIDENT;
    }

    @Nullable
    public static GrExpression replaceExpression(GrExpression oldExpr, GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        PsiElement oldParent = oldExpr.getParent();
        if (oldParent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)oldExpr);
        }
        if (PsiImplUtil.convertToMethodCall(oldExpr)) {
            newExpr = ApplicationStatementUtil.convertToMethodCallExpression(newExpr);
        }
        if (removeUnnecessaryParentheses && oldParent instanceof GrParenthesizedExpression && !(oldParent.getParent() instanceof GrArgumentLabel)) {
            return ((GrExpression)oldParent).replaceWithExpression(newExpr, true);
        }
        if (PsiImplUtil.getRegexAtTheBeginning(newExpr) != null && PsiImplUtil.isAfterIdentifier(oldExpr)) {
            PsiElement copy = newExpr.copy();
            GrLiteral regex = PsiImplUtil.getRegexAtTheBeginning(copy);
            LOG.assertTrue(regex != null);
            GrLiteral stringLiteral = GrStringUtil.createStringFromRegex(regex);
            if (regex == copy) {
                return oldExpr.replaceWithExpression(stringLiteral, removeUnnecessaryParentheses);
            }
            regex.replace(stringLiteral);
            return oldExpr.replaceWithExpression((GrExpression)copy, removeUnnecessaryParentheses);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(oldExpr.getProject());
        if (oldParent instanceof GrStringInjection) {
            if (newExpr instanceof GrString || newExpr instanceof GrLiteral && ((GrLiteral)newExpr).getValue() instanceof String) {
                return GrStringUtil.replaceStringInjectionByLiteral((GrStringInjection)oldParent, (GrLiteral)newExpr);
            }
            GrClosableBlock block = factory.createClosureFromText("{foo}");
            oldParent.getNode().replaceChild(oldExpr.getNode(), block.getNode());
            GrStatement[] statements = block.getStatements();
            return ((GrExpression)statements[0]).replaceWithExpression(newExpr, removeUnnecessaryParentheses);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)oldExpr, GrStringInjection.class, (boolean)false, (Class[])new Class[]{GrCodeBlock.class}) != null) {
            GrStringInjection stringInjection = (GrStringInjection)PsiTreeUtil.getParentOfType((PsiElement)oldExpr, GrStringInjection.class);
            assert (stringInjection != null);
            GrStringUtil.wrapInjection(stringInjection);
            return oldExpr.replaceWithExpression(newExpr, removeUnnecessaryParentheses);
        }
        if (oldParent instanceof GrExpression && !(oldParent instanceof GrParenthesizedExpression)) {
            GrExpression addedParenth;
            GrExpression grExpression = addedParenth = ParenthesesUtils.checkPrecedence(newExpr, oldExpr) ? ParenthesesUtils.parenthesize(newExpr) : newExpr;
            if (newExpr != addedParenth) {
                return oldExpr.replaceWithExpression(addedParenth, removeUnnecessaryParentheses);
            }
        }
        if (oldParent instanceof GrForInClause) {
            return (GrExpression)oldExpr.replace(ParenthesesUtils.parenthesize(newExpr));
        }
        if (oldExpr instanceof GrClosableBlock && !(newExpr instanceof GrClosableBlock) && oldParent instanceof GrMethodCallExpression && ArrayUtil.contains((Object)oldExpr, (Object[])((GrMethodCallExpression)oldParent).getClosureArguments())) {
            return ((GrMethodCallExpression)oldParent).replaceClosureArgument((GrClosableBlock)oldExpr, newExpr);
        }
        if ((newExpr = (GrExpression)oldExpr.replace(newExpr)) instanceof GrParenthesizedExpression && PsiImplUtil.isFirstChild(newExpr)) {
            PsiElement parent2;
            int parentCount = 0;
            PsiElement element = oldParent;
            while (!(element instanceof GrCommandArgumentList || element instanceof GrCodeBlock || element instanceof GrParenthesizedExpression || element instanceof PsiFile || (parent2 = element.getParent()) == null || !PsiImplUtil.isFirstChild(element))) {
                element = parent2;
                ++parentCount;
            }
            if (element instanceof GrCommandArgumentList) {
                GrCommandArgumentList commandArgList = (GrCommandArgumentList)element;
                PsiElement parent3 = commandArgList.getParent();
                LOG.assertTrue(parent3 instanceof GrApplicationStatement);
                GrMethodCallExpression methodCall = factory.createMethodCallByAppCall((GrApplicationStatement)parent3);
                GrMethodCall newCall = (GrMethodCall)parent3.replace((PsiElement)methodCall);
                GroovyPsiElement result2 = newCall.getArgumentList().getAllArguments()[0];
                for (int i = 0; i < parentCount; ++i) {
                    assert (result2 != null);
                    result2 = PsiUtil.skipWhitespacesAndComments(result2.getFirstChild(), true);
                }
                LOG.assertTrue(result2 instanceof GrParenthesizedExpression);
                return (GrExpression)result2;
            }
        }
        return newExpr;
    }

    private static boolean convertToMethodCall(GrExpression position) {
        if (position instanceof GrApplicationStatement) {
            return false;
        }
        PsiElement parent2 = position.getParent();
        return !(parent2 instanceof GrVariable) || ((GrVariable)parent2).getInitializerGroovy() != position;
    }

    private static boolean isFirstChild(PsiElement element) {
        return PsiUtil.skipWhitespacesAndComments(element.getParent().getFirstChild(), true) == element;
    }

    public static void removeVariable(GrVariable variable) {
        GrVariableDeclaration varDecl = (GrVariableDeclaration)variable.getParent();
        List<GrVariable> variables = Arrays.asList(varDecl.getVariables());
        if (!variables.contains(variable)) {
            throw new IllegalArgumentException();
        }
        PsiElement parent2 = varDecl.getParent();
        ASTNode owner = parent2.getNode();
        if (variables.size() == 1 && owner != null) {
            PsiElement next = varDecl.getNextSibling();
            while (next != null && next.getNode() != null && next.getNode().getElementType() == GroovyTokenTypes.mSEMI) {
                PsiElement tmpNext = next.getNextSibling();
                next.delete();
                next = tmpNext;
            }
            PsiImplUtil.removeNewLineAfter(varDecl);
            varDecl.delete();
            return;
        }
        variable.delete();
    }

    @Nullable
    public static PsiElement realPrevious(PsiElement previousLeaf) {
        while (previousLeaf instanceof PsiWhiteSpace || previousLeaf instanceof PsiComment || previousLeaf instanceof PsiErrorElement) {
            previousLeaf = previousLeaf.getPrevSibling();
        }
        return previousLeaf;
    }

    public static void setName(String name, PsiElement nameElement) {
        PsiElement newNameElement = GroovyPsiElementFactory.getInstance(nameElement.getProject()).createReferenceNameFromText(name);
        nameElement.replace(newNameElement);
    }

    public static boolean isExtendsSignature(MethodSignature superSignatureCandidate, MethodSignature subSignature) {
        return MethodSignatureUtil.isSubsignature((MethodSignature)superSignatureCandidate, (MethodSignature)subSignature);
    }

    @Nullable
    public static PsiMethod extractUniqueElement(@NotNull GroovyResolveResult[] results) {
        if (results == null) {
            PsiImplUtil.$$$reportNull$$$0(0);
        }
        if (results.length != 1) {
            return null;
        }
        PsiElement element = results[0].getElement();
        return element instanceof PsiMethod ? (PsiMethod)element : null;
    }

    @NotNull
    public static GroovyResolveResult extractUniqueResult(@NotNull Collection<? extends GroovyResolveResult> results) {
        if (results == null) {
            PsiImplUtil.$$$reportNull$$$0(1);
        }
        GroovyResolveResult groovyResolveResult = results.size() == 1 ? results.iterator().next() : EmptyGroovyResolveResult.INSTANCE;
        if (groovyResolveResult == null) {
            PsiImplUtil.$$$reportNull$$$0(2);
        }
        return groovyResolveResult;
    }

    @NotNull
    public static GroovyResolveResult extractUniqueResult(@NotNull GroovyResolveResult[] results) {
        if (results == null) {
            PsiImplUtil.$$$reportNull$$$0(3);
        }
        if (results.length != 1) {
            EmptyGroovyResolveResult emptyGroovyResolveResult = EmptyGroovyResolveResult.INSTANCE;
            if (emptyGroovyResolveResult == null) {
                PsiImplUtil.$$$reportNull$$$0(4);
            }
            return emptyGroovyResolveResult;
        }
        GroovyResolveResult groovyResolveResult = results[0];
        if (groovyResolveResult == null) {
            PsiImplUtil.$$$reportNull$$$0(5);
        }
        return groovyResolveResult;
    }

    public static PsiMethod[] mapToMethods(@Nullable List<? extends CandidateInfo> list) {
        if (list == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] result2 = new PsiMethod[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result2[i] = (PsiMethod)list.get(i).getElement();
        }
        return result2;
    }

    @NotNull
    public static String getName(@NotNull GrNamedElement namedElement) {
        PsiElement nameElement;
        ASTNode node;
        if (namedElement == null) {
            PsiImplUtil.$$$reportNull$$$0(6);
        }
        LOG.assertTrue((node = (nameElement = namedElement.getNameIdentifierGroovy()).getNode()) != null);
        if (node.getElementType() == GroovyTokenTypes.mIDENT) {
            String string = nameElement.getText();
            if (string == null) {
                PsiImplUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (GroovyTokenSets.STRING_LITERALS.contains(node.getElementType())) {
            Object value = GrLiteralImpl.getLiteralValue(nameElement);
            if (value instanceof String) {
                String string = (String)value;
                if (string == null) {
                    PsiImplUtil.$$$reportNull$$$0(8);
                }
                return string;
            }
            String string = GrStringUtil.removeQuotes(nameElement.getText());
            if (string == null) {
                PsiImplUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        throw new IncorrectOperationException("incorrect name element: " + node.getElementType() + ", named element: " + namedElement);
    }

    public static void removeNewLineAfter(@NotNull GrStatement statement) {
        if (statement == null) {
            PsiImplUtil.$$$reportNull$$$0(10);
        }
        ASTNode parentNode = statement.getParent().getNode();
        ASTNode next = statement.getNode().getTreeNext();
        if (parentNode != null && next != null && GroovyTokenTypes.mNLS == next.getElementType()) {
            parentNode.removeChild(next);
        }
    }

    public static boolean isMainMethod(GrMethod method) {
        if (!method.getName().equals(MAIN_METHOD)) {
            return false;
        }
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        GrParameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return false;
        }
        if (parameters.length == 1 && parameters[0].getTypeElementGroovy() == null) {
            return true;
        }
        int args_count = 0;
        int optional_count = 0;
        for (GrParameter p : parameters) {
            GrTypeElement declaredType = p.getTypeElementGroovy();
            boolean optional = p.isOptional();
            if (optional) {
                ++optional_count;
                continue;
            }
            if (declaredType != null && !declaredType.getType().equalsToText("java.lang.String[]")) continue;
            ++args_count;
        }
        return optional_count == parameters.length - 1 && args_count == 1;
    }

    public static void deleteStatementTail(PsiElement container, @NotNull PsiElement statement) {
        if (statement == null) {
            PsiImplUtil.$$$reportNull$$$0(11);
        }
        PsiElement next = statement.getNextSibling();
        while (next != null) {
            int first;
            ASTNode node = next.getNode();
            IElementType type2 = node.getElementType();
            if (type2 == GroovyTokenTypes.mSEMI || type2 == TokenType.WHITE_SPACE && !next.getText().contains("\n")) {
                PsiElement nNext = next.getNextSibling();
                container.deleteChildRange(next, next);
                next = nNext;
                continue;
            }
            if (type2 != GroovyTokenTypes.mNLS && (type2 != TokenType.WHITE_SPACE || !next.getText().contains("\n"))) break;
            String text = next.getText();
            int second = text.indexOf("\n", (first = text.indexOf("\n")) + 1);
            if (second < 0) {
                container.deleteChildRange(next, next);
                return;
            }
            String substring = text.substring(second);
            container.getNode().replaceChild(node, (ASTNode)Factory.createSingleLeafElement((IElementType)type2, (CharSequence)substring, (int)0, (int)substring.length(), null, (PsiManager)container.getManager()));
            return;
        }
    }

    public static <T extends PsiElement> void setQualifier(@NotNull GrQualifiedReference<? extends T> ref, @Nullable T newQualifier) {
        if (ref == null) {
            PsiImplUtil.$$$reportNull$$$0(12);
        }
        T oldQualifier = ref.getQualifier();
        ASTNode node = ref.getNode();
        PsiElement refNameElement = ref.getReferenceNameElement();
        if (newQualifier == null) {
            if (oldQualifier != null && refNameElement != null) {
                ref.deleteChildRange(ref.getFirstChild(), refNameElement.getPrevSibling());
            }
        } else if (oldQualifier == null) {
            if (refNameElement != null) {
                node.addLeaf(GroovyTokenTypes.mDOT, (CharSequence)".", refNameElement.getNode());
                ref.addBefore(newQualifier, refNameElement.getPrevSibling());
            }
        } else {
            oldQualifier.replace(newQualifier);
        }
    }

    public static boolean isSimpleArrayAccess(PsiType exprType, PsiType[] argTypes, PsiElement context, boolean isLValue) {
        return exprType instanceof PsiArrayType && (isLValue && argTypes.length == 2 || !isLValue && argTypes.length == 1) && TypesUtil.isAssignableByMethodCallConversion((PsiType)PsiType.INT, argTypes[0], context);
    }

    public static String getTextSkipWhiteSpaceAndComments(ASTNode node) {
        TreeElement treeElement = (TreeElement)node;
        GroovyBufferVisitor lengthVisitor = new GroovyBufferVisitor(true, true, 0, null);
        treeElement.acceptTree((TreeElementVisitor)lengthVisitor);
        int length = lengthVisitor.getEnd();
        char[] buffer = new char[length];
        GroovyBufferVisitor textVisitor = new GroovyBufferVisitor(true, true, 0, buffer);
        treeElement.acceptTree((TreeElementVisitor)textVisitor);
        return StringFactory.createShared((char[])buffer);
    }

    public static PsiCodeBlock getOrCreatePsiCodeBlock(GrOpenBlock block) {
        if (block == null) {
            return null;
        }
        SoftReference ref = (SoftReference)block.getUserData(PSI_CODE_BLOCK);
        PsiCodeBlock body = (PsiCodeBlock)SoftReference.dereference((Reference)ref);
        if (body != null) {
            return body;
        }
        GrSyntheticCodeBlock newBody = new GrSyntheticCodeBlock(block);
        block.putUserData(PSI_CODE_BLOCK, new SoftReference((Object)newBody));
        return newBody;
    }

    public static PsiTypeElement getOrCreateTypeElement(GrTypeElement typeElement) {
        if (typeElement == null) {
            return null;
        }
        SoftReference ref = (SoftReference)typeElement.getUserData(PSI_TYPE_ELEMENT);
        PsiTypeElement element = (PsiTypeElement)SoftReference.dereference((Reference)ref);
        if (element != null) {
            return element;
        }
        GrSyntheticTypeElement newTypeElement = new GrSyntheticTypeElement(typeElement);
        typeElement.putUserData(PSI_TYPE_ELEMENT, new SoftReference((Object)newTypeElement));
        return newTypeElement;
    }

    public static PsiExpression getOrCreatePisExpression(GrExpression expr) {
        if (expr == null) {
            return null;
        }
        SoftReference ref = (SoftReference)expr.getUserData(PSI_EXPRESSION);
        PsiExpression element = (PsiExpression)SoftReference.dereference((Reference)ref);
        if (element != null) {
            return element;
        }
        GrSyntheticExpression newExpr = new GrSyntheticExpression(expr);
        expr.putUserData(PSI_EXPRESSION, new SoftReference((Object)newExpr));
        return newExpr;
    }

    public static <T extends GrCondition> T replaceBody(T newBody, GrStatement body, ASTNode node, Project project) {
        if (body == null || newBody == null) {
            throw new IncorrectOperationException();
        }
        ASTNode oldBodyNode = body.getNode();
        if (oldBodyNode.getTreePrev() != null && GroovyTokenTypes.mNLS.equals(oldBodyNode.getTreePrev().getElementType())) {
            ASTNode whiteNode = GroovyPsiElementFactory.getInstance(project).createWhiteSpace().getNode();
            node.replaceChild(oldBodyNode.getTreePrev(), whiteNode);
        }
        node.replaceChild(oldBodyNode, newBody.getNode());
        return newBody;
    }

    public static boolean isVarArgs(GrParameter[] parameters) {
        return parameters.length > 0 && parameters[parameters.length - 1].isVarArgs();
    }

    @Nullable
    public static PsiAnnotation getAnnotation(@NotNull PsiModifierListOwner field, @NotNull String annotationName) {
        PsiModifierList modifierList;
        if (field == null) {
            PsiImplUtil.$$$reportNull$$$0(13);
        }
        if (annotationName == null) {
            PsiImplUtil.$$$reportNull$$$0(14);
        }
        if ((modifierList = field.getModifierList()) == null) {
            return null;
        }
        return modifierList.findAnnotation(annotationName);
    }

    @Nullable
    public static GrConstructorInvocation getChainingConstructorInvocation(GrMethod constructor) {
        if (constructor instanceof GrReflectedMethod && ((GrReflectedMethod)constructor).getSkippedParameters().length > 0) {
            return null;
        }
        LOG.assertTrue(constructor.isConstructor());
        GrOpenBlock body = constructor.getBlock();
        if (body == null) {
            return null;
        }
        GrStatement[] statements = body.getStatements();
        if (statements.length > 0 && statements[0] instanceof GrConstructorInvocation) {
            return (GrConstructorInvocation)statements[0];
        }
        return null;
    }

    public static GrMethod[] getMethodOrReflectedMethods(GrMethod method) {
        GrMethod[] grMethodArray;
        GrMethod[] reflectedMethods = method.getReflectedMethods();
        if (reflectedMethods.length > 0) {
            grMethodArray = reflectedMethods;
        } else {
            GrMethod[] grMethodArray2 = new GrMethod[1];
            grMethodArray = grMethodArray2;
            grMethodArray2[0] = method;
        }
        return grMethodArray;
    }

    @Nullable
    public static PsiType inferExpectedTypeForDiamond(GrExpression diamondNew) {
        PsiElement skipped = PsiUtil.skipParentheses(diamondNew, true);
        assert (skipped != null);
        PsiElement pParent = skipped.getParent();
        if (pParent instanceof GrAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((GrAssignmentExpression)pParent).getRValue(), (PsiElement)diamondNew, (boolean)false)) {
            GrExpression lValue = ((GrAssignmentExpression)pParent).getLValue();
            if (PsiUtil.mightBeLValue(lValue)) {
                return lValue.getNominalType();
            }
        } else {
            PsiElement ppParent;
            if (pParent instanceof GrVariable && ((GrVariable)pParent).getInitializerGroovy() == diamondNew) {
                return ((GrVariable)pParent).getDeclaredType();
            }
            if (pParent instanceof GrListOrMap && (ppParent = PsiUtil.skipParentheses(pParent.getParent(), true)) instanceof GrTupleAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((GrTupleAssignmentExpression)ppParent).getRValue(), (PsiElement)pParent, (boolean)false)) {
                GrReferenceExpression[] expressions;
                GrTuple lValue = ((GrTupleAssignmentExpression)ppParent).getLValue();
                Object[] initializers = ((GrListOrMap)pParent).getInitializers();
                int index = ArrayUtil.find((Object[])initializers, (Object)diamondNew);
                if (index < (expressions = lValue.getExpressions()).length) {
                    return expressions[index].getNominalType();
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiType normalizeWildcardTypeByPosition(@NotNull PsiType type2, @NotNull GrExpression expression) {
        GrExpression topLevel;
        if (type2 == null) {
            PsiImplUtil.$$$reportNull$$$0(15);
        }
        if (expression == null) {
            PsiImplUtil.$$$reportNull$$$0(16);
        }
        for (topLevel = expression; topLevel.getParent() instanceof GrIndexProperty && ((GrIndexProperty)topLevel.getParent()).getInvokedExpression() == topLevel; topLevel = (GrExpression)topLevel.getParent()) {
        }
        return PsiImplUtil.doNormalizeWildcardByPosition(type2, expression, topLevel);
    }

    @Nullable
    private static PsiType doNormalizeWildcardByPosition(PsiType type2, GrExpression expression, GrExpression topLevel) {
        PsiType componentType;
        PsiType normalizedComponentType;
        if (type2 instanceof PsiCapturedWildcardType) {
            return PsiImplUtil.doNormalizeWildcardByPosition((PsiType)((PsiCapturedWildcardType)type2).getWildcard(), expression, topLevel);
        }
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            if (PsiUtil.isAccessedForWriting(topLevel)) {
                return wildcardType.getBound();
            }
            if (wildcardType.isExtends()) {
                return wildcardType.getBound();
            }
            return TypesUtil.getJavaLangObject(expression);
        }
        if (type2 instanceof PsiArrayType && (normalizedComponentType = PsiImplUtil.doNormalizeWildcardByPosition(componentType = ((PsiArrayType)type2).getComponentType(), expression, topLevel)) != componentType) {
            assert (normalizedComponentType != null);
            return normalizedComponentType.createArrayType();
        }
        return type2;
    }

    public static boolean hasElementType(@Nullable PsiElement next, @NotNull IElementType type2) {
        if (type2 == null) {
            PsiImplUtil.$$$reportNull$$$0(17);
        }
        if (next == null) {
            return false;
        }
        ASTNode astNode = next.getNode();
        return astNode != null && astNode.getElementType() == type2;
    }

    public static boolean hasNamedArguments(@Nullable GrNamedArgumentsOwner list) {
        if (list == null) {
            return false;
        }
        for (PsiElement child = list.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GrNamedArgument)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExpressionArguments(@Nullable GrArgumentList list) {
        if (list == null) {
            return false;
        }
        for (PsiElement child = list.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GrExpression)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasArguments(@NotNull GrCall call) {
        if (call == null) {
            PsiImplUtil.$$$reportNull$$$0(18);
        }
        if (call.hasClosureArguments()) {
            return true;
        }
        GrArgumentList list = call.getArgumentList();
        return PsiImplUtil.hasExpressionArguments(list) || PsiImplUtil.hasNamedArguments(list);
    }

    public static PsiElement findTailingSemicolon(@NotNull GrStatement statement) {
        PsiElement nextNonSpace;
        if (statement == null) {
            PsiImplUtil.$$$reportNull$$$0(19);
        }
        if ((nextNonSpace = PsiUtil.skipWhitespaces(statement.getNextSibling(), true)) != null && nextNonSpace.getNode().getElementType() == GroovyTokenTypes.mSEMI) {
            return nextNonSpace;
        }
        return null;
    }

    @Nullable
    public static PsiType inferReturnType(PsiElement position) {
        GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(position);
        if (flowOwner == null) {
            return null;
        }
        PsiElement parent2 = flowOwner.getContext();
        if (flowOwner instanceof GrOpenBlock && parent2 instanceof GrMethod) {
            GrMethod method = (GrMethod)parent2;
            if (method.isConstructor()) {
                return null;
            }
            return method.getReturnType();
        }
        return null;
    }

    public static GrStatement[] getStatements(GrStatementOwner statementOwner) {
        ArrayList<GrStatement> result2 = new ArrayList<GrStatement>();
        for (PsiElement cur = statementOwner.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrStatement)) continue;
            result2.add((GrStatement)cur);
        }
        return result2.toArray(GrStatement.EMPTY_ARRAY);
    }

    public static GrNamedArgument findNamedArgument(GrNamedArgumentsOwner namedArgumentOwner, String label) {
        for (PsiElement cur = namedArgumentOwner.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrNamedArgument) || !label.equals(((GrNamedArgument)cur).getLabelName())) continue;
            return (GrNamedArgument)cur;
        }
        return null;
    }

    public static boolean isWhiteSpaceOrNls(@Nullable PsiElement sibling) {
        return sibling != null && PsiImplUtil.isWhiteSpaceOrNls(sibling.getNode());
    }

    public static boolean isWhiteSpaceOrNls(@Nullable ASTNode node) {
        return node != null && TokenSets.WHITE_SPACES_SET.contains(node.getElementType());
    }

    public static void insertPlaceHolderToModifierListAtEndIfNeeded(GrModifierList modifierList) {
        PsiElement newLineAfterModifierList = PsiImplUtil.findNewLineAfterElement(modifierList);
        if (newLineAfterModifierList != null) {
            modifierList.setModifierProperty("def", false);
            if (modifierList.getModifiers().length > 0) {
                modifierList.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)newLineAfterModifierList.getText(), null);
            }
            modifierList.getNode().addLeaf(GroovyTokenTypes.kDEF, (CharSequence)"def", null);
            PsiElement newLineUpdated = PsiImplUtil.findNewLineAfterElement(modifierList);
            if (newLineUpdated != null) {
                newLineUpdated.delete();
            }
            if (!PsiImplUtil.isWhiteSpaceOrNls(modifierList.getNextSibling())) {
                modifierList.getParent().getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", modifierList.getNextSibling().getNode());
            }
        } else if (modifierList.getModifiers().length == 0) {
            modifierList.setModifierProperty("def", true);
        }
    }

    @Nullable
    private static PsiElement findNewLineAfterElement(PsiElement element) {
        for (PsiElement sibling = element.getNextSibling(); sibling != null && PsiImplUtil.isWhiteSpaceOrNls(sibling); sibling = sibling.getNextSibling()) {
            if (!PsiUtil.isNewLine(sibling)) continue;
            return sibling;
        }
        return null;
    }

    @Nullable
    public static GrAnnotation getAnnotation(@NotNull GrAnnotationNameValuePair pair) {
        PsiElement pParent;
        if (pair == null) {
            PsiImplUtil.$$$reportNull$$$0(20);
        }
        if ((pParent = pair.getParent().getParent()) instanceof GrAnnotation) {
            return (GrAnnotation)pParent;
        }
        PsiElement ppParent = pParent.getParent();
        return ppParent instanceof GrAnnotation ? (GrAnnotation)ppParent : null;
    }

    @Nullable
    public static <T extends PsiElement> T findElementInRange(PsiFile file, int startOffset, int endOffset, Class<T> klass) {
        PsiElement element;
        PsiElement element1 = file.getViewProvider().findElementAt(startOffset, file.getLanguage());
        PsiElement element2 = file.getViewProvider().findElementAt(endOffset - 1, file.getLanguage());
        if (element1 == null || element2 == null) {
            return null;
        }
        if (PsiImplUtil.isWhiteSpaceOrNls(element1)) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.getViewProvider().findElementAt(startOffset, file.getLanguage());
        }
        if (PsiImplUtil.isWhiteSpaceOrNls(element2)) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.getViewProvider().findElementAt(endOffset - 1, file.getLanguage());
        }
        if (element2 == null || element1 == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        assert (commonParent != null);
        PsiElement psiElement = element = ReflectionUtil.isAssignable(klass, commonParent.getClass()) ? commonParent : PsiTreeUtil.getParentOfType((PsiElement)commonParent, klass);
        if (element == null) {
            return null;
        }
        if (!PsiImplUtil.checkRanges(element, startOffset, endOffset)) {
            return null;
        }
        return (T)element;
    }

    private static boolean checkRanges(@NotNull PsiElement element, int startOffset, int endOffset) {
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(21);
        }
        if (element instanceof GrLiteral && StringPartInfo.isWholeLiteralContentSelected((GrLiteral)element, startOffset, endOffset)) {
            return true;
        }
        return element.getTextRange().getStartOffset() == startOffset;
    }

    public static void appendTypeString(StringBuilder buffer, PsiType type2, PsiElement context) {
        if (type2 != null) {
            JavaDocInfoGenerator.generateType((StringBuilder)buffer, (PsiType)type2, (PsiElement)context);
        } else {
            buffer.append("def");
        }
    }

    public static boolean isSpreadAssignment(@Nullable GrExpression lValue) {
        if (lValue instanceof GrReferenceExpression) {
            GrReferenceExpression expression = (GrReferenceExpression)lValue;
            PsiElement dot = expression.getDotToken();
            if (dot != null && dot.getNode().getElementType() == GroovyTokenTypes.mSPREAD_DOT) {
                return true;
            }
            GrExpression qualifier = expression.getQualifierExpression();
            if (qualifier != null) {
                return PsiImplUtil.isSpreadAssignment(qualifier);
            }
        }
        return false;
    }

    public static void replaceExpression(@NotNull String newExpression, @NotNull GrExpression expression) throws IncorrectOperationException {
        if (newExpression == null) {
            PsiImplUtil.$$$reportNull$$$0(22);
        }
        if (expression == null) {
            PsiImplUtil.$$$reportNull$$$0(23);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
        GrExpression newCall = factory.createExpressionFromText(newExpression);
        expression.replaceWithExpression(newCall, true);
    }

    public static GrStatement replaceStatement(@NonNls @NotNull String newStatement, @NonNls @NotNull GrStatement statement) throws IncorrectOperationException {
        if (newStatement == null) {
            PsiImplUtil.$$$reportNull$$$0(24);
        }
        if (statement == null) {
            PsiImplUtil.$$$reportNull$$$0(25);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(statement.getProject());
        GrStatement newCall = (GrStatement)factory.createTopElementFromText(newStatement);
        return statement.replaceWithStatement(newCall);
    }

    public static boolean seemsToBeQualifiedClassName(@Nullable GrExpression expr) {
        if (expr == null) {
            return false;
        }
        while (expr instanceof GrReferenceExpression) {
            PsiElement nameElement = ((GrReferenceExpression)expr).getReferenceNameElement();
            if (((GrReferenceExpression)expr).getTypeArguments().length > 0) {
                return false;
            }
            if (nameElement == null || !TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS.contains(nameElement.getNode().getElementType())) {
                return false;
            }
            IElementType dotType = ((GrReferenceExpression)expr).getDotTokenType();
            if (dotType != null && dotType != GroovyTokenTypes.mDOT) {
                return false;
            }
            expr = ((GrReferenceExpression)expr).getQualifierExpression();
        }
        return expr == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static PsiType getQualifierType(@NotNull GrReferenceExpression ref) {
        GrExpression rtQualifier;
        if (ref == null) {
            PsiImplUtil.$$$reportNull$$$0(26);
        }
        if ((rtQualifier = ref.getQualifierExpression()) != null) {
            return rtQualifier.getType();
        }
        PsiClass containingClass = null;
        GrMember member = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)ref, GrMember.class);
        if (member == null) {
            PsiFile file = ref.getContainingFile();
            if (!(file instanceof GroovyFileBase) || !((GroovyFileBase)file).isScript()) return null;
            containingClass = ((GroovyFileBase)file).getScriptClass();
        } else if (member instanceof GrMethod && !member.hasModifierProperty("static")) {
            containingClass = member.getContainingClass();
        }
        if (containingClass == null) return null;
        PsiClassType categoryType = GdkMethodUtil.getCategoryType(containingClass);
        if (categoryType == null) return JavaPsiFacade.getElementFactory((Project)ref.getProject()).createType(containingClass);
        return categoryType;
    }

    @NotNull
    public static GroovyResolveResult reflectedToBase(GroovyResolveResult result2, GrMethod baseMethod, GrReflectedMethod reflectedMethod) {
        PsiSubstitutor substitutor = result2.getSubstitutor();
        PsiTypeParameter[] reflectedParameters = reflectedMethod.getTypeParameters();
        PsiTypeParameter[] baseParameters = baseMethod.getTypeParameters();
        assert (baseParameters.length == reflectedParameters.length);
        for (int i = 0; i < baseParameters.length; ++i) {
            substitutor = substitutor.put(baseParameters[i], result2.getSubstitutor().substitute(reflectedParameters[i]));
        }
        GroovyResolveResultImpl groovyResolveResultImpl = new GroovyResolveResultImpl(baseMethod, result2.getCurrentFileResolveContext(), result2.getSpreadState(), substitutor, result2.isAccessible(), result2.isStaticsOK(), result2.isInvokedOnProperty(), result2.isValidResult());
        if (groovyResolveResultImpl == null) {
            PsiImplUtil.$$$reportNull$$$0(27);
        }
        return groovyResolveResultImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/PsiImplUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 10: 
            case 11: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/PsiImplUtil";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractUniqueResult";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "reflectedToBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractUniqueElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractUniqueResult";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 27: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeNewLineAfter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteStatementTail";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 13: 
            case 14: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotation";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalizeWildcardTypeByPosition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasElementType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasArguments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findTailingSemicolon";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkRanges";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GroovyBufferVisitor
    extends AstBufferUtil.BufferVisitor {
        private final boolean mySkipWhiteSpace;

        public GroovyBufferVisitor(boolean skipWhitespace, boolean skipComments, int offset, @Nullable char[] buffer) {
            super(skipWhitespace, skipComments, offset, buffer);
            this.mySkipWhiteSpace = skipWhitespace;
        }

        protected boolean isIgnored(LeafElement element) {
            return super.isIgnored(element) || this.mySkipWhiteSpace && element.getElementType() == GroovyTokenTypes.mNLS;
        }
    }
}

