/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrListOrMapImpl
extends GrExpressionImpl
implements GrListOrMap,
PsiListLikeElement {
    private static final TokenSet MAP_LITERAL_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GroovyElementTypes.NAMED_ARGUMENT, GroovyTokenTypes.mCOLON});
    private final PsiReference myLiteralReference;
    private volatile GrExpression[] myInitializers;
    private volatile GrNamedArgument[] myNamedArguments;

    public GrListOrMapImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrListOrMapImpl.$$$reportNull$$$0(0);
        }
        super(node);
        this.myLiteralReference = new LiteralConstructorReference(this);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrListOrMapImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitListOrMap(this);
    }

    public String toString() {
        return "Generalized list";
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        if (this.getInitializers().length == 0) {
            return super.addInternal(first, last, this.getNode().getFirstChildNode(), Boolean.valueOf(false));
        }
        ASTNode lastChild = this.getNode().getLastChildNode();
        this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", lastChild);
        return super.addInternal(first, last, lastChild.getTreePrev(), Boolean.valueOf(false));
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement psi;
        if (child == null) {
            GrListOrMapImpl.$$$reportNull$$$0(2);
        }
        if ((psi = child.getPsi()) instanceof GrExpression || psi instanceof GrNamedArgument) {
            PsiElement prev = PsiUtil.getPrevNonSpace(psi);
            PsiElement next = PsiUtil.getNextNonSpace(psi);
            if (prev != null && prev.getNode() != null && prev.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                super.deleteChildInternal(prev.getNode());
            } else if (next instanceof LeafPsiElement && next.getNode() != null && next.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                super.deleteChildInternal(next.getNode());
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public boolean isMap() {
        return this.findChildByType(MAP_LITERAL_TOKEN_SET) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.getInitializers().length == 0 && this.getNamedArguments().length == 0;
    }

    @Override
    public PsiElement getLBrack() {
        return this.findChildByType(GroovyTokenTypes.mLBRACK);
    }

    @Override
    public PsiElement getRBrack() {
        return this.findChildByType(GroovyTokenTypes.mRBRACK);
    }

    @Override
    @NotNull
    public GrExpression[] getInitializers() {
        GrExpression[] initializers = this.myInitializers;
        if (initializers == null) {
            initializers = (GrExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, GrExpression.class);
            initializers = initializers == null ? GrExpression.EMPTY_ARRAY : initializers;
            this.myInitializers = initializers;
        }
        if (initializers == null) {
            GrListOrMapImpl.$$$reportNull$$$0(3);
        }
        return initializers;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        GrNamedArgument[] namedArguments = this.myNamedArguments;
        if (namedArguments == null) {
            namedArguments = (GrNamedArgument[])PsiTreeUtil.getChildrenOfType((PsiElement)this, GrNamedArgument.class);
            namedArguments = namedArguments == null ? GrNamedArgument.EMPTY_ARRAY : namedArguments;
            this.myNamedArguments = namedArguments;
        }
        if (namedArguments == null) {
            GrListOrMapImpl.$$$reportNull$$$0(4);
        }
        return namedArguments;
    }

    @Override
    public GrNamedArgument findNamedArgument(@NotNull String label) {
        if (label == null) {
            GrListOrMapImpl.$$$reportNull$$$0(5);
        }
        return PsiImplUtil.findNamedArgument(this, label);
    }

    public PsiReference getReference() {
        return this.myLiteralReference;
    }

    public void subtreeChanged() {
        this.myInitializers = null;
        this.myNamedArguments = null;
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        List list = PsiTreeUtil.getChildrenOfAnyType((PsiElement)this, (Class[])new Class[]{GrExpression.class, GrNamedArgument.class});
        if (list == null) {
            GrListOrMapImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedArguments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findNamedArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

