/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.toplevel.imports;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrImportAlias;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.PsiImportUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrImportStatementStub;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImport;

public class GrImportStatementImpl
extends GrStubElementBase<GrImportStatementStub>
implements GrImportStatement,
StubBasedPsiElement<GrImportStatementStub> {
    public GrImportStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrImportStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrImportStatementImpl(@NotNull GrImportStatementStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            GrImportStatementImpl.$$$reportNull$$$0(1);
        }
        if (nodeType == null) {
            GrImportStatementImpl.$$$reportNull$$$0(2);
        }
        super(stub, nodeType);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrImportStatementImpl.$$$reportNull$$$0(3);
        }
        visitor2.visitImportStatement(this);
    }

    public String toString() {
        return "Import statement";
    }

    @Nullable
    private PsiClass resolveQualifier() {
        return (PsiClass)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            GrCodeReferenceElement reference = this.getImportReference();
            GrCodeReferenceElement qualifier = reference == null ? null : (GrCodeReferenceElement)reference.getQualifier();
            PsiElement target = qualifier == null ? null : qualifier.resolve();
            PsiClass clazz = target instanceof PsiClass ? (PsiClass)target : null;
            return CachedValueProvider.Result.create((Object)clazz, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, this});
        });
    }

    @Override
    public GrCodeReferenceElement getImportReference() {
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    @Nullable
    public String getImportFqn() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getGreenStub();
        if (stub != null) {
            return stub.getFqn();
        }
        GrCodeReferenceElement reference = this.getImportReference();
        return reference == null ? null : reference.getQualifiedReferenceName();
    }

    @Override
    @Nullable
    public String getImportedName() {
        String aliasName;
        if (this.isOnDemand()) {
            return null;
        }
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            String name = stub.getAliasName();
            if (name != null) {
                return name;
            }
            String referenceText = stub.getFqn();
            return referenceText == null ? null : StringUtil.getShortName((String)referenceText);
        }
        GrImportAlias alias = this.getAlias();
        if (alias != null && (aliasName = alias.getName()) != null) {
            return aliasName;
        }
        GrCodeReferenceElement ref = this.getImportReference();
        return ref == null ? null : ref.getReferenceName();
    }

    @Override
    public boolean isStatic() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.isStatic();
        }
        return this.findChildByType(GroovyTokenTypes.kSTATIC) != null;
    }

    @Override
    public boolean isAliasedImport() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getAliasName() != null;
        }
        GrImportAlias alias = this.getAlias();
        return alias != null && alias.getName() != null;
    }

    @Override
    public boolean isOnDemand() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.isOnDemand();
        }
        return this.findChildByType(GroovyTokenTypes.mSTAR) != null;
    }

    @Override
    @NotNull
    public GrModifierList getAnnotationList() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            GrModifierList grModifierList = (GrModifierList)ObjectUtils.assertNotNull((Object)this.getStubOrPsiChild(GroovyStubElementTypes.MODIFIER_LIST));
            if (grModifierList == null) {
                GrImportStatementImpl.$$$reportNull$$$0(4);
            }
            return grModifierList;
        }
        GrModifierList grModifierList = (GrModifierList)this.findNotNullChildByClass(GrModifierList.class);
        if (grModifierList == null) {
            GrImportStatementImpl.$$$reportNull$$$0(5);
        }
        return grModifierList;
    }

    @Override
    @Nullable
    public PsiClass resolveTargetClass() {
        GrCodeReferenceElement ref = this.getImportReference();
        if (ref == null) {
            return null;
        }
        Object resolved = !this.isStatic() || this.isOnDemand() ? ref.resolve() : this.resolveQualifier();
        return resolved instanceof PsiClass ? (PsiClass)resolved : null;
    }

    @Override
    @Nullable
    public GrImportAlias getAlias() {
        return (GrImportAlias)this.findChildByClass(GrImportAlias.class);
    }

    @Override
    @Nullable
    public GroovyImport getImport() {
        return PsiImportUtil.createImportFromStatement(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

