/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.GroovyMapPropertyImpl;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\u000b\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\f\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"doProcessReceiverType", "", "Lcom/intellij/psi/PsiType;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "processClassType", "Lcom/intellij/psi/PsiClassType;", "processMapType", "processReceiverType", "intellij.groovy.psi"})
public final class ReceiverKt {
    public static final boolean processReceiverType(@Nullable PsiType $receiver, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        if ($receiver == null) {
            return true;
        }
        ResolveState resolveState = state.put(ClassHint.THIS_TYPE, (Object)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state.put(ClassHint.THIS_TYPE, this)");
        ResolveState newState = resolveState;
        if (!ReceiverKt.doProcessReceiverType($receiver, processor, newState, place)) {
            return false;
        }
        return !ResolveUtilKt.processNonCodeMembers(state) || ResolveUtil.processNonCodeMembers($receiver, processor, place, newState);
    }

    private static final boolean doProcessReceiverType(@NotNull PsiType $receiver, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        boolean bl;
        block21: {
            PsiType psiType = $receiver;
            if (psiType instanceof PsiPrimitiveType) {
                PsiClassType psiClassType = ((PsiPrimitiveType)$receiver).getBoxedType(place);
                bl = psiClassType != null ? ReceiverKt.processReceiverType((PsiType)psiClassType, processor, state, place) : true;
            } else if (psiType instanceof PsiDisjunctionType) {
                bl = ReceiverKt.processReceiverType(((PsiDisjunctionType)$receiver).getLeastUpperBound(), processor, state, place);
            } else if (psiType instanceof PsiIntersectionType) {
                PsiType[] $receiver$iv;
                PsiType[] psiTypeArray = ((PsiIntersectionType)$receiver).getConjuncts();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"conjuncts");
                PsiType[] psiTypeArray2 = $receiver$iv = psiTypeArray;
                int n = psiTypeArray2.length;
                for (int i = 0; i < n; ++i) {
                    PsiType element$iv;
                    PsiType it = element$iv = psiTypeArray2[i];
                    boolean bl2 = false;
                    if (ReceiverKt.processReceiverType(it, processor, state, place)) continue;
                    bl = false;
                    break block21;
                }
                bl = true;
            } else if (psiType instanceof PsiCapturedWildcardType) {
                bl = ReceiverKt.processReceiverType((PsiType)((PsiCapturedWildcardType)$receiver).getWildcard(), processor, state, place);
            } else if (psiType instanceof PsiWildcardType) {
                bl = !((PsiWildcardType)$receiver).isExtends() || ReceiverKt.processReceiverType(((PsiWildcardType)$receiver).getExtendsBound(), processor, state, place);
            } else if (psiType instanceof GrTraitType) {
                Object[] objectArray = ((GrTraitType)$receiver).getConjuncts();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"conjuncts");
                Iterable $receiver$iv = ArraysKt.reversed((Object[])objectArray);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        PsiType it = (PsiType)element$iv;
                        boolean bl3 = false;
                        if (ReceiverKt.processReceiverType(it, processor, state, place)) continue;
                        bl = false;
                        break block21;
                    }
                    bl = true;
                }
            } else if (psiType instanceof PsiArrayType) {
                GrTypeDefinition grTypeDefinition = GroovyPsiManager.getInstance(place.getProject()).getArrayClass(((PsiArrayType)$receiver).getComponentType());
                if (grTypeDefinition == null) {
                    return true;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)grTypeDefinition, (String)"GroovyPsiManager.getInst\u2026onentType) ?: return true");
                GrTypeDefinition arrayClass = grTypeDefinition;
                bl = ResolveUtil.processClassDeclarations(arrayClass, processor, state, null, place);
            } else if (psiType instanceof PsiClassType) {
                bl = ReceiverKt.processClassType((PsiClassType)$receiver, processor, state, place);
            } else {
                return true;
            }
        }
        return bl;
    }

    private static final boolean processClassType(@NotNull PsiClassType $receiver, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        PsiClassType.ClassResolveResult classResolveResult = $receiver.resolveGenerics();
        Intrinsics.checkExpressionValueIsNotNull((Object)classResolveResult, (String)"resolveGenerics()");
        PsiClassType.ClassResolveResult result2 = classResolveResult;
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return true;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"result.element ?: return true");
        PsiClass clazz = psiClass;
        ResolveState resolveState = state.put(PsiSubstitutor.KEY, (Object)((PsiSubstitutor)state.get(PsiSubstitutor.KEY)).putAll(result2.getSubstitutor()));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state.put(PsiSubstitutor\u2026tAll(result.substitutor))");
        ResolveState newState = resolveState;
        if (Intrinsics.areEqual((Object)((Boolean)state.get(ClassHint.STATIC_CONTEXT)), (Object)true) ^ true && Intrinsics.areEqual((Object)clazz.getQualifiedName(), (Object)"java.lang.Class")) {
            Object[] objectArray = $receiver.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"parameters");
            Object object = ArraysKt.singleOrNull((Object[])objectArray);
            if (!(object instanceof PsiClassType)) {
                object = null;
            }
            PsiClassType type2 = (PsiClassType)object;
            PsiType psiType = (PsiType)type2;
            ResolveState resolveState2 = newState.put(ClassHint.STATIC_CONTEXT, (Object)true);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveState2, (String)"newState.put(STATIC_CONTEXT, true)");
            if (!ReceiverKt.processReceiverType(psiType, processor, resolveState2, place)) {
                return false;
            }
        }
        if (!ReceiverKt.processMapType($receiver, processor, newState, place)) {
            return false;
        }
        return ResolveUtil.processClassDeclarations(clazz, processor, newState.put(ClassHint.THIS_TYPE, (Object)$receiver), null, place);
    }

    private static final boolean processMapType(@NotNull PsiClassType $receiver, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        GroovyMapPropertyImpl property;
        if (Intrinsics.areEqual((Object)((Boolean)state.get(ClassHint.STATIC_CONTEXT)), (Object)true)) {
            return true;
        }
        if (!ResolveUtilKt.shouldProcessProperties(processor)) {
            return true;
        }
        if (!($receiver instanceof GrMapType) && !InheritanceUtil.isInheritor((PsiType)((PsiType)$receiver), (String)"java.util.Map")) {
            return true;
        }
        String name = ResolveUtilKt.getName(processor, state);
        if (name != null && !processor.execute((PsiElement)(property = new GroovyMapPropertyImpl($receiver, name, place)), state)) {
            return false;
        }
        return ResolveUtilKt.shouldProcessMethods(processor);
    }
}

