/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.AccessorResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GenericAccessorResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ProcessorWithCommonHints;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\tj\u0004\u0018\u0001`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\tj\u0004\u0018\u0001`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/AccessorProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/ProcessorWithCommonHints;", "Lorg/jetbrains/plugins/groovy/lang/resolve/GrResolverProcessor;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "propertyName", "", "propertyKind", "Lcom/intellij/lang/java/beans/PropertyKind;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "place", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/lang/java/beans/PropertyKind;Ljava/util/List;Lcom/intellij/psi/PsiElement;)V", "accessorName", "myResults", "Lcom/intellij/util/SmartList;", "results", "getResults", "()Ljava/util/List;", "execute", "", "element", "state", "Lcom/intellij/psi/ResolveState;", "intellij.groovy.psi"})
public final class AccessorProcessor
extends ProcessorWithCommonHints
implements GrResolverProcessor<GroovyResolveResult> {
    private final String accessorName;
    private final SmartList<GroovyResolveResult> myResults;
    private final PropertyKind propertyKind;
    private final List<Argument> arguments;
    private final PsiElement place;

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!(element instanceof PsiMethod)) {
            return true;
        }
        String string = (String)state.get(GroovyImports.getImportedNameKey());
        if (string == null) {
            String string2 = ((PsiMethod)element).getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.name");
        }
        String elementName = string;
        if (Intrinsics.areEqual((Object)elementName, (Object)this.accessorName) ^ true) {
            return true;
        }
        if (!PropertyUtilKt.checkKind((PsiMethod)element, this.propertyKind)) {
            return true;
        }
        Collection collection = (Collection)this.myResults;
        AccessorResolveResult accessorResolveResult = ((PsiMethod)element).hasTypeParameters() ? (AccessorResolveResult)new GenericAccessorResolveResult((PsiMethod)element, this.place, state, this.arguments) : new AccessorResolveResult((PsiMethod)element, this.place, state, this.arguments);
        collection.add(accessorResolveResult);
        return true;
    }

    @Override
    @NotNull
    public List<GroovyResolveResult> getResults() {
        return (List)this.myResults;
    }

    public AccessorProcessor(@NotNull String propertyName, @NotNull PropertyKind propertyKind, @Nullable List<? extends Argument> arguments2, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        Intrinsics.checkParameterIsNotNull((Object)propertyKind, (String)"propertyKind");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        this.propertyKind = propertyKind;
        this.arguments = arguments2;
        this.place = place;
        this.accessorName = PropertyUtilKt.getAccessorName(this.propertyKind, propertyName);
        this.nameHint(this.accessorName);
        this.elementClassHint(ElementClassHint.DeclarationKind.METHOD);
        this.hint(GroovyResolveKind.HINT_KEY, GroovyResolveKind.EMPTY_HINT);
        this.myResults = new SmartList();
    }
}

