/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.JustTypeArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.UnknownArgument;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilder;
import org.jetbrains.plugins.groovy.lang.typing.DefaultMethodCallTypeCalculatorKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a/\u0010\u0012\u001a\u00020\f*\u00020\f2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0014\u00a2\u0006\u0002\u0010\u0017\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u000f\u001a\n\u0010\u001a\u001a\u00020\u0019*\u00020\u000f\u00a8\u0006\u001b"}, d2={"buildQualifier", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "ref", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "state", "Lcom/intellij/psi/ResolveState;", "getTopLevelType", "Lcom/intellij/psi/PsiType;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "getTopLevelTypeCached", "inferDerivedSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "leftType", "derived", "Lcom/intellij/psi/PsiClass;", "context", "Lcom/intellij/psi/PsiElement;", "putAll", "parameters", "", "Lcom/intellij/psi/PsiTypeParameter;", "arguments", "(Lcom/intellij/psi/PsiSubstitutor;[Lcom/intellij/psi/PsiTypeParameter;[Lcom/intellij/psi/PsiType;)Lcom/intellij/psi/PsiSubstitutor;", "rawType", "Lcom/intellij/psi/PsiClassType;", "type", "intellij.groovy.psi"})
public final class InferenceKt {
    @Nullable
    public static final PsiType getTopLevelType(@NotNull GrExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (expression instanceof GrMethodCall) {
            GroovyMethodResult resolved;
            Object object;
            GroovyResolveResult groovyResolveResult = ((GrMethodCall)expression).advancedResolve();
            if (!(groovyResolveResult instanceof GroovyMethodResult)) {
                groovyResolveResult = null;
            }
            if ((object = (resolved = (GroovyMethodResult)groovyResolveResult)) != null && (object = object.getCandidate()) != null) {
                Object object2;
                Object it = object2 = object;
                boolean bl = false;
                PsiElement psiElement = expression;
                Object object3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                PsiSubstitutor psiSubstitutor = resolved.getContextSubstitutor();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"resolved.contextSubstitutor");
                GroovyInferenceSession session = new GroovyInferenceSessionBuilder(psiElement, (GroovyMethodCandidate)object3, psiSubstitutor).resolveMode(false).build();
                return session.inferSubst().substitute(DefaultMethodCallTypeCalculatorKt.devoid(PsiUtil.getSmartReturnType(it.getMethod()), expression));
            }
            return null;
        }
        if (expression instanceof GrFunctionalExpression) {
            return (PsiType)TypesUtil.createTypeByFQClassName("groovy.lang.Closure", expression);
        }
        return expression.getType();
    }

    @Nullable
    public static final PsiType getTopLevelTypeCached(@NotNull GrExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        return GroovyPsiManager.getInstance(expression.getProject()).getTopLevelType(expression);
    }

    @NotNull
    public static final Argument buildQualifier(@Nullable GrReferenceExpression ref, @NotNull ResolveState state) {
        PsiType type2;
        PsiType psiType;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        GrReferenceExpression grReferenceExpression = ref;
        GrExpression qualifierExpression = grReferenceExpression != null ? grReferenceExpression.getQualifierExpression() : null;
        SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
        if (qualifierExpression != null && spreadState == null) {
            return new ExpressionArgument(qualifierExpression);
        }
        PsiType resolvedThis = (PsiType)state.get(ClassHint.THIS_TYPE);
        if (resolvedThis != null) {
            return new JustTypeArgument(resolvedThis);
        }
        GrReferenceExpression grReferenceExpression2 = ref;
        if (grReferenceExpression2 != null) {
            GrReferenceExpression grReferenceExpression3;
            GrReferenceExpression p1 = grReferenceExpression3 = grReferenceExpression2;
            boolean bl = false;
            psiType = PsiImplUtil.getQualifierType(p1);
        } else {
            psiType = type2 = null;
        }
        if (spreadState == null) {
            return new JustTypeArgument(type2);
        }
        if (type2 == null) {
            return UnknownArgument.INSTANCE;
        }
        return new JustTypeArgument(com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)false));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiSubstitutor putAll(@NotNull PsiSubstitutor $receiver, @NotNull PsiTypeParameter[] parameters, @NotNull PsiType[] arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        if (arguments2.length != parameters.length) {
            return $receiver;
        }
        Iterable $receiver$iv = ArraysKt.zip((Object[])parameters, (Object[])arguments2);
        PsiSubstitutor accumulator$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            void $param_arg;
            Pair pair = (Pair)element$iv;
            PsiSubstitutor acc = accumulator$iv;
            boolean bl = false;
            PsiTypeParameter param = (PsiTypeParameter)$param_arg.component1();
            PsiType arg = (PsiType)$param_arg.component2();
            Intrinsics.checkExpressionValueIsNotNull((Object)acc.put(param, arg), (String)"acc.put(param, arg)");
        }
        return accumulator$iv;
    }

    @NotNull
    public static final PsiClassType type(@NotNull PsiClass $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiClassType psiClassType = PsiElementFactory.SERVICE.getInstance((Project)$receiver.getProject()).createType($receiver, PsiSubstitutor.EMPTY);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"PsiElementFactory.SERVIC\u2026is, PsiSubstitutor.EMPTY)");
        return psiClassType;
    }

    @NotNull
    public static final PsiClassType rawType(@NotNull PsiClass $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)$receiver.getProject());
        PsiClassType psiClassType = factory.createType($receiver, factory.createRawSubstitutor((PsiTypeParameterListOwner)$receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"factory.createType(this,\u2026eateRawSubstitutor(this))");
        return psiClassType;
    }

    @NotNull
    public static final PsiSubstitutor inferDerivedSubstitutor(@NotNull PsiType leftType, @NotNull PsiClass derived, @NotNull PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)leftType, (String)"leftType");
        Intrinsics.checkParameterIsNotNull((Object)derived, (String)"derived");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        InferenceSession session = new InferenceSession(derived.getTypeParameters(), PsiSubstitutor.EMPTY, context.getManager(), null);
        session.addConstraint((ConstraintFormula)new TypeCompatibilityConstraint(leftType, session.substituteWithInferenceVariables((PsiType)InferenceKt.type(derived))));
        PsiSubstitutor psiSubstitutor = session.infer();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"session.infer()");
        return psiSubstitutor;
    }
}

