/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/ListLiteralType;", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType;", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;)V", "doGetComponentTypes", "", "Lcom/intellij/psi/PsiType;", "initializer", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "inferComponents", "", "isValid", "", "toString", "", "intellij.groovy.psi"})
public class ListLiteralType
extends GrTupleType {
    private final GrListOrMap literal;

    public boolean isValid() {
        return this.literal.isValid();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<PsiType> inferComponents() {
        void var3_3;
        void $receiver$iv$iv;
        GrExpression[] $receiver$iv;
        GrExpression[] grExpressionArray = this.literal.getInitializers();
        Intrinsics.checkExpressionValueIsNotNull((Object)grExpressionArray, (String)"literal.initializers");
        GrExpression[] grExpressionArray2 = $receiver$iv = grExpressionArray;
        Collection destination$iv$iv = new ArrayList();
        void var4_4 = $receiver$iv$iv;
        int n = ((void)var4_4).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var4_4[i];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Collection<PsiType> collection = this.doGetComponentTypes((GrExpression)v1);
            if (collection == null) {
                return CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_3;
    }

    private final Collection<PsiType> doGetComponentTypes(GrExpression initializer) {
        return (Collection)RecursionManager.doPreventingRecursion((Object)initializer, (boolean)false, (Computable)new Computable<T>(initializer){
            final /* synthetic */ GrExpression $initializer;

            @Nullable
            public final List<PsiType> compute() {
                List<E> list;
                if (this.$initializer instanceof GrSpreadArgument) {
                    GrExpression grExpression = ((GrSpreadArgument)this.$initializer).getArgument();
                    Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"initializer.argument");
                    PsiType psiType = grExpression.getType();
                    if (!(psiType instanceof GrTupleType)) {
                        psiType = null;
                    }
                    GrTupleType grTupleType = (GrTupleType)psiType;
                    list = grTupleType != null ? grTupleType.getComponentTypes() : null;
                } else {
                    PsiType psiType = TypesUtil.boxPrimitiveType(this.$initializer.getType(), this.$initializer.getManager(), this.$initializer.getResolveScope());
                    if (psiType != null) {
                        PsiType psiType2;
                        PsiType it = psiType2 = psiType;
                        boolean bl = false;
                        list = CollectionsKt.listOf((Object)it);
                    } else {
                        list = null;
                    }
                }
                return list;
            }
            {
                this.$initializer = grExpression;
            }
        });
    }

    @NotNull
    public String toString() {
        String string = this.literal.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"literal.text");
        return string;
    }

    public ListLiteralType(@NotNull GrListOrMap literal) {
        Intrinsics.checkParameterIsNotNull((Object)literal, (String)"literal");
        super(literal);
        this.literal = literal;
    }
}

