/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extract.ParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public abstract class ExtractInfoHelperBase
implements ExtractInfoHelper {
    protected final ExtractInfoHelper myInitialInfo;
    protected final Map<String, ParameterInfo> myInputNamesMap;

    public ExtractInfoHelperBase(ExtractInfoHelper initialInfo) {
        this.myInitialInfo = initialInfo;
        ParameterInfo[] infos = initialInfo.getParameterInfos();
        this.myInputNamesMap = new HashMap<String, ParameterInfo>(infos.length);
        for (ParameterInfo info : infos) {
            this.myInputNamesMap.put(info.getName(), info);
        }
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myInitialInfo.getProject();
        if (project == null) {
            ExtractInfoHelperBase.$$$reportNull$$$0(0);
        }
        return project;
    }

    @Override
    @NotNull
    public ParameterInfo[] getParameterInfos() {
        Collection<ParameterInfo> collection = this.myInputNamesMap.values();
        ParameterInfo[] infos = new ParameterInfo[collection.size()];
        for (ParameterInfo info : collection) {
            int position = info.getPosition();
            assert (position < infos.length && infos[position] == null);
            infos[position] = info;
        }
        if (infos == null) {
            ExtractInfoHelperBase.$$$reportNull$$$0(1);
        }
        return infos;
    }

    @Override
    @NotNull
    public VariableInfo[] getOutputVariableInfos() {
        VariableInfo[] variableInfoArray = this.myInitialInfo.getOutputVariableInfos();
        if (variableInfoArray == null) {
            ExtractInfoHelperBase.$$$reportNull$$$0(2);
        }
        return variableInfoArray;
    }

    @Override
    @NotNull
    public String[] getArgumentNames() {
        Collection<ParameterInfo> infos = this.myInputNamesMap.values();
        String[] argNames = new String[infos.size()];
        for (ParameterInfo info : infos) {
            int position = info.getPosition();
            assert (position < argNames.length);
            argNames[position] = info.passAsParameter ? info.getOriginalName() : "";
        }
        if (argNames == null) {
            ExtractInfoHelperBase.$$$reportNull$$$0(3);
        }
        return argNames;
    }

    @Override
    @NotNull
    public PsiType getOutputType() {
        PsiType psiType = this.myInitialInfo.getOutputType();
        if (psiType == null) {
            ExtractInfoHelperBase.$$$reportNull$$$0(4);
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiElement[] getInnerElements() {
        PsiElement[] psiElementArray = this.myInitialInfo.getInnerElements();
        if (psiElementArray == null) {
            ExtractInfoHelperBase.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public GrStatement[] getStatements() {
        GrStatement[] grStatementArray = this.myInitialInfo.getStatements();
        if (grStatementArray == null) {
            ExtractInfoHelperBase.$$$reportNull$$$0(6);
        }
        return grStatementArray;
    }

    @Override
    @Nullable
    public StringPartInfo getStringPartInfo() {
        return this.myInitialInfo.getStringPartInfo();
    }

    @Override
    @Nullable
    public GrVariable getVar() {
        return this.myInitialInfo.getVar();
    }

    @Override
    public boolean hasReturnValue() {
        return this.myInitialInfo.hasReturnValue();
    }

    @Override
    public PsiElement getContext() {
        return this.myInitialInfo.getContext();
    }

    @Override
    public boolean isForceReturn() {
        return this.myInitialInfo.isForceReturn();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/refactoring/extract/ExtractInfoHelperBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterInfos";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariableInfos";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

