/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameJavaVariableProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameAliasedUsagesUtil;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameGrFieldProcessor;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameHelperKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J7\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016\u00a2\u0006\u0002\u0010#\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/groovy/refactoring/rename/RenameGrFieldProcessor;", "Lcom/intellij/refactoring/rename/RenameJavaVariableProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findCollisions", "", "newName", "", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "findExistingNameConflicts", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "handleElementRename", "ref", "fieldName", "qualify", "member", "Lcom/intellij/psi/PsiMember;", "refExpr", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "intellij.groovy"})
public class RenameGrFieldProcessor
extends RenameJavaVariableProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return element instanceof GrField;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        GrAccessorMethod[] getters;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        boolean bl = element instanceof GrField;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        GrField field = (GrField)element;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)element.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.projec\u2026ope(element.getProject())");
        GlobalSearchScope projectScope = globalSearchScope;
        GrAccessorMethod setter = field.getSetter();
        if (setter != null) {
            refs.addAll(RenameAliasedUsagesUtil.filterAliasedRefs(MethodReferencesSearch.search((PsiMethod)setter, (SearchScope)((SearchScope)projectScope), (boolean)true).findAll(), (PsiElement)setter));
        }
        GrAccessorMethod[] grAccessorMethodArray = field.getGetters();
        Intrinsics.checkExpressionValueIsNotNull((Object)grAccessorMethodArray, (String)"field.getters");
        for (GrAccessorMethod getter : getters = grAccessorMethodArray) {
            refs.addAll(RenameAliasedUsagesUtil.filterAliasedRefs(MethodReferencesSearch.search((PsiMethod)getter, (SearchScope)((SearchScope)projectScope), (boolean)true).findAll(), (PsiElement)getter));
        }
        refs.addAll(RenameAliasedUsagesUtil.filterAliasedRefs(ReferencesSearch.search((PsiElement)field, (SearchScope)((SearchScope)projectScope), (boolean)false).findAll(), field));
        return refs;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener) {
        block10: {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
            Intrinsics.checkParameterIsNotNull((Object)usages, (String)"usages");
            HashMap oldResolvedRefs = new HashMap();
            for (UsageInfo usage : usages) {
                PsiElement psiElement;
                GrReferenceExpression ref;
                PsiReference psiReference = usage.getReference();
                if (!(psiReference instanceof GrReferenceExpression)) {
                    psiReference = null;
                }
                if ((GrReferenceExpression)psiReference == null) {
                    continue;
                }
                PsiElement resovled = ref.resolve();
                Map map2 = oldResolvedRefs;
                if (resovled == null) {
                    continue;
                }
                map2.put(ref, psiElement);
            }
            GrField field = (GrField)element;
            for (UsageInfo usage : usages) {
                PsiReference ref = usage.getReference();
                if (ref instanceof GrReferenceExpression) {
                    PsiElement resolved = (PsiElement)oldResolvedRefs.get(ref);
                    ref.handleElementRename(RenameHelperKt.getNewNameFromTransformations(resolved, newName));
                    continue;
                }
                if (ref == null) continue;
                String string = field.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"field.name");
                this.handleElementRename(newName, ref, string);
            }
            field.setName(newName);
            PsiManager manager = element.getManager();
            for (GrReferenceExpression expression : oldResolvedRefs.keySet()) {
                PsiElement resolved;
                PsiElement oldResolved;
                if ((PsiElement)oldResolvedRefs.get(expression) == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)oldResolved, (String)"oldResolvedRefs[expression] ?: continue");
                if (expression.resolve() == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)resolved, (String)"expression.resolve() ?: continue");
                if (manager.areElementsEquivalent(oldResolved, resolved)) continue;
                if (!Intrinsics.areEqual((Object)oldResolved, (Object)field)) {
                    PsiManager psiManager = manager;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"manager");
                    if (!RenameHelperKt.isQualificationNeeded(psiManager, oldResolved, resolved)) continue;
                }
                PsiMember psiMember = field;
                GrReferenceExpression grReferenceExpression = expression;
                Intrinsics.checkExpressionValueIsNotNull((Object)grReferenceExpression, (String)"expression");
                this.qualify(psiMember, grReferenceExpression);
            }
            RefactoringElementListener refactoringElementListener = listener;
            if (refactoringElementListener == null) break block10;
            refactoringElementListener.elementRenamed(element);
        }
    }

    private final void handleElementRename(String newName, PsiReference ref, String fieldName) {
        String string;
        String refText;
        String string2 = refText = ref instanceof PsiQualifiedReference ? ((PsiQualifiedReference)ref).getReferenceName() : ref.getCanonicalText();
        if (Intrinsics.areEqual((Object)fieldName, (Object)refText)) {
            string = newName;
        } else if (Intrinsics.areEqual((Object)GroovyPropertyUtils.getGetterNameNonBoolean(fieldName), (Object)refText)) {
            String string3 = GroovyPropertyUtils.getGetterNameNonBoolean(newName);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"GroovyPropertyUtils.getG\u2026erNameNonBoolean(newName)");
        } else if (Intrinsics.areEqual((Object)GroovyPropertyUtils.getGetterNameBoolean(fieldName), (Object)refText)) {
            String string4 = GroovyPropertyUtils.getGetterNameBoolean(newName);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"GroovyPropertyUtils.getGetterNameBoolean(newName)");
        } else if (Intrinsics.areEqual((Object)GroovyPropertyUtils.getSetterName(fieldName), (Object)refText)) {
            String string5 = GroovyPropertyUtils.getSetterName(newName);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"GroovyPropertyUtils.getSetterName(newName)");
        } else {
            string = newName;
        }
        String toRename = string;
        ref.handleElementRename(toRename);
    }

    /*
     * WARNING - void declaration
     */
    private final void qualify(PsiMember member, GrReferenceExpression refExpr) {
        String string;
        PsiManager manager;
        String string2 = refExpr.getReferenceName();
        if (string2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"refExpr.referenceName ?: return");
        String referenceName = string2;
        PsiClass psiClass = member.getContainingClass();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"member.containingClass ?: return");
        PsiClass clazz = psiClass;
        if (refExpr.getQualifierExpression() != null) {
            return;
        }
        PsiManager psiManager = manager = member.getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"manager");
        Project project = psiManager.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"manager.project");
        Project project2 = project;
        if (member.hasModifierProperty("static")) {
            string = clazz.getQualifiedName() + '.' + referenceName;
        } else {
            void $receiver$iv;
            PsiElement psiElement = refExpr;
            PsiManager psiManager2 = manager;
            boolean $i$f$parentOfType = false;
            PsiElement psiElement2 = PsiTreeUtilKt.parentOfType((PsiElement)$receiver$iv, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(PsiClass.class)});
            string = psiManager2.areElementsEquivalent(psiElement2, (PsiElement)clazz) ? "this." + referenceName : clazz.getQualifiedName() + ".this." + referenceName;
        }
        String newText = string;
        GrReferenceExpression grReferenceExpression = GroovyPsiElementFactory.getInstance(project2).createReferenceExpressionFromText(newText);
        Intrinsics.checkExpressionValueIsNotNull((Object)grReferenceExpression, (String)"GroovyPsiElementFactory.\u2026pressionFromText(newText)");
        GrReferenceExpression newRefExpr = grReferenceExpression;
        PsiElement replaced = refExpr.replace(newRefExpr);
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(replaced);
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        ArrayList<findCollisions.1> collisions = new ArrayList<findCollisions.1>();
        for (UsageInfo info : result2) {
            PsiMethod resolved;
            PsiType[] typeArguments;
            GrReferenceExpression refExpr;
            if (!(info instanceof MoveRenameUsageInfo)) continue;
            PsiElement psiElement = info.getElement();
            if (!(psiElement instanceof GrReferenceExpression)) {
                psiElement = null;
            }
            if ((GrReferenceExpression)psiElement == null) {
                continue;
            }
            if (!(refExpr.getParent() instanceof GrCall)) continue;
            PsiElement referencedElement = ((MoveRenameUsageInfo)info).getReferencedElement();
            if (!(referencedElement instanceof GrField)) {
                GroovyResolveResult groovyResolveResult = refExpr.advancedResolve();
                Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"refExpr.advancedResolve()");
                if (!groovyResolveResult.isInvokedOnProperty()) continue;
            }
            PsiType[] argTypes = PsiUtil.getArgumentTypes(refExpr, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)refExpr.getTypeArguments(), (String)"refExpr.typeArguments");
            MethodResolverProcessor processor = new MethodResolverProcessor(newName, refExpr, false, null, argTypes, typeArguments);
            if ((PsiMethod)ResolveUtil.resolveExistingElement(refExpr, processor, PsiMethod.class) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)resolved, (String)"ResolveUtil.resolveExist\u2026::class.java) ?: continue");
            collisions.add(new UnresolvableCollisionUsageInfo(refExpr, resolved, (PsiElement)resolved, refExpr){
                final /* synthetic */ GrReferenceExpression $refExpr;
                final /* synthetic */ PsiMethod $resolved;

                @NotNull
                public String getDescription() {
                    Object[] objectArray = new Object[2];
                    PsiElement psiElement = this.$refExpr.getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"refExpr.parent");
                    objectArray[0] = psiElement.getText();
                    objectArray[1] = PsiFormatUtil.formatMethod((PsiMethod)this.$resolved, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)2);
                    String string = GroovyRefactoringBundle.message("usage.will.be.overriden.by.method", objectArray);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message(\n          \"usag\u2026Base.SHOW_TYPE)\n        )");
                    return string;
                }
                {
                    this.$refExpr = $captured_local_variable$0;
                    this.$resolved = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3);
                }
            });
        }
        result2.addAll((Collection<UsageInfo>)collisions);
        super.findCollisions(element, newName, allRenames, result2);
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiMethod newSetter;
        PsiMethod setter;
        PsiMethod newGetter;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        Intrinsics.checkParameterIsNotNull(conflicts, (String)"conflicts");
        super.findExistingNameConflicts(element, newName, conflicts);
        GrField field = (GrField)element;
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"field.containingClass ?: return");
        PsiClass containingClass = psiClass;
        PsiMethod getter = GroovyPropertyUtils.findGetterForField(field);
        if (getter instanceof GrAccessorMethod && (newGetter = PropertyUtilBase.findPropertyGetter((PsiClass)containingClass, (String)newName, (boolean)field.hasModifierProperty("static"), (boolean)true)) != null && !(newGetter instanceof GrAccessorMethod)) {
            conflicts.putValue((Object)newGetter, (Object)GroovyRefactoringBundle.message("implicit.getter.will.by.overriden.by.method", field.getName(), newGetter.getName()));
        }
        if ((setter = GroovyPropertyUtils.findSetterForField(field)) instanceof GrAccessorMethod && (newSetter = PropertyUtilBase.findPropertySetter((PsiClass)containingClass, (String)newName, (boolean)field.hasModifierProperty("static"), (boolean)true)) != null && !(newSetter instanceof GrAccessorMethod)) {
            conflicts.putValue((Object)newSetter, (Object)GroovyRefactoringBundle.message("implicit.setter.will.by.overriden.by.method", field.getName(), newSetter.getName()));
        }
    }
}

