/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.DateFormatUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.status.StatusType;

public class CommandUtil {
    private static final Logger LOG = Logger.getInstance(CommandUtil.class);

    public static void put(@NotNull List<? super String> parameters, boolean condition, @NotNull String value) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(0);
        }
        if (value == null) {
            CommandUtil.$$$reportNull$$$0(1);
        }
        if (condition) {
            parameters.add(value);
        }
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull File path) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(2);
        }
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(3);
        }
        CommandUtil.put(parameters, path.getAbsolutePath(), Revision.UNDEFINED);
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull File path, boolean usePegRevision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(4);
        }
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(5);
        }
        if (usePegRevision) {
            CommandUtil.put(parameters, path);
        } else {
            parameters.add(path.getAbsolutePath());
        }
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull File path, @Nullable Revision pegRevision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(6);
        }
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(7);
        }
        CommandUtil.put(parameters, path.getAbsolutePath(), pegRevision);
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull String path, @Nullable Revision pegRevision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(8);
        }
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(9);
        }
        parameters.add(CommandUtil.format(path, pegRevision));
    }

    @NotNull
    public static String format(@NotNull String path, @Nullable Revision pegRevision) {
        boolean hasPegRevision;
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(10);
        }
        StringBuilder builder = new StringBuilder(path);
        boolean hasAtSymbol = path.contains("@");
        boolean bl = hasPegRevision = pegRevision != null && !Revision.UNDEFINED.equals(pegRevision) && !Revision.WORKING.equals(pegRevision) && pegRevision.isValid();
        if (hasPegRevision || hasAtSymbol) {
            builder.append("@");
        }
        if (hasPegRevision) {
            builder.append(CommandUtil.format(pegRevision));
        }
        String string = builder.toString();
        if (string == null) {
            CommandUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull Target target) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(12);
        }
        if (target == null) {
            CommandUtil.$$$reportNull$$$0(13);
        }
        CommandUtil.put(parameters, target.getPath(), target.getPegRevision());
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull Target target, boolean usePegRevision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(14);
        }
        if (target == null) {
            CommandUtil.$$$reportNull$$$0(15);
        }
        if (usePegRevision) {
            CommandUtil.put(parameters, target);
        } else {
            parameters.add(target.getPath());
        }
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable Depth depth) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(16);
        }
        CommandUtil.put(parameters, depth, false);
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable Depth depth, boolean sticky) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(17);
        }
        if (depth != null && !Depth.UNKNOWN.equals((Object)depth)) {
            parameters.add("--depth");
            parameters.add(depth.getName());
            if (sticky) {
                parameters.add("--set-depth");
                parameters.add(depth.getName());
            }
        }
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable Revision revision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(18);
        }
        if (revision != null && !Revision.UNDEFINED.equals(revision) && !Revision.WORKING.equals(revision) && revision.isValid()) {
            parameters.add("--revision");
            parameters.add(CommandUtil.format(revision));
        }
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull Revision startRevision, @NotNull Revision endRevision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(19);
        }
        if (startRevision == null) {
            CommandUtil.$$$reportNull$$$0(20);
        }
        if (endRevision == null) {
            CommandUtil.$$$reportNull$$$0(21);
        }
        parameters.add("--revision");
        parameters.add(CommandUtil.format(startRevision) + ":" + CommandUtil.format(endRevision));
    }

    @NotNull
    public static String format(@NotNull Revision revision) {
        if (revision == null) {
            CommandUtil.$$$reportNull$$$0(22);
        }
        String string = revision.getDate() != null ? "{" + DateFormatUtil.getIso8601Format().format(revision.getDate()) + "}" : revision.toString();
        if (string == null) {
            CommandUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable DiffOptions diffOptions) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(24);
        }
        if (diffOptions != null) {
            String value;
            StringBuilder builder = new StringBuilder();
            if (diffOptions.isIgnoreAllWhitespace()) {
                builder.append(" --ignore-space-change");
            }
            if (diffOptions.isIgnoreAmountOfWhitespace()) {
                builder.append(" --ignore-all-space");
            }
            if (diffOptions.isIgnoreEOLStyle()) {
                builder.append(" --ignore-eol-style");
            }
            if (!StringUtil.isEmpty((String)(value = builder.toString().trim()))) {
                parameters.add("--extensions");
                parameters.add(value);
            }
        }
    }

    public static void putChangeLists(@NotNull List<? super String> parameters, @Nullable Iterable<String> changeLists) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(25);
        }
        if (changeLists != null) {
            for (String changeList : changeLists) {
                parameters.add("--cl");
                parameters.add(changeList);
            }
        }
    }

    public static String escape(@NotNull String path) {
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(26);
        }
        return path.contains("@") ? path + "@" : path;
    }

    public static <T> T parse(@NotNull String data, @NotNull Class<T> type) throws JAXBException {
        if (data == null) {
            CommandUtil.$$$reportNull$$$0(27);
        }
        if (type == null) {
            CommandUtil.$$$reportNull$$$0(28);
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(@NotNull ValidationEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                return event.getLinkedException() == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/svn/commandLine/CommandUtil$1", "handleEvent"));
            }
        });
        return (T)unmarshaller.unmarshal((Reader)new StringReader(data.trim()));
    }

    @NotNull
    public static File getHomeDirectory() {
        File file = new File(PathManager.getHomePath());
        if (file == null) {
            CommandUtil.$$$reportNull$$$0(29);
        }
        return file;
    }

    public static char getStatusChar(@Nullable String type) {
        return !StringUtil.isEmpty((String)type) ? type.charAt(0) : (char)' ';
    }

    @NotNull
    public static StatusType getStatusType(@Nullable String type) {
        StatusType statusType = CommandUtil.getStatusType(CommandUtil.getStatusChar(type));
        if (statusType == null) {
            CommandUtil.$$$reportNull$$$0(30);
        }
        return statusType;
    }

    @NotNull
    public static StatusType getStatusType(char first) {
        StatusType contentsStatus = 'A' == first ? StatusType.STATUS_ADDED : ('D' == first ? StatusType.STATUS_DELETED : ('U' == first ? StatusType.CHANGED : ('C' == first ? StatusType.CONFLICTED : ('G' == first ? StatusType.MERGED : ('R' == first ? StatusType.STATUS_REPLACED : ('E' == first ? StatusType.STATUS_OBSTRUCTED : StatusType.STATUS_NORMAL))))));
        StatusType statusType = contentsStatus;
        if (statusType == null) {
            CommandUtil.$$$reportNull$$$0(31);
        }
        return statusType;
    }

    @Nullable
    public static File findExistingParent(@Nullable File file) {
        while (file != null) {
            if (file.exists() && file.isDirectory()) {
                return file;
            }
            file = file.getParentFile();
        }
        return null;
    }

    @NotNull
    public static File requireExistingParent(@NotNull File file) {
        File result;
        if (file == null) {
            CommandUtil.$$$reportNull$$$0(32);
        }
        if ((result = CommandUtil.findExistingParent(file)) == null) {
            LOG.error("Existing parent not found for " + file.getAbsolutePath());
        }
        File file2 = (File)ObjectUtils.assertNotNull((Object)result);
        if (file2 == null) {
            CommandUtil.$$$reportNull$$$0(33);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/CommandUtil";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRevision";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endRevision";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/CommandUtil";
                break;
            }
            case 11: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeDirectory";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "requireExistingParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 10: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 11: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "putChangeLists";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "requireExistingParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

