/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.treeConflict.TreeConflictRefreshablePanel;

public class SvnTreeConflictResolver {
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final FilePath myPath;
    @Nullable
    private final FilePath myRevertPath;
    @NotNull
    private final VcsDirtyScopeManager myDirtyScopeManager;

    public SvnTreeConflictResolver(@NotNull SvnVcs vcs, @NotNull FilePath path, @Nullable FilePath revertPath) {
        if (vcs == null) {
            SvnTreeConflictResolver.$$$reportNull$$$0(0);
        }
        if (path == null) {
            SvnTreeConflictResolver.$$$reportNull$$$0(1);
        }
        this.myVcs = vcs;
        this.myPath = path;
        this.myRevertPath = revertPath;
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject());
    }

    public void resolveSelectTheirsFull() throws VcsException {
        LocalHistory localHistory = LocalHistory.getInstance();
        String pathPresentation = TreeConflictRefreshablePanel.filePath(this.myPath);
        localHistory.putSystemLabel(this.myVcs.getProject(), "Before accepting theirs for " + pathPresentation);
        try {
            this.updateToTheirsFull();
            this.pathDirty(this.myPath);
            this.revertAdditional();
        }
        finally {
            localHistory.putSystemLabel(this.myVcs.getProject(), "After accepting theirs for " + pathPresentation);
        }
    }

    private void pathDirty(@NotNull FilePath path) {
        VirtualFile validParent;
        if (path == null) {
            SvnTreeConflictResolver.$$$reportNull$$$0(2);
        }
        if ((validParent = ChangesUtil.findValidParentAccurately((FilePath)path)) != null) {
            validParent.refresh(false, true);
            if (path.isDirectory()) {
                this.myDirtyScopeManager.dirDirtyRecursively(path);
            } else {
                this.myDirtyScopeManager.fileDirty(path);
            }
        }
    }

    private void revertAdditional() throws VcsException {
        if (this.myRevertPath != null) {
            File ioFile = this.myRevertPath.getIOFile();
            Status status = this.myVcs.getFactory(ioFile).createStatusClient().doStatus(ioFile, false);
            this.revert(ioFile);
            if (status.is(StatusType.STATUS_ADDED)) {
                FileUtil.delete((File)ioFile);
            }
            this.pathDirty(this.myRevertPath);
        }
    }

    public void resolveSelectMineFull() throws VcsException {
        File ioFile = this.myPath.getIOFile();
        this.myVcs.getFactory(ioFile).createConflictClient().resolve(ioFile, Depth.INFINITY, true, true, true);
        this.pathDirty(this.myPath);
    }

    private void updateToTheirsFull() throws VcsException {
        File ioFile = this.myPath.getIOFile();
        Status status = this.myVcs.getFactory(ioFile).createStatusClient().doStatus(ioFile, false);
        if (status == null || status.is(StatusType.STATUS_UNVERSIONED)) {
            this.revert(ioFile);
            this.updateFile(ioFile, Revision.HEAD);
        } else if (status.is(StatusType.STATUS_ADDED)) {
            this.revert(ioFile);
            this.updateFile(ioFile, Revision.HEAD);
            FileUtil.delete((File)ioFile);
        } else {
            HashSet usedToBeAdded = this.myPath.isDirectory() ? this.getDescendantsWithAddedStatus(ioFile) : ContainerUtil.newHashSet();
            this.revert(ioFile);
            for (File wasAdded : usedToBeAdded) {
                FileUtil.delete((File)wasAdded);
            }
            this.updateFile(ioFile, Revision.HEAD);
        }
    }

    @NotNull
    private Set<File> getDescendantsWithAddedStatus(@NotNull File ioFile) throws SvnBindException {
        if (ioFile == null) {
            SvnTreeConflictResolver.$$$reportNull$$$0(3);
        }
        HashSet result = ContainerUtil.newHashSet();
        StatusClient statusClient = this.myVcs.getFactory(ioFile).createStatusClient();
        statusClient.doStatus(ioFile, Depth.INFINITY, false, false, false, false, status -> {
            if (status != null && status.is(StatusType.STATUS_ADDED)) {
                result.add(status.getFile());
            }
        });
        HashSet hashSet = result;
        if (hashSet == null) {
            SvnTreeConflictResolver.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private void revert(@NotNull File file) throws VcsException {
        if (file == null) {
            SvnTreeConflictResolver.$$$reportNull$$$0(5);
        }
        this.myVcs.getFactory(file).createRevertClient().revert(Collections.singletonList(file), Depth.INFINITY, null);
    }

    private void updateFile(@NotNull File file, @NotNull Revision revision) throws SvnBindException {
        if (file == null) {
            SvnTreeConflictResolver.$$$reportNull$$$0(6);
        }
        if (revision == null) {
            SvnTreeConflictResolver.$$$reportNull$$$0(7);
        }
        boolean useParentAsTarget = !file.exists();
        File target = useParentAsTarget ? file.getParentFile() : file;
        this.myVcs.getFactory(target).createUpdateClient().doUpdate(target, revision, Depth.INFINITY, useParentAsTarget, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescendantsWithAddedStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "pathDirty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDescendantsWithAddedStatus";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

