/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BatchJob
extends Job {
    private final List<Job> subJobs = new ArrayList<Job>();
    private final boolean shouldRefreshSceneGraph;
    private final boolean shouldUpdateSelection;
    private final String description;

    public BatchJob(EditorController editorController, boolean shouldRefreshSceneGraph, boolean shouldUpdateSelection, String description) {
        super(editorController);
        this.description = description;
        this.shouldRefreshSceneGraph = shouldRefreshSceneGraph;
        this.shouldUpdateSelection = shouldUpdateSelection;
    }

    public BatchJob(EditorController editorController, boolean shouldRefreshSceneGraph, String description) {
        super(editorController);
        this.description = description;
        this.shouldRefreshSceneGraph = shouldRefreshSceneGraph;
        this.shouldUpdateSelection = true;
    }

    public BatchJob(EditorController editorController, String description) {
        super(editorController);
        this.description = description;
        this.shouldRefreshSceneGraph = true;
        this.shouldUpdateSelection = true;
    }

    public BatchJob(EditorController editorController) {
        super(editorController);
        this.description = this.getClass().getSimpleName();
        this.shouldRefreshSceneGraph = true;
        this.shouldUpdateSelection = true;
    }

    public void addSubJob(Job subJob) {
        assert (subJob != null);
        this.subJobs.add(subJob);
    }

    public void addSubJobs(List<Job> subJobs) {
        assert (subJobs != null);
        this.subJobs.addAll(subJobs);
    }

    public void prependSubJob(Job subJob) {
        assert (subJob != null);
        this.subJobs.add(0, subJob);
    }

    public List<Job> getSubJobs() {
        return Collections.unmodifiableList(this.subJobs);
    }

    @Override
    public boolean isExecutable() {
        return !this.subJobs.isEmpty();
    }

    @Override
    public void execute() {
        Selection selection = this.getEditorController().getSelection();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (this.shouldUpdateSelection) {
            selection.beginUpdate();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.beginUpdate();
        }
        for (Job subJob : this.subJobs) {
            subJob.execute();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.endUpdate();
        }
        if (this.shouldUpdateSelection) {
            selection.endUpdate();
        }
    }

    @Override
    public void undo() {
        Selection selection = this.getEditorController().getSelection();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (this.shouldUpdateSelection) {
            selection.beginUpdate();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.beginUpdate();
        }
        for (int i = this.subJobs.size() - 1; i >= 0; --i) {
            this.subJobs.get(i).undo();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.endUpdate();
        }
        if (this.shouldUpdateSelection) {
            selection.endUpdate();
        }
    }

    @Override
    public void redo() {
        Selection selection = this.getEditorController().getSelection();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (this.shouldUpdateSelection) {
            selection.beginUpdate();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.beginUpdate();
        }
        for (Job subJob : this.subJobs) {
            subJob.redo();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.endUpdate();
        }
        if (this.shouldUpdateSelection) {
            selection.endUpdate();
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

