/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.TableColumnBase;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;

public class UseComputedSizesObjectJob
extends BatchDocumentJob {
    private final FXOMInstance fxomInstance;

    public UseComputedSizesObjectJob(FXOMInstance fxomInstance, EditorController editorController) {
        super(editorController);
        assert (fxomInstance != null);
        this.fxomInstance = fxomInstance;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        Object sceneGraphObject = this.fxomInstance.getSceneGraphObject();
        if (sceneGraphObject instanceof RowConstraints) {
            result.addAll(this.modifyHeightJobs(this.fxomInstance));
        } else if (sceneGraphObject instanceof ColumnConstraints) {
            result.addAll(this.modifyWidthJobs(this.fxomInstance));
        } else if (sceneGraphObject instanceof Region) {
            result.addAll(this.removeAnchorsJobs());
            result.addAll(this.modifyHeightJobs(this.fxomInstance));
            result.addAll(this.modifyWidthJobs(this.fxomInstance));
        } else if (sceneGraphObject instanceof ImageView) {
            result.addAll(this.modifyFitHeightJob(this.fxomInstance));
            result.addAll(this.modifyFitWidthJob(this.fxomInstance));
        } else if (sceneGraphObject instanceof TableColumnBase) {
            result.addAll(this.modifyWidthJobs(this.fxomInstance));
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Use Computed Sizes on ");
        Object sceneGraphObject = this.fxomInstance.getSceneGraphObject();
        assert (sceneGraphObject != null);
        sb.append(sceneGraphObject.getClass().getSimpleName());
        return sb.toString();
    }

    private List<Job> removeAnchorsJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        FXOMObject parentObject = this.fxomInstance.getParentObject();
        if (parentObject != null && parentObject.getSceneGraphObject() instanceof AnchorPane) {
            PropertyName topAnchorPN = new PropertyName("topAnchor", AnchorPane.class);
            ValuePropertyMetadata topAnchorVPM = Metadata.getMetadata().queryValueProperty(this.fxomInstance, topAnchorPN);
            PropertyName rightAnchorPN = new PropertyName("rightAnchor", AnchorPane.class);
            ValuePropertyMetadata rightAnchorVPM = Metadata.getMetadata().queryValueProperty(this.fxomInstance, rightAnchorPN);
            PropertyName bottomAnchorPN = new PropertyName("bottomAnchor", AnchorPane.class);
            ValuePropertyMetadata bottomAnchorVPM = Metadata.getMetadata().queryValueProperty(this.fxomInstance, bottomAnchorPN);
            PropertyName leftAnchorPN = new PropertyName("leftAnchor", AnchorPane.class);
            ValuePropertyMetadata leftAnchorVPM = Metadata.getMetadata().queryValueProperty(this.fxomInstance, leftAnchorPN);
            for (ValuePropertyMetadata vpm : new ValuePropertyMetadata[]{topAnchorVPM, rightAnchorVPM, bottomAnchorVPM, leftAnchorVPM}) {
                if (vpm.getValueObject(this.fxomInstance) == null) continue;
                ModifyObjectJob subJob = new ModifyObjectJob(this.fxomInstance, vpm, null, this.getEditorController());
                result.add(subJob);
            }
        }
        return result;
    }

    private List<Job> modifyHeightJobs(FXOMInstance candidate) {
        ArrayList<Job> result = new ArrayList<Job>();
        PropertyName maxHeight = new PropertyName("maxHeight");
        PropertyName minHeight = new PropertyName("minHeight");
        PropertyName prefHeight = new PropertyName("prefHeight");
        ValuePropertyMetadata maxHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, maxHeight);
        ValuePropertyMetadata minHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, minHeight);
        ValuePropertyMetadata prefHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, prefHeight);
        ModifyObjectJob maxHeightJob = new ModifyObjectJob(candidate, maxHeightVPM, -1.0, this.getEditorController());
        ModifyObjectJob minHeightJob = new ModifyObjectJob(candidate, minHeightVPM, -1.0, this.getEditorController());
        ModifyObjectJob prefHeightJob = new ModifyObjectJob(candidate, prefHeightVPM, -1.0, this.getEditorController());
        if (maxHeightJob.isExecutable()) {
            result.add(maxHeightJob);
        }
        if (minHeightJob.isExecutable()) {
            result.add(minHeightJob);
        }
        if (prefHeightJob.isExecutable()) {
            result.add(prefHeightJob);
        }
        return result;
    }

    private List<Job> modifyWidthJobs(FXOMInstance candidate) {
        ArrayList<Job> result = new ArrayList<Job>();
        PropertyName maxWidth = new PropertyName("maxWidth");
        PropertyName minWidth = new PropertyName("minWidth");
        PropertyName prefWidth = new PropertyName("prefWidth");
        ValuePropertyMetadata maxWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, maxWidth);
        ValuePropertyMetadata minWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, minWidth);
        ValuePropertyMetadata prefWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, prefWidth);
        ModifyObjectJob maxWidthJob = new ModifyObjectJob(candidate, maxWidthVPM, -1.0, this.getEditorController());
        ModifyObjectJob minWidthJob = new ModifyObjectJob(candidate, minWidthVPM, -1.0, this.getEditorController());
        ModifyObjectJob prefWidthJob = new ModifyObjectJob(candidate, prefWidthVPM, -1.0, this.getEditorController());
        if (maxWidthJob.isExecutable()) {
            result.add(maxWidthJob);
        }
        if (minWidthJob.isExecutable()) {
            result.add(minWidthJob);
        }
        if (prefWidthJob.isExecutable()) {
            result.add(prefWidthJob);
        }
        return result;
    }

    private List<Job> modifyFitHeightJob(FXOMInstance candidate) {
        ArrayList<Job> result = new ArrayList<Job>();
        PropertyName fitHeight = new PropertyName("fitHeight");
        ValuePropertyMetadata fitHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, fitHeight);
        ModifyObjectJob fitHeightJob = new ModifyObjectJob(candidate, fitHeightVPM, 0.0, this.getEditorController());
        if (fitHeightJob.isExecutable()) {
            result.add(fitHeightJob);
        }
        return result;
    }

    private List<Job> modifyFitWidthJob(FXOMInstance candidate) {
        ArrayList<Job> result = new ArrayList<Job>();
        PropertyName fitWidth = new PropertyName("fitWidth");
        ValuePropertyMetadata fitWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, fitWidth);
        ModifyObjectJob fitWidthJob = new ModifyObjectJob(candidate, fitWidthVPM, 0.0, this.getEditorController());
        if (fitWidthJob.isExecutable()) {
            result.add(fitWidthJob);
        }
        return result;
    }
}

