/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.RowConstraintsListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collections;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;

public class InsertRowConstraintsJob
extends Job {
    private static final RowConstraintsListPropertyMetadata rowContraintsMeta = new RowConstraintsListPropertyMetadata(new PropertyName("rowConstraints"), true, Collections.emptyList(), InspectorPath.UNUSED);
    private final FXOMInstance gridPaneObject;
    private final int rowIndex;
    private final int insertCount;

    public InsertRowConstraintsJob(FXOMObject gridPaneObject, int rowIndex, int insertCount, EditorController editorController) {
        super(editorController);
        assert (gridPaneObject instanceof FXOMInstance);
        assert (gridPaneObject.getSceneGraphObject() instanceof GridPane);
        assert (rowIndex >= 0);
        assert (rowIndex <= rowContraintsMeta.getValue((FXOMInstance)gridPaneObject).size());
        assert (insertCount >= 1);
        this.gridPaneObject = (FXOMInstance)gridPaneObject;
        this.rowIndex = rowIndex;
        this.insertCount = insertCount;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        ArrayList constraintsList = new ArrayList(rowContraintsMeta.getValue(this.gridPaneObject));
        assert (this.rowIndex < constraintsList.size());
        for (int i = 0; i < this.insertCount; ++i) {
            constraintsList.remove(this.rowIndex);
        }
        rowContraintsMeta.setValue(this.gridPaneObject, constraintsList);
    }

    @Override
    public void redo() {
        ArrayList constraintsList = new ArrayList(rowContraintsMeta.getValue(this.gridPaneObject));
        RowConstraints template = this.rowIndex >= 1 ? (RowConstraints)constraintsList.get(this.rowIndex - 1) : null;
        for (int i = 0; i < this.insertCount; ++i) {
            constraintsList.add(this.rowIndex, this.makeRowConstraints(template));
        }
        rowContraintsMeta.setValue(this.gridPaneObject, constraintsList);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }

    private RowConstraints makeRowConstraints(RowConstraints template) {
        RowConstraints result = new RowConstraints();
        if (this.rowIndex >= 1) {
            result.setFillHeight(template.isFillHeight());
            result.setValignment(template.getValignment());
            result.setVgrow(template.getVgrow());
            result.setMaxHeight(template.getMaxHeight());
            result.setMinHeight(template.getMinHeight());
            result.setPercentHeight(template.getPercentHeight());
            result.setPrefHeight(template.getPrefHeight());
        }
        return result;
    }
}

