/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.sampledata;

import com.oracle.javafx.scenebuilder.kit.fxom.sampledata.AbstractSampleData;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;

class TableViewSampleData
extends AbstractSampleData {
    private final List<SampleDataItem> sampleItems = new ArrayList<SampleDataItem>();

    public TableViewSampleData() {
        for (int i = 0; i < 20; ++i) {
            this.sampleItems.add(new SampleDataItem(i));
        }
    }

    public static boolean canApplyTo(TableView<?> tableView) {
        boolean result;
        if (!tableView.getItems().isEmpty()) {
            result = false;
        } else {
            TableColumn tc;
            ArrayList columns = new ArrayList();
            columns.addAll(tableView.getColumns());
            while (!columns.isEmpty() && (tc = (TableColumn)columns.get(0)).getCellValueFactory() == null) {
                columns.remove(0);
                columns.addAll(tc.getColumns());
            }
            result = columns.isEmpty();
        }
        return result;
    }

    @Override
    public void applyTo(Object sceneGraphObject) {
        assert (sceneGraphObject instanceof TableView);
        TableView tableView = (TableView)sceneGraphObject;
        tableView.getItems().clear();
        tableView.getItems().addAll(this.sampleItems);
        ArrayList columns = new ArrayList(tableView.getColumns());
        while (!columns.isEmpty()) {
            TableColumn tc = (TableColumn)columns.get(0);
            tc.setCellValueFactory(SampleDataItem.FACTORY);
            columns.remove(0);
            columns.addAll(tc.getColumns());
        }
    }

    @Override
    public void removeFrom(Object sceneGraphObject) {
        assert (sceneGraphObject instanceof TableView);
        TableView tableView = (TableView)TableView.class.cast(sceneGraphObject);
        tableView.getItems().clear();
        ArrayList columns = new ArrayList();
        columns.addAll(tableView.getColumns());
        while (!columns.isEmpty()) {
            TableColumn tc = (TableColumn)columns.get(0);
            tc.setCellValueFactory(null);
            columns.remove(0);
            columns.addAll(tc.getColumns());
        }
    }

    public static class SampleDataItem {
        int index;
        public static final PropertyValueFactory<SampleDataItem, String> FACTORY = new PropertyValueFactory("prop");

        public SampleDataItem(int index) {
            this.index = index;
        }

        public String getProp() {
            return TableViewSampleData.lorem(this.index);
        }
    }
}

