/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.AbstractAndroidClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AndroidOClassLoadingAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AbstractAndroidClassLoadingAdapter;", "()V", "isApplicable", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "info", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "loadClasses", "Lcom/sun/jdi/ClassLoaderReference;", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "resolveClassLoaderClass", "Lcom/sun/jdi/ClassType;", "idea-jvm"})
public final class AndroidOClassLoadingAdapter
extends AbstractAndroidClassLoadingAdapter {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull EvaluationContextImpl context, @NotNull ClassLoadingAdapter.Companion.ClassInfoForEvaluator info) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        ClassLoadingAdapter.Companion.ClassInfoForEvaluator $receiver = info;
        if (!$receiver.isCompilingEvaluatorPreferred()) return false;
        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
        if (!NoStrataPositionManagerHelperKt.isDexDebug((DebugProcess)debugProcessImpl)) return false;
        return true;
    }

    private final ClassType resolveClassLoaderClass(EvaluationContextImpl context) {
        try {
            DebugProcessImpl debugProcessImpl = context.getDebugProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
            ReferenceType referenceType = this.tryLoadClass(debugProcessImpl, context, "dalvik.system.InMemoryDexClassLoader", context.getClassLoader());
            if (!(referenceType instanceof ClassType)) {
                referenceType = null;
            }
            return (ClassType)referenceType;
        }
        catch (EvaluateException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public ClassLoaderReference loadClasses(@NotNull EvaluationContextImpl context, @NotNull Collection<ClassToLoad> classes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
        DebugProcessImpl process2 = debugProcessImpl;
        ClassType classType = this.resolveClassLoaderClass(context);
        if (classType == null) {
            String string = "InMemoryDexClassLoader class not found";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ClassType inMemoryClassLoaderClass = classType;
        Method method = inMemoryClassLoaderClass.concreteMethodByName("<init>", "(Ljava/nio/ByteBuffer;Ljava/lang/ClassLoader;)V");
        if (method == null) {
            String string = "Constructor method not found";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Method constructorMethod = method;
        byte[] byArray = this.dex(context, classes);
        if (byArray == null) {
            String string = "Can't dex classes";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        byte[] dexBytes = byArray;
        ArrayReference dexBytesMirror = this.mirrorOfByteArray(dexBytes, context, process2);
        ObjectReference dexByteBuffer = this.wrapToByteBuffer(dexBytesMirror, (EvaluationContext)context, process2);
        ObjectReference newClassLoader = process2.newInstance((EvaluationContext)context, inMemoryClassLoaderClass, constructorMethod, CollectionsKt.listOf((Object[])new ObjectReference[]{dexByteBuffer, context.getClassLoader()}));
        DebuggerUtilsEx.keep((Value)newClassLoader, (EvaluationContext)((EvaluationContext)context));
        ObjectReference objectReference = newClassLoader;
        if (objectReference == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassLoaderReference");
        }
        return (ClassLoaderReference)objectReference;
    }
}

