/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.Range;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.idea.debugger.stepping.StepOverFilterData;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0016\u001a\u00020\r*\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepOverInlineFilter;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodFilter;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lorg/jetbrains/kotlin/idea/debugger/stepping/StepOverFilterData;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/debugger/stepping/StepOverFilterData;)V", "getData", "()Lorg/jetbrains/kotlin/idea/debugger/stepping/StepOverFilterData;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCallingExpressionLines", "Lcom/intellij/util/Range;", "", "locationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ktLineNumber", "idea-jvm"})
public final class KotlinStepOverInlineFilter
implements KotlinMethodFilter {
    @NotNull
    private final Project project;
    @NotNull
    private final StepOverFilterData data;

    private final int ktLineNumber(@NotNull Location $receiver) {
        return ((Number)NoStrataPositionManagerHelperKt.ktLocationInfo$default($receiver, this.data.isDexDebug(), this.project, false, null, 24, null).getFirst()).intValue();
    }

    @Override
    public boolean locationMatches(@NotNull SuspendContextImpl context, @NotNull Location location2) {
        boolean bl;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
            StackFrameProxyImpl stackFrameProxyImpl = context.getFrameProxy();
            if (stackFrameProxyImpl == null) {
                return true;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)stackFrameProxyImpl, (String)"context.frameProxy ?: return true");
            StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
            if (this.data.getSkipAfterCodeIndex() != -1L && location2.codeIndex() > this.data.getSkipAfterCodeIndex()) {
                return false;
            }
            int currentLine = this.ktLineNumber(location2);
            if (!this.data.getStepOverLines().contains(currentLine)) {
                return currentLine != this.data.getLineNumber();
            }
            List<LocalVariable> visibleInlineVariables = KotlinSteppingCommandProviderKt.getInlineRangeLocalVariables(frameProxy);
            Iterable $receiver$iv = this.data.getInlineRangeVariables();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    LocalVariable it = (LocalVariable)element$iv;
                    if (!(!visibleInlineVariables.contains(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        throw (Throwable)new IllegalStateException();
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final StepOverFilterData getData() {
        return this.data;
    }

    public KotlinStepOverInlineFilter(@NotNull Project project, @NotNull StepOverFilterData data) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.project = project;
        this.data = data;
    }
}

