/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.java;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.CannotCreateJavaCompilerException;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.javac.JavacMain;

public class JavacCompilerTool
extends JavaCompilingTool {
    public static final String ID = "Javac";
    public static final String ALTERNATIVE_ID = "compAPI";

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            JavacCompilerTool.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Override
    @Nullable
    public String getAlternativeId() {
        return ALTERNATIVE_ID;
    }

    @Override
    public boolean isCompilerTreeAPISupported() {
        return true;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = "javac " + System.getProperty("java.version");
        if (string == null) {
            JavacCompilerTool.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JavaCompiler createCompiler() throws CannotCreateJavaCompilerException {
        JavaCompiler javaCompiler;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler != null) {
            JavaCompiler javaCompiler2 = compiler;
            if (javaCompiler2 == null) {
                JavacCompilerTool.$$$reportNull$$$0(2);
            }
            return javaCompiler2;
        }
        try {
            javaCompiler = (JavaCompiler)Class.forName("com.sun.tools.javac.api.JavacTool", true, JavacMain.class.getClassLoader()).newInstance();
        }
        catch (Throwable ex) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("System Java Compiler was not found in classpath");
            stringWriter.write(":\n");
            ex.printStackTrace(new PrintWriter(stringWriter));
            String message = stringWriter.getBuffer().toString();
            throw new CannotCreateJavaCompilerException(message);
        }
        if (javaCompiler == null) {
            JavacCompilerTool.$$$reportNull$$$0(3);
        }
        return javaCompiler;
    }

    @Override
    @NotNull
    public List<File> getAdditionalClasspath() {
        List<File> list = Collections.emptyList();
        if (list == null) {
            JavacCompilerTool.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public List<String> getDefaultCompilerOptions() {
        return Collections.singletonList("-implicit:class");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/builders/impl/java/JavacCompilerTool";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompiler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalClasspath";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

