/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext$WhenMappings;
import org.jetbrains.kotlin.jps.build.KotlinCompileContextKt;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolderKt;
import org.jetbrains.kotlin.jps.build.RebuildAfterCacheVersionChangeMarker;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesDiff;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManagerKt;
import org.jetbrains.kotlin.jps.incremental.CacheStatus;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributes;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageKt;
import org.jetbrains.kotlin.jps.incremental.KotlinDataContainerTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndex;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndexBuilder;
import org.jetbrains.kotlin.jps.targets.KotlinUnsupportedModuleBuildTarget;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002072\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u000207J\b\u0010<\u001a\u000207H\u0002J\b\u0010=\u001a\u000207H\u0002J\u0006\u0010>\u001a\u000207J\u0006\u0010?\u001a\u000207J\u0010\u0010@\u001a\u0004\u0018\u00010:2\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020!J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u0013H\u0002J\u0018\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020!H\u0002J\b\u0010J\u001a\u00020\u0019H\u0002J\u0010\u0010K\u001a\u0002072\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0002J\u0006\u0010O\u001a\u000207R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R!\u0010(\u001a\u0012\u0012\u0004\u0012\u00020*\u0012\b\u0012\u0006\u0012\u0002\b\u00030+0)8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0013\u00102\u001a\u0004\u0018\u0001038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "", "jpsContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "(Lorg/jetbrains/jps/incremental/CompileContext;)V", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "kotlin.jvm.PlatformType", "getDataManager", "()Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "getDataPaths", "()Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "hasKotlinMarker", "Lorg/jetbrains/kotlin/jps/build/HasKotlinMarker;", "getHasKotlinMarker", "()Lorg/jetbrains/kotlin/jps/build/HasKotlinMarker;", "initialLookupsCacheStateDiff", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesDiff;", "getJpsContext", "()Lorg/jetbrains/jps/incremental/CompileContext;", "lookupAttributesSaved", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lookupsCacheAttributesManager", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "getLookupsCacheAttributesManager", "()Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "rebuildAfterCacheVersionChanged", "Lorg/jetbrains/kotlin/jps/build/RebuildAfterCacheVersionChangeMarker;", "getRebuildAfterCacheVersionChanged", "()Lorg/jetbrains/kotlin/jps/build/RebuildAfterCacheVersionChangeMarker;", "rebuildingAllKotlin", "", "getRebuildingAllKotlin", "()Z", "setRebuildingAllKotlin", "(Z)V", "shouldCheckCacheVersions", "getShouldCheckCacheVersions", "targetsBinding", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "getTargetsBinding", "()Ljava/util/Map;", "targetsIndex", "Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "getTargetsIndex", "()Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "testingLogger", "Lorg/jetbrains/kotlin/jps/build/TestingBuildLogger;", "getTestingLogger", "()Lorg/jetbrains/kotlin/jps/build/TestingBuildLogger;", "checkCacheVersions", "", "checkChunkCacheVersion", "chunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "cleanupCaches", "clearAllCaches", "clearLookupCache", "dispose", "ensureLookupsCacheAttributesSaved", "getChunk", "rawChunk", "Lorg/jetbrains/jps/ModuleChunk;", "hasKotlin", "loadLookupsCacheStateDiff", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributes;", "logMarkDirtyForTestingBeforeRound", "file", "Ljava/io/File;", "shouldProcess", "makeLookupsCacheAttributesManager", "markAllKotlinForRebuild", "reason", "", "markChunkForRebuildBeforeBuild", "reportUnsupportedTargets", "jps-plugin"})
public final class KotlinCompileContext {
    private final BuildDataManager dataManager;
    private final BuildDataPaths dataPaths;
    @NotNull
    private final KotlinTargetsIndex targetsIndex;
    @NotNull
    private final CompositeLookupsCacheAttributesManager lookupsCacheAttributesManager;
    private final boolean shouldCheckCacheVersions;
    @NotNull
    private final HasKotlinMarker hasKotlinMarker;
    @NotNull
    private final RebuildAfterCacheVersionChangeMarker rebuildAfterCacheVersionChanged;
    private boolean rebuildingAllKotlin;
    private final CacheAttributesDiff<?> initialLookupsCacheStateDiff;
    private final AtomicBoolean lookupAttributesSaved;
    @NotNull
    private final CompileContext jpsContext;

    public final BuildDataManager getDataManager() {
        return this.dataManager;
    }

    public final BuildDataPaths getDataPaths() {
        return this.dataPaths;
    }

    @Nullable
    public final TestingBuildLogger getTestingLogger() {
        TestingContext testingContext = TestingContextKt.getTestingContext(this.jpsContext);
        return testingContext != null ? testingContext.getBuildLogger() : null;
    }

    @NotNull
    public final KotlinTargetsIndex getTargetsIndex() {
        return this.targetsIndex;
    }

    @NotNull
    public final Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> getTargetsBinding() {
        return this.targetsIndex.getByJpsTarget();
    }

    @NotNull
    public final CompositeLookupsCacheAttributesManager getLookupsCacheAttributesManager() {
        return this.lookupsCacheAttributesManager;
    }

    public final boolean getShouldCheckCacheVersions() {
        return this.shouldCheckCacheVersions;
    }

    @NotNull
    public final HasKotlinMarker getHasKotlinMarker() {
        return this.hasKotlinMarker;
    }

    @NotNull
    public final RebuildAfterCacheVersionChangeMarker getRebuildAfterCacheVersionChanged() {
        return this.rebuildAfterCacheVersionChanged;
    }

    public final boolean getRebuildingAllKotlin() {
        return this.rebuildingAllKotlin;
    }

    public final void setRebuildingAllKotlin(boolean bl) {
        this.rebuildingAllKotlin = bl;
    }

    private final CompositeLookupsCacheAttributesManager makeLookupsCacheAttributesManager() {
        File lookupsCacheRootPath;
        Set expectedLookupsCacheComponents = new LinkedHashSet();
        Iterable $receiver$iv = this.targetsIndex.getChunks();
        for (Object element$iv : $receiver$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            Iterable $receiver$iv2 = chunk.getTargets();
            for (Object element$iv2 : $receiver$iv2) {
                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                if (!target.isIncrementalCompilationEnabled()) continue;
                expectedLookupsCacheComponents.add(target.getGlobalLookupCacheId());
            }
        }
        File file = lookupsCacheRootPath = this.dataPaths.getTargetDataRoot((BuildTarget)KotlinDataContainerTarget.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lookupsCacheRootPath");
        return new CompositeLookupsCacheAttributesManager(file, expectedLookupsCacheComponents);
    }

    private final CacheAttributesDiff<CompositeLookupsCacheAttributes> loadLookupsCacheStateDiff() {
        CacheAttributesDiff diff = CacheAttributesManagerKt.loadDiff$default(this.lookupsCacheAttributesManager, null, null, 3, null);
        if (diff.getStatus() == CacheStatus.VALID) {
            try {
                BuildDataManager buildDataManager = this.dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                JpsLookupStorageKt.withLookupStorage(buildDataManager, loadLookupsCacheStateDiff.1.INSTANCE);
            }
            catch (Exception e) {
                this.jpsContext.processMessage((BuildMessage)new CompilerMessage("Kotlin", BuildMessage.Kind.WARNING, "Incremental caches are corrupted. All Kotlin code will be rebuilt."));
                KotlinBuilder.Companion.getLOG().info((Throwable)new Error("Lookup storage is corrupted, probe failed: " + e.getMessage(), e));
                this.markAllKotlinForRebuild("Lookup storage is corrupted");
                return CacheAttributesDiff.copy$default(diff, null, null, null, 5, null);
            }
        }
        return diff;
    }

    public final boolean hasKotlin() {
        boolean bl;
        block7: {
            Iterable $receiver$iv = this.targetsIndex.getChunks();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    boolean bl2;
                    block6: {
                        KotlinChunk chunk = (KotlinChunk)element$iv;
                        Iterable $receiver$iv2 = chunk.getTargets();
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv2) {
                                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                                if (!Intrinsics.areEqual((Object)this.hasKotlinMarker.get(target), (Object)true)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void checkCacheVersions() {
        switch (KotlinCompileContext$WhenMappings.$EnumSwitchMapping$0[this.initialLookupsCacheStateDiff.getStatus().ordinal()]) {
            case 1: {
                TestingBuildLogger testingBuildLogger = this.getTestingLogger();
                if (testingBuildLogger != null) {
                    testingBuildLogger.invalidOrUnusedCache(null, null, this.initialLookupsCacheStateDiff);
                }
                if (this.initialLookupsCacheStateDiff.getActual() != null) {
                    this.markAllKotlinForRebuild("Kotlin incremental cache settings or format was changed");
                    this.clearLookupCache();
                    break;
                }
                this.markAllKotlinForRebuild("Kotlin incremental cache is missed or corrupted");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Object object = TestingContextKt.getTestingContext(this.jpsContext);
                if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                    object.invalidOrUnusedCache(null, null, this.initialLookupsCacheStateDiff);
                }
                KotlinBuilder.Companion.getLOG().info("Removing global cache as it is not required anymore: " + this.initialLookupsCacheStateDiff);
                this.clearAllCaches();
                break;
            }
            case 4: {
            }
        }
    }

    public final void ensureLookupsCacheAttributesSaved() {
        if (this.lookupAttributesSaved.compareAndSet(false, true)) {
            CacheAttributesManager.DefaultImpls.writeVersion$default(this.initialLookupsCacheStateDiff.getManager(), null, 1, null);
        }
    }

    public final void checkChunkCacheVersion(@NotNull KotlinChunk chunk) {
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        if (this.shouldCheckCacheVersions && !this.rebuildingAllKotlin && chunk.shouldRebuild()) {
            this.markChunkForRebuildBeforeBuild(chunk);
        }
    }

    private final boolean logMarkDirtyForTestingBeforeRound(File file, boolean shouldProcess) {
        block1: {
            if (!shouldProcess) break block1;
            TestingBuildLogger testingBuildLogger = this.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.markedAsDirtyBeforeRound(CollectionsKt.listOf((Object)file));
            }
        }
        return shouldProcess;
    }

    private final void markAllKotlinForRebuild(String reason) {
        if (this.rebuildingAllKotlin) {
            return;
        }
        this.rebuildingAllKotlin = true;
        KotlinBuilder.Companion.getLOG().info("Rebuilding all Kotlin: " + reason);
        BuildDataManager dataManager = this.jpsContext.getProjectDescriptor().dataManager;
        Iterable $receiver$iv = this.targetsIndex.getChunks();
        for (Object element$iv : $receiver$iv) {
            KotlinChunk it = (KotlinChunk)element$iv;
            this.markChunkForRebuildBeforeBuild(it);
        }
        BuildDataManager buildDataManager = dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        JpsLookupStorageKt.cleanLookupStorage(buildDataManager, KotlinBuilder.Companion.getLOG());
    }

    private final void markChunkForRebuildBeforeBuild(KotlinChunk chunk) {
        Iterable $receiver$iv = chunk.getTargets();
        for (Object element$iv : $receiver$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            FSOperations.markDirty((CompileContext)this.jpsContext, (CompilationRound)CompilationRound.NEXT, (ModuleBuildTarget)it.getJpsModuleBuildTarget(), (FileFilter)new FileFilter(this){
                final /* synthetic */ KotlinCompileContext this$0;
                {
                    this.this$0 = kotlinCompileContext;
                }

                public final boolean accept(File file) {
                    File file2 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                    return KotlinCompileContext.access$logMarkDirtyForTestingBeforeRound(this.this$0, file2, KotlinDirtySourceFilesHolderKt.isKotlinSourceFile(file));
                }
            });
            BuildDataManager buildDataManager = this.dataManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
            JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
            if (jpsIncrementalCache != null) {
                jpsIncrementalCache.clean();
            }
            this.hasKotlinMarker.clean(it);
            this.rebuildAfterCacheVersionChanged.set(it, true);
        }
    }

    private final void clearAllCaches() {
        this.clearLookupCache();
        KotlinBuilder.Companion.getLOG().info("Clearing caches for all targets");
        Iterable $receiver$iv = this.targetsIndex.getChunks();
        for (Object element$iv : $receiver$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            Iterable $receiver$iv2 = chunk.getTargets();
            for (Object element$iv2 : $receiver$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                BuildDataManager buildDataManager = this.dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
                if (jpsIncrementalCache == null) continue;
                jpsIncrementalCache.clean();
            }
        }
    }

    private final void clearLookupCache() {
        KotlinBuilder.Companion.getLOG().info("Clearing lookup cache");
        BuildDataManager buildDataManager = this.dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        JpsLookupStorageKt.cleanLookupStorage(buildDataManager, KotlinBuilder.Companion.getLOG());
        CacheAttributesManager.DefaultImpls.writeVersion$default(this.initialLookupsCacheStateDiff.getManager(), null, 1, null);
    }

    public final void cleanupCaches() {
        Iterable $receiver$iv = this.targetsIndex.getChunks();
        for (Object element$iv : $receiver$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            Iterable $receiver$iv2 = chunk.getTargets();
            for (Object element$iv2 : $receiver$iv2) {
                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                if (target.getInitialLocalCacheAttributesDiff().getStatus() != CacheStatus.SHOULD_BE_CLEARED) continue;
                KotlinBuilder.Companion.getLOG().info(target + " caches is cleared as not required anymore: " + target.getInitialLocalCacheAttributesDiff());
                TestingBuildLogger testingBuildLogger = this.getTestingLogger();
                if (testingBuildLogger != null) {
                    testingBuildLogger.invalidOrUnusedCache(null, target, target.getInitialLocalCacheAttributesDiff());
                }
                target.getInitialLocalCacheAttributesDiff().getManager().writeVersion(null);
                BuildDataManager buildDataManager = this.dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, target);
                if (jpsIncrementalCache == null) continue;
                jpsIncrementalCache.clean();
            }
        }
    }

    public final void dispose() {
    }

    @Nullable
    public final KotlinChunk getChunk(@NotNull ModuleChunk rawChunk) {
        Intrinsics.checkParameterIsNotNull((Object)rawChunk, (String)"rawChunk");
        ModuleBuildTarget rawRepresentativeTarget = rawChunk.representativeTarget();
        Object object = this.getTargetsBinding();
        Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map2 = object;
        if (!map2.containsKey(rawRepresentativeTarget)) {
            return null;
        }
        KotlinChunk kotlinChunk = this.targetsIndex.getChunksByJpsRepresentativeTarget().get(rawRepresentativeTarget);
        if (kotlinChunk == null) {
            object = "Kotlin binding for chunk " + this + " is not loaded at build start";
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return kotlinChunk;
    }

    /*
     * WARNING - void declaration
     */
    public final void reportUnsupportedTargets() {
        Object answer$iv;
        Object $receiver$iv;
        Map byKind = new LinkedHashMap();
        Object $receiver$iv2 = this.targetsIndex.getChunks();
        Object object = $receiver$iv2.iterator();
        while (object.hasNext()) {
            Object object2;
            Object object3;
            Object element$iv = object.next();
            KotlinChunk it = (KotlinChunk)element$iv;
            KotlinModuleBuildTarget<?> target = it.getRepresentativeTarget();
            if (!(target instanceof KotlinUnsupportedModuleBuildTarget) || !(!(object3 = target.getSourceFiles()).isEmpty())) continue;
            object3 = byKind;
            String key$iv = ((KotlinUnsupportedModuleBuildTarget)target).getKind();
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                answer$iv = new ArrayList();
                $receiver$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((List)object2).add(target);
        }
        object = $receiver$iv2 = byKind;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv$iv;
            Object $i$f$getOrPut;
            Map.Entry element$iv;
            Map.Entry $kind_targets = element$iv = iterator2.next();
            $receiver$iv = $kind_targets;
            String kind = (String)$receiver$iv.getKey();
            $receiver$iv = $kind_targets;
            List targets = (List)$receiver$iv.getValue();
            if (($receiver$iv = targets).size() > 1) {
                answer$iv = $receiver$iv;
                $i$f$getOrPut = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        KotlinUnsupportedModuleBuildTarget it = (KotlinUnsupportedModuleBuildTarget)a;
                        Comparable comparable = (Comparable)((Object)it.getModule().getName());
                        it = (KotlinUnsupportedModuleBuildTarget)b;
                        Comparable comparable2 = comparable;
                        String string = it.getModule().getName();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                };
                CollectionsKt.sortWith((List)answer$iv, (Comparator)$i$f$getOrPut);
            }
            Iterable $receiver$iv3 = targets;
            $i$f$getOrPut = $receiver$iv3;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KotlinUnsupportedModuleBuildTarget kotlinUnsupportedModuleBuildTarget = (KotlinUnsupportedModuleBuildTarget)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = it.getChunk().getPresentableShortName();
                collection.add(string);
            }
            List chunkNames = (List)destination$iv$iv;
            String presentableChunksListString = KotlinCompileContextKt.joinToReadableString(chunkNames);
            String msg = kind == null ? presentableChunksListString + " is not yet supported in IDEA internal build system. " + "Please use Gradle to build them (enable 'Delegate IDE build/run actions to Gradle' in Settings)." : kind + " is not yet supported in IDEA internal build system. " + "Please use Gradle to build " + presentableChunksListString + " (enable 'Delegate IDE build/run actions to Gradle' in Settings).";
            TestingBuildLogger testingBuildLogger = this.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.addCustomMessage(msg);
            }
            this.jpsContext.processMessage((BuildMessage)new CompilerMessage("Kotlin", BuildMessage.Kind.WARNING, msg));
        }
    }

    @NotNull
    public final CompileContext getJpsContext() {
        return this.jpsContext;
    }

    public KotlinCompileContext(@NotNull CompileContext jpsContext) {
        Intrinsics.checkParameterIsNotNull((Object)jpsContext, (String)"jpsContext");
        this.jpsContext = jpsContext;
        BuildDataManager buildDataManager = this.dataManager = this.jpsContext.getProjectDescriptor().dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        this.dataPaths = buildDataManager.getDataPaths();
        this.targetsIndex = new KotlinTargetsIndexBuilder(this).build();
        this.lookupsCacheAttributesManager = this.makeLookupsCacheAttributesManager();
        this.shouldCheckCacheVersions = System.getProperty("kotlin.jps.skip.cache.version.check") == null;
        BuildDataManager buildDataManager2 = this.dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager2, (String)"dataManager");
        this.hasKotlinMarker = new HasKotlinMarker(buildDataManager2);
        BuildDataManager buildDataManager3 = this.dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager3, (String)"dataManager");
        this.rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(buildDataManager3);
        this.initialLookupsCacheStateDiff = this.loadLookupsCacheStateDiff();
        this.lookupAttributesSaved = new AtomicBoolean(false);
    }

    public static final /* synthetic */ boolean access$logMarkDirtyForTestingBeforeRound(KotlinCompileContext $this, File file, boolean shouldProcess) {
        return $this.logMarkDirtyForTestingBeforeRound(file, shouldProcess);
    }
}

