/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CaptureStorage {
    public static final String GENERATED_INSERT_METHOD_POSTFIX = "$$$capture";
    private static final ReferenceQueue KEY_REFERENCE_QUEUE = new ReferenceQueue();
    private static final ConcurrentMap<WeakReference, CapturedStack> STORAGE = new ConcurrentHashMap<WeakReference, CapturedStack>();
    private static final ThreadLocal<Deque<CapturedStack>> CURRENT_STACKS = new ThreadLocal<Deque<CapturedStack>>(){

        @Override
        protected Deque<CapturedStack> initialValue() {
            return new LinkedList<CapturedStack>();
        }
    };
    public static boolean DEBUG;
    private static boolean ENABLED;

    public static void capture(Object key) {
        if (!ENABLED) {
            return;
        }
        try {
            Throwable exception = new Throwable();
            if (DEBUG) {
                System.out.println("capture " + CaptureStorage.getCallerDescriptor(exception) + " - " + key);
            }
            CapturedStack stack = CaptureStorage.createCapturedStack(exception, CURRENT_STACKS.get().peekLast());
            CaptureStorage.processQueue();
            WeakKey keyRef = new WeakKey(key, KEY_REFERENCE_QUEUE);
            STORAGE.put(keyRef, stack);
        }
        catch (Exception e) {
            CaptureStorage.handleException(e);
        }
    }

    public static void insertEnter(Object key) {
        if (!ENABLED) {
            return;
        }
        try {
            CapturedStack stack = (CapturedStack)STORAGE.get(new HardKey(key));
            Deque<CapturedStack> currentStacks = CURRENT_STACKS.get();
            currentStacks.add(stack);
            if (DEBUG) {
                System.out.println("insert " + CaptureStorage.getCallerDescriptor(new Throwable()) + " -> " + key + ", stack saved (" + currentStacks.size() + ")");
            }
        }
        catch (Exception e) {
            CaptureStorage.handleException(e);
        }
    }

    public static void insertExit(Object key) {
        if (!ENABLED) {
            return;
        }
        try {
            Deque<CapturedStack> currentStacks = CURRENT_STACKS.get();
            currentStacks.removeLast();
            if (DEBUG) {
                System.out.println("insert " + CaptureStorage.getCallerDescriptor(new Throwable()) + " <- " + key + ", stack removed (" + currentStacks.size() + ")");
            }
        }
        catch (Exception e) {
            CaptureStorage.handleException(e);
        }
    }

    private static void processQueue() {
        WeakKey key;
        while ((key = (WeakKey)KEY_REFERENCE_QUEUE.poll()) != null) {
            STORAGE.remove(key);
        }
    }

    private static CapturedStack createCapturedStack(Throwable exception, CapturedStack insertMatch) {
        if (insertMatch != null) {
            CapturedStack stack = new DeepCapturedStack(exception, insertMatch);
            if (stack.getRecursionDepth() > 100) {
                ArrayList<StackTraceElement> trace = CaptureStorage.getStackTrace(stack, 500);
                trace.trimToSize();
                stack = new UnwindCapturedStack(trace);
            }
            return stack;
        }
        return new ExceptionCapturedStack(exception);
    }

    public static Object[][] getCurrentCapturedStack(int limit) {
        return CaptureStorage.wrapInArray(CURRENT_STACKS.get().peekLast(), limit);
    }

    public static Object[][] getRelatedStack(Object key, int limit) {
        return CaptureStorage.wrapInArray((CapturedStack)STORAGE.get(new HardKey(key)), limit);
    }

    private static Object[][] wrapInArray(CapturedStack stack, int limit) {
        if (stack == null) {
            return null;
        }
        ArrayList<StackTraceElement> stackTrace = CaptureStorage.getStackTrace(stack, limit);
        Object[][] res = new Object[stackTrace.size()][];
        for (int i = 0; i < stackTrace.size(); ++i) {
            StackTraceElement elem = (StackTraceElement)stackTrace.get(i);
            res[i] = elem == null ? null : new Object[]{elem.getClassName(), elem.getFileName(), elem.getMethodName(), String.valueOf(elem.getLineNumber())};
        }
        return res;
    }

    private static ArrayList<StackTraceElement> getStackTrace(CapturedStack stack, int limit) {
        ArrayList<StackTraceElement> res = new ArrayList<StackTraceElement>();
        while (stack != null && res.size() <= limit) {
            List<StackTraceElement> stackTrace = stack.getStackTrace();
            if (stack instanceof DeepCapturedStack) {
                int depth;
                for (depth = 0; depth < stackTrace.size() && !stackTrace.get(depth).getMethodName().endsWith(GENERATED_INSERT_METHOD_POSTFIX); ++depth) {
                }
                stackTrace = stackTrace.subList(0, depth + 2);
                stack = ((DeepCapturedStack)stack).myInsertMatch;
            } else {
                stack = null;
            }
            res.addAll(stackTrace);
            if (stack == null) continue;
            res.add(null);
        }
        return res;
    }

    public static void setEnabled(boolean enabled) {
        ENABLED = enabled;
    }

    private static void handleException(Throwable e) {
        ENABLED = false;
        System.err.println("Critical error in IDEA Async Stacktraces instrumenting agent. Agent is now disabled. Please report to IDEA support:");
        e.printStackTrace();
    }

    private static String getCallerDescriptor(Throwable e) {
        StackTraceElement caller = e.getStackTrace()[1];
        return caller.getClassName() + "." + caller.getMethodName();
    }

    static {
        ENABLED = true;
    }

    private static class DeepCapturedStack
    extends ExceptionCapturedStack {
        final CapturedStack myInsertMatch;
        final int myRecursionDepth;

        DeepCapturedStack(Throwable exception, CapturedStack insertMatch) {
            super(exception);
            this.myInsertMatch = insertMatch;
            this.myRecursionDepth = insertMatch.getRecursionDepth() + 1;
        }

        @Override
        public int getRecursionDepth() {
            return this.myRecursionDepth;
        }
    }

    private static class ExceptionCapturedStack
    implements CapturedStack {
        final Throwable myException;

        private ExceptionCapturedStack(Throwable exception) {
            this.myException = exception;
        }

        @Override
        public List<StackTraceElement> getStackTrace() {
            StackTraceElement[] stackTrace = this.myException.getStackTrace();
            return Arrays.asList(stackTrace).subList(1, stackTrace.length);
        }

        @Override
        public int getRecursionDepth() {
            return 0;
        }
    }

    private static class UnwindCapturedStack
    implements CapturedStack {
        final List<StackTraceElement> myStackTraceElements;

        UnwindCapturedStack(List<StackTraceElement> elements) {
            this.myStackTraceElements = elements;
        }

        @Override
        public List<StackTraceElement> getStackTrace() {
            return this.myStackTraceElements;
        }

        @Override
        public int getRecursionDepth() {
            return 0;
        }
    }

    private static interface CapturedStack {
        public List<StackTraceElement> getStackTrace();

        public int getRecursionDepth();
    }

    private static class WeakKey
    extends WeakReference {
        private final int myHash;

        WeakKey(Object key, ReferenceQueue q) {
            super(key, q);
            this.myHash = System.identityHashCode(key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeakKey)) {
                return false;
            }
            Object t = this.get();
            Object u = ((WeakKey)o).get();
            if (t == null || u == null) {
                return false;
            }
            return t == u;
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    private static class HardKey {
        private final Object myKey;
        private final int myHash;

        HardKey(Object key) {
            this.myKey = key;
            this.myHash = System.identityHashCode(key);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof WeakKey && ((WeakKey)o).get() == this.myKey;
        }

        public int hashCode() {
            return this.myHash;
        }
    }
}

