/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;

public class MethodParenthesesHandler
extends ParenthesesInsertHandler<LookupElement> {
    private final PsiMethod myMethod;
    private final boolean myOverloadsMatter;

    public MethodParenthesesHandler(PsiMethod method, boolean overloadsMatter) {
        this.myMethod = method;
        this.myOverloadsMatter = overloadsMatter;
    }

    protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
        return MethodParenthesesHandler.hasParams(item, context.getElements(), this.myOverloadsMatter, this.myMethod);
    }

    public static boolean hasParams(LookupElement item, LookupElement[] allItems, boolean overloadsMatter, PsiMethod method) {
        boolean hasParams;
        boolean bl = hasParams = !method.getParameterList().isEmpty();
        if (overloadsMatter) {
            hasParams |= MethodParenthesesHandler.hasOverloads(allItems, method);
        }
        return hasParams;
    }

    private static boolean hasOverloads(LookupElement[] allItems, PsiMethod method) {
        String name = method.getName();
        for (LookupElement another : allItems) {
            PsiElement element = another.getPsiElement();
            if (method == element || !(element instanceof PsiMethod) || !((PsiMethod)element).getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

