/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.lang.Language;
import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationFileCrcFactory {
    private final VirtualFile myFile;

    @Deprecated
    public ConfigurationFileCrcFactory(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ConfigurationFileCrcFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ConfigurationFileCrcFactory.$$$reportNull$$$0(1);
        }
        this(file);
    }

    public ConfigurationFileCrcFactory(VirtualFile file) {
        this.myFile = file;
    }

    public long create() {
        if (this.myFile.isDirectory()) {
            return this.myFile.getModificationStamp();
        }
        WordsScanner wordsScanner = ConfigurationFileCrcFactory.getScanner(this.myFile);
        if (wordsScanner == null) {
            return this.myFile.getModificationStamp();
        }
        CRC32 crc32 = new CRC32();
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
        CharSequence text = document != null ? document.getImmutableCharSequence() : LoadTextUtil.loadText((VirtualFile)this.myFile);
        wordsScanner.processWords(text, occurrence -> {
            if (occurrence.getKind() != WordOccurrence.Kind.COMMENTS) {
                CharSequence currentWord = occurrence.getBaseText().subSequence(occurrence.getStart(), occurrence.getEnd());
                int end = currentWord.length();
                for (int i = 0; i < end; ++i) {
                    crc32.update(currentWord.charAt(i));
                }
            }
            return true;
        });
        return crc32.getValue();
    }

    @Nullable
    private static WordsScanner getScanner(VirtualFile file) {
        FileType fileType = file.getFileType();
        WordsScanner customWordsScanner = CacheBuilderRegistry.getInstance().getCacheBuilder(fileType);
        if (customWordsScanner != null) {
            return customWordsScanner;
        }
        if (fileType instanceof LanguageFileType) {
            Language lang = ((LanguageFileType)fileType).getLanguage();
            return LanguageFindUsages.getWordsScanner((Language)lang);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ConfigurationFileCrcFactory";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

