/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModuleDataService<E extends ModuleData>
extends AbstractProjectDataService<E, Module> {
    public static final Key<ModuleData> MODULE_DATA_KEY = Key.create((String)"MODULE_DATA_KEY");
    public static final Key<Module> MODULE_KEY = Key.create((String)"LINKED_MODULE");
    public static final Key<Map<OrderEntry, OrderAware>> ORDERED_DATA_MAP_KEY = Key.create((String)"ORDER_ENTRY_DATA_MAP");
    private static final Key<Set<Path>> ORPHAN_MODULE_FILES = Key.create((String)"ORPHAN_FILES");
    private static final Key<AtomicInteger> ORPHAN_MODULE_HANDLERS_COUNTER = Key.create((String)"ORPHAN_MODULE_HANDLERS_COUNTER");
    private static final NotificationGroup ORPHAN_MODULE_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Build sync orphan modules", (String)ToolWindowId.BUILD);
    private static final Logger LOG = Logger.getInstance(AbstractModuleDataService.class);

    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Module module;
        if (toImport == null) {
            AbstractModuleDataService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(2);
        }
        if (toImport.isEmpty()) {
            return;
        }
        Collection<DataNode<E>> toCreate = this.filterExistingModules(toImport, modelsProvider);
        if (!toCreate.isEmpty()) {
            this.createModules(toCreate, modelsProvider);
        }
        for (DataNode<E> node : toImport) {
            module = (Module)node.getUserData(MODULE_KEY);
            if (module == null) continue;
            ProjectCoordinate publication = ((ModuleData)node.getData()).getPublication();
            if (publication != null) {
                modelsProvider.registerModulePublication(module, publication);
            }
            String productionModuleId = ((ModuleData)node.getData()).getProductionModuleId();
            modelsProvider.setTestModuleProperties(module, productionModuleId);
            this.setModuleOptions(module, node);
            ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
            AbstractModuleDataService.syncPaths(module, modifiableRootModel, (ModuleData)node.getData());
            if ("JAVA_MODULE".equals(module.getModuleTypeName()) && ExternalSystemApiUtil.isJavaCompatibleIde()) {
                this.setLanguageLevel(modifiableRootModel, (ModuleData)node.getData());
            }
            this.setSdk(modifiableRootModel, (ModuleData)node.getData());
        }
        for (DataNode<E> node : toImport) {
            module = (Module)node.getUserData(MODULE_KEY);
            if (module == null) continue;
            String[] groupPath = ((ModuleData)node.getData()).getIdeModuleGroup();
            ModifiableModuleModel modifiableModel = modelsProvider.getModifiableModuleModel();
            modifiableModel.setModuleGroupPath(module, groupPath);
        }
    }

    private void createModules(@NotNull Collection<DataNode<E>> toCreate, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toCreate == null) {
            AbstractModuleDataService.$$$reportNull$$$0(3);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(4);
        }
        for (DataNode<E> module : toCreate) {
            ModuleData data = (ModuleData)module.getData();
            Module created = modelsProvider.newModule(data);
            module.putUserData(MODULE_KEY, (Object)created);
            final ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(created);
            modifiableRootModel.inheritSdk();
            RootPolicy<Object> visitor = new RootPolicy<Object>(){

                public Object visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, Object value) {
                    if (libraryOrderEntry == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
                    return value;
                }

                public Object visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, Object value) {
                    if (moduleOrderEntry == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    modifiableRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
                    return value;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "libraryOrderEntry";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "moduleOrderEntry";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLibraryOrderEntry";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitModuleOrderEntry";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
                orderEntry.accept((RootPolicy)visitor, null);
            }
        }
    }

    @NotNull
    private Collection<DataNode<E>> filterExistingModules(@NotNull Collection<DataNode<E>> modules, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modules == null) {
            AbstractModuleDataService.$$$reportNull$$$0(5);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(6);
        }
        ArrayList result = ContainerUtilRt.newArrayList();
        for (DataNode<E> node : modules) {
            ModuleData moduleData = (ModuleData)node.getData();
            Module module = modelsProvider.findIdeModule(moduleData);
            if (module == null) {
                UnloadedModuleDescription unloadedModuleDescription = modelsProvider.getUnloadedModuleDescription(moduleData);
                if (unloadedModuleDescription != null) continue;
                result.add(node);
                continue;
            }
            node.putUserData(MODULE_KEY, (Object)module);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            AbstractModuleDataService.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static void syncPaths(@NotNull Module module, @NotNull ModifiableRootModel modifiableModel, @NotNull ModuleData data) {
        CompilerModuleExtension extension;
        if (module == null) {
            AbstractModuleDataService.$$$reportNull$$$0(8);
        }
        if (modifiableModel == null) {
            AbstractModuleDataService.$$$reportNull$$$0(9);
        }
        if (data == null) {
            AbstractModuleDataService.$$$reportNull$$$0(10);
        }
        if ((extension = (CompilerModuleExtension)modifiableModel.getModuleExtension(CompilerModuleExtension.class)) == null) {
            LOG.debug(String.format("No compiler extension is found for '%s', compiler output path will not be synced.", module.getName()));
            return;
        }
        String compileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
        extension.setCompilerOutputPath(compileOutputPath != null ? VfsUtilCore.pathToUrl((String)compileOutputPath) : null);
        String testCompileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.TEST);
        extension.setCompilerOutputPathForTests(testCompileOutputPath != null ? VfsUtilCore.pathToUrl((String)testCompileOutputPath) : null);
        extension.inheritCompilerOutputPath(data.isInheritProjectCompileOutputPath());
    }

    public void removeData(@NotNull Computable<Collection<Module>> toRemoveComputable, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemoveComputable == null) {
            AbstractModuleDataService.$$$reportNull$$$0(11);
        }
        if (toIgnore == null) {
            AbstractModuleDataService.$$$reportNull$$$0(12);
        }
        if (projectData == null) {
            AbstractModuleDataService.$$$reportNull$$$0(13);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(14);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(15);
        }
        Collection toRemove = (Collection)toRemoveComputable.compute();
        SmartList modules = new SmartList(toRemove);
        for (DataNode<E> moduleDataNode : toIgnore) {
            Module module = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            ContainerUtil.addIfNotNull((Collection)modules, (Object)module);
        }
        if (modules.isEmpty()) {
            return;
        }
        ContainerUtil.removeDuplicates((Collection)modules);
        for (Module module : modules) {
            if (module.isDisposed()) continue;
            AbstractModuleDataService.unlinkModuleFromExternalSystem(module);
        }
        ExternalSystemApiUtil.executeOnEdt((boolean)true, () -> AbstractModuleDataService.lambda$removeData$0(project, projectData, (List)modules, modelsProvider));
    }

    public void onSuccessImport(@NotNull Collection<DataNode<E>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        Set orphanModules;
        if (imported == null) {
            AbstractModuleDataService.$$$reportNull$$$0(16);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(17);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(18);
        }
        if ((orphanModules = (Set)project.getUserData(ORPHAN_MODULE_FILES)) == null || orphanModules.isEmpty()) {
            return;
        }
        AtomicInteger counter = (AtomicInteger)project.getUserData(ORPHAN_MODULE_HANDLERS_COUNTER);
        if (counter == null) {
            return;
        }
        if (counter.decrementAndGet() == 0) {
            project.putUserData(ORPHAN_MODULE_FILES, null);
            project.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, null);
            StringBuilder modulesToRestoreText = new StringBuilder();
            ArrayList modulesToRestore = ContainerUtil.newArrayList();
            for (Path modulePath : orphanModules) {
                try {
                    String path = FileUtil.loadFile((File)modulePath.resolveSibling(modulePath.getFileName() + ".path").toFile());
                    modulesToRestoreText.append(FileUtil.getNameWithoutExtension((File)new File(path))).append("\n");
                    modulesToRestore.add(Pair.create((Object)path, (Object)modulePath));
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            String buildSystem = projectData != null ? projectData.getOwner().getReadableName() : "build system";
            String content = ExternalSystemBundle.message((String)"orphan.modules.text", (Object[])new Object[]{buildSystem, StringUtil.shortenTextWithEllipsis((String)modulesToRestoreText.toString(), (int)50, (int)0)});
            Notification cleanUpNotification = ORPHAN_MODULE_NOTIFICATION_GROUP.createNotification(content, NotificationType.INFORMATION).setListener((notification, event) -> {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (AbstractModuleDataService.showRemovedOrphanModules(modulesToRestore, project)) {
                    notification.expire();
                }
            }).whenExpired(() -> {
                List filesToRemove = ContainerUtil.map((Collection)orphanModules, Path::toFile);
                List toRemove2 = ContainerUtil.map((Collection)orphanModules, path -> path.resolveSibling(path.getFileName() + ".path").toFile());
                FileUtil.asyncDelete((Collection)ContainerUtil.concat((List)filesToRemove, (List)toRemove2));
            });
            Disposer.register((Disposable)project, () -> ((Notification)cleanUpNotification).expire());
            cleanUpNotification.notify(project);
        }
    }

    public void onFailureImport(Project project) {
        project.putUserData(ORPHAN_MODULE_FILES, null);
        project.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, null);
    }

    private static boolean showRemovedOrphanModules(@NotNull List<Pair<String, Path>> orphanModules, @NotNull Project project) {
        CheckBoxList orphanModulesList;
        DialogWrapper dialog;
        if (orphanModules == null) {
            AbstractModuleDataService.$$$reportNull$$$0(19);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(20);
        }
        if ((dialog = new DialogWrapper(project, orphanModulesList = new CheckBoxList(), orphanModules){
            final /* synthetic */ CheckBoxList val$orphanModulesList;
            final /* synthetic */ List val$orphanModules;
            {
                this.val$orphanModulesList = checkBoxList;
                this.val$orphanModules = list;
                super(arg0);
                this.setTitle(ExternalSystemBundle.message((String)"orphan.modules.dialog.title", (Object[])new Object[0]));
                this.init();
            }

            protected JComponent createCenterPanel() {
                this.val$orphanModulesList.setSelectionMode(2);
                this.val$orphanModulesList.setItems(this.val$orphanModules, module -> FileUtil.getNameWithoutExtension((File)new File((String)module.getFirst())));
                this.val$orphanModulesList.setBorder(JBUI.Borders.empty((int)5));
                JScrollPane myModulesScrollPane = ScrollPaneFactory.createScrollPane((Component)this.val$orphanModulesList, (int)20, (int)30);
                myModulesScrollPane.setBorder(new MatteBorder(0, 0, 1, 0, JBColor.border()));
                myModulesScrollPane.setMaximumSize(new Dimension(-1, 300));
                JPanel content = new JPanel(new BorderLayout());
                content.add((Component)myModulesScrollPane, "Center");
                return content;
            }

            @NotNull
            protected JComponent createNorthPanel() {
                GridBagConstraints gbConstraints = new GridBagConstraints();
                JPanel panel = new JPanel(new GridBagLayout());
                gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)10, (int)8);
                panel.add((Component)new JLabel(ExternalSystemBundle.message((String)"orphan.modules.dialog.text", (Object[])new Object[0])), gbConstraints);
                JPanel jPanel = panel;
                if (jPanel == null) {
                    2.$$$reportNull$$$0(0);
                }
                return jPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService$2", "createNorthPanel"));
            }
        }).showAndGet()) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                for (int i = 0; i < orphanModules.size(); ++i) {
                    Pair pair = (Pair)orphanModules.get(i);
                    String originalPath = (String)pair.first;
                    Path savedPath = (Path)pair.second;
                    if (!orphanModulesList.isItemSelected(i) || !savedPath.toFile().isFile()) continue;
                    try {
                        FileUtil.copy((File)savedPath.toFile(), (File)new File(originalPath));
                        ModuleManager.getInstance((Project)project).loadModule(originalPath);
                        continue;
                    }
                    catch (ModuleWithNameAlreadyExists | IOException | JDOMException e) {
                        LOG.warn(e);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public static void unlinkModuleFromExternalSystem(@NotNull Module module) {
        if (module == null) {
            AbstractModuleDataService.$$$reportNull$$$0(21);
        }
        ExternalSystemModulePropertyManager.getInstance((Module)module).unlinkExternalOptions();
    }

    protected void setModuleOptions(Module module, DataNode<E> moduleDataNode) {
        ModuleData moduleData = (ModuleData)moduleDataNode.getData();
        module.putUserData(MODULE_DATA_KEY, (Object)moduleData);
        ExternalSystemModulePropertyManager.getInstance((Module)module).setExternalOptions(moduleData.getOwner(), moduleData, (ProjectData)moduleDataNode.getData(ProjectKeys.PROJECT));
    }

    public void postProcess(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            AbstractModuleDataService.$$$reportNull$$$0(22);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(23);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(24);
        }
        for (DataNode<E> moduleDataNode : toImport) {
            Module module = (Module)moduleDataNode.getUserData(MODULE_KEY);
            if (module == null) continue;
            Map orderAwareMap = (Map)moduleDataNode.getUserData(ORDERED_DATA_MAP_KEY);
            if (orderAwareMap != null) {
                this.rearrangeOrderEntries(orderAwareMap, modelsProvider.getModifiableRootModel(module));
            }
            this.setBytecodeTargetLevel(project, module, (ModuleData)moduleDataNode.getData());
            moduleDataNode.putUserData(MODULE_KEY, null);
            moduleDataNode.putUserData(ORDERED_DATA_MAP_KEY, null);
        }
        for (Module module : modelsProvider.getModules()) {
            module.putUserData(MODULE_DATA_KEY, null);
        }
    }

    protected void rearrangeOrderEntries(@NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel modifiableRootModel) {
        Pair pair;
        OrderAware orderAware;
        OrderEntry orderEntry;
        if (orderEntryDataMap == null) {
            AbstractModuleDataService.$$$reportNull$$$0(25);
        }
        if (modifiableRootModel == null) {
            AbstractModuleDataService.$$$reportNull$$$0(26);
        }
        Object[] orderEntries = modifiableRootModel.getOrderEntries();
        int length = orderEntries.length;
        Object[] newOrder = new OrderEntry[length];
        PriorityQueue<Pair> priorityQueue = new PriorityQueue<Pair>(11, (o1, o2) -> {
            int order2;
            int order1 = ((OrderAware)o1.second).getOrder();
            return order1 != (order2 = ((OrderAware)o2.second).getOrder()) ? (order1 < order2 ? -1 : 1) : 0;
        });
        int shift = 0;
        for (int i = 0; i < length; ++i) {
            orderEntry = orderEntries[i];
            orderAware = orderEntryDataMap.get(orderEntry);
            if (orderAware == null) {
                newOrder[i] = orderEntry;
                ++shift;
                continue;
            }
            priorityQueue.add(Pair.create((Object)orderEntry, (Object)orderAware));
        }
        while ((pair = (Pair)priorityQueue.poll()) != null) {
            orderEntry = (OrderEntry)pair.first;
            orderAware = (OrderAware)pair.second;
            int order = orderAware.getOrder() != -1 ? orderAware.getOrder() : length - 1;
            int newPlace = AbstractModuleDataService.findNewPlace((OrderEntry[])newOrder, order - shift);
            assert (newPlace != -1);
            newOrder[newPlace] = orderEntry;
        }
        if (LOG.isDebugEnabled()) {
            boolean changed = !ArrayUtil.equals((Object[])orderEntries, (Object[])newOrder, Comparator.naturalOrder());
            LOG.debug(String.format("rearrange status (%s): %s", modifiableRootModel.getModule(), changed ? "modified" : "not modified"));
        }
        modifiableRootModel.rearrangeOrderEntries((OrderEntry[])newOrder);
    }

    private static int findNewPlace(OrderEntry[] newOrder, int newIndex) {
        int idx;
        for (idx = newIndex; idx < 0 || idx < newOrder.length && newOrder[idx] != null; ++idx) {
        }
        if (idx >= newOrder.length) {
            for (idx = newIndex - 1; idx >= 0 && (idx >= newOrder.length || newOrder[idx] != null); --idx) {
            }
        }
        return idx;
    }

    private void setLanguageLevel(@NotNull ModifiableRootModel modifiableRootModel, E data) {
        LanguageLevel level;
        if (modifiableRootModel == null) {
            AbstractModuleDataService.$$$reportNull$$$0(27);
        }
        if ((level = LanguageLevel.parse((String)data.getSourceCompatibility())) != null) {
            try {
                ((LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    private void setSdk(@NotNull ModifiableRootModel modifiableRootModel, E data) {
        String skdName;
        if (modifiableRootModel == null) {
            AbstractModuleDataService.$$$reportNull$$$0(28);
        }
        if ((skdName = data.getSdkName()) != null) {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            Sdk sdk = projectJdkTable.findJdk(skdName);
            if (sdk != null) {
                modifiableRootModel.setSdk(sdk);
            } else {
                modifiableRootModel.setInvalidSdk(skdName, JavaSdk.getInstance().getName());
            }
        }
    }

    private void setBytecodeTargetLevel(@NotNull Project project, @NotNull Module module, @NotNull E data) {
        String targetLevel;
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(29);
        }
        if (module == null) {
            AbstractModuleDataService.$$$reportNull$$$0(30);
        }
        if (data == null) {
            AbstractModuleDataService.$$$reportNull$$$0(31);
        }
        if ((targetLevel = data.getTargetCompatibility()) != null) {
            CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)project);
            configuration.setBytecodeTargetLevel(module, targetLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$removeData$0(Project project, ProjectData projectData, List modules, IdeModifiableModelsProvider modelsProvider) {
        AtomicInteger counter = (AtomicInteger)project.getUserData(ORPHAN_MODULE_HANDLERS_COUNTER);
        if (counter == null) {
            counter = new AtomicInteger();
            project.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, (Object)counter);
        }
        counter.incrementAndGet();
        Set orphanModules = (Set)project.getUserData(ORPHAN_MODULE_FILES);
        if (orphanModules == null) {
            orphanModules = ContainerUtil.newLinkedHashSet();
            project.putUserData(ORPHAN_MODULE_FILES, (Object)orphanModules);
        }
        LocalHistoryAction historyAction = LocalHistory.getInstance().startAction(ExternalSystemBundle.message((String)"local.history.remove.orphan.modules", (Object[])new Object[0]));
        try {
            String rootProjectPathKey = String.valueOf(projectData.getLinkedExternalProjectPath().hashCode());
            Path unlinkedModulesDir = ExternalProjectsDataStorage.getProjectConfigurationDir(project).resolve("orphanModules").resolve(rootProjectPathKey);
            if (!FileUtil.createDirectory((File)unlinkedModulesDir.toFile())) {
                LOG.warn("Unable to create " + unlinkedModulesDir);
                return;
            }
            AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)project, (ProjectSystemId)projectData.getOwner());
            AbstractExternalSystemLocalSettings.SyncType syncType = (AbstractExternalSystemLocalSettings.SyncType)localSettings.getProjectSyncType().get(projectData.getLinkedExternalProjectPath());
            for (Module module : modules) {
                if (module.isDisposed()) continue;
                String path = module.getModuleFilePath();
                if (!ApplicationManager.getApplication().isHeadlessEnvironment() && syncType == AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT) {
                    try {
                        StateStorageManagerKt.saveComponentManager((ComponentManager)module);
                        VirtualFile moduleFile = module.getModuleFile();
                        if (moduleFile != null) {
                            Path orphanModulePath = unlinkedModulesDir.resolve(String.valueOf(path.hashCode()));
                            FileUtil.writeToFile((File)orphanModulePath.toFile(), (byte[])moduleFile.contentsToByteArray());
                            Path orphanModuleOriginPath = unlinkedModulesDir.resolve(path.hashCode() + ".path");
                            FileUtil.writeToFile((File)orphanModuleOriginPath.toFile(), (String)path);
                            orphanModules.add(orphanModulePath);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
                modelsProvider.getModifiableModuleModel().disposeModule(module);
                ModuleBuilder.deleteModuleFile((String)path);
            }
        }
        finally {
            historyAction.finish();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 1: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 15: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCreate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService";
                break;
            }
            case 8: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModel";
                break;
            }
            case 10: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemoveComputable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imported";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orphanModules";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryDataMap";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExistingModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModules";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterExistingModules";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onSuccessImport";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showRemovedOrphanModules";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unlinkModuleFromExternalSystem";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "rearrangeOrderEntries";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setSdk";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setBytecodeTargetLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

