/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTextUtil;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.refactoring.rename.YamlKeyValueRenameInputValidator;

public class YAMLCopyPasteProcessor
implements CopyPastePreProcessor {
    private static final String CONFIG_KEY_SEQUENCE_PATTERN = "\\.*([^\\s{}\\[\\].][^\\s.]*\\.)+[^\\s{}\\[\\].][^\\s.]*:?\\s*";

    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int lineNumber;
        int lineStartOffset;
        int indent;
        if (file.getLanguage() != YAMLLanguage.INSTANCE) {
            String string = text;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        Document document = editor.getDocument();
        int caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretModel.getOffset();
        String specialKeyPaste = YAMLCopyPasteProcessor.tryToPasteAsKeySequence(text, file, editor, caretOffset, indent = caretOffset - (lineStartOffset = YAMLTextUtil.getLineStartSafeOffset(document, lineNumber = document.getLineNumber(caretOffset))));
        if (specialKeyPaste != null) {
            String string = specialKeyPaste;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (indent == 0) {
            String string = text;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = YAMLCopyPasteProcessor.indentText(text, StringUtil.repeatSymbol((char)' ', (int)indent));
        if (string == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String indentText(@NotNull String text, @NotNull String curLineIndent) {
        List lines;
        if (text == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        if (curLineIndent == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        if ((lines = LineTokenizer.tokenizeIntoList((CharSequence)text, (boolean)false, (boolean)false)).isEmpty()) {
            String string = text;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }
        int minIndent = YAMLCopyPasteProcessor.calculateMinBlockIndent(lines);
        String firstLine = (String)lines.iterator().next();
        if (lines.size() == 1) {
            String string = firstLine;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = firstLine.substring(YAMLTextUtil.getStartIndentSize(firstLine)) + "\n" + lines.stream().skip(1L).map(line -> {
            if (YAMLCopyPasteProcessor.isEmptyLine(line)) {
                return curLineIndent + line.substring(minIndent);
            }
            return "";
        }).reduce((left, right) -> left + "\n" + right).orElse("");
        if (string == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static int calculateMinBlockIndent(@NotNull List<String> list) {
        if (list == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(9);
        }
        Iterator<String> it = list.iterator();
        String str = "";
        while (it.hasNext() && !YAMLCopyPasteProcessor.isEmptyLine(str = it.next())) {
        }
        if (!it.hasNext()) {
            return 0;
        }
        int minIndent = YAMLTextUtil.getStartIndentSize(str);
        while (it.hasNext()) {
            str = it.next();
            if (!YAMLCopyPasteProcessor.isEmptyLine(str)) continue;
            minIndent = Math.min(minIndent, YAMLTextUtil.getStartIndentSize(str));
        }
        return minIndent;
    }

    private static boolean isEmptyLine(@NotNull String str) {
        if (str == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        return YAMLTextUtil.getStartIndentSize(str) < str.length();
    }

    @Nullable
    private static String tryToPasteAsKeySequence(@NotNull String text, @NotNull PsiFile file, @NotNull Editor editor, int caretOffset, int indent) {
        String result;
        if (text == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        if (file == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        if (!text.matches(CONFIG_KEY_SEQUENCE_PATTERN)) {
            return null;
        }
        List<String> keys = YAMLCopyPasteProcessor.separateCompositeKey(text);
        assert (!keys.isEmpty());
        for (String key : keys) {
            if (YamlKeyValueRenameInputValidator.IDENTIFIER_PATTERN.matcher(key).matches()) continue;
            return null;
        }
        PsiElement element = file.findElementAt(caretOffset);
        if (element != null && (result = YAMLCopyPasteProcessor.tryToPasteAsKeySequenceAtMapping(editor, keys, element, caretOffset, indent)) != null) {
            return result;
        }
        if ((element == null || element.getTextRange().getStartOffset() == caretOffset) && caretOffset > 0 && (element = file.findElementAt(caretOffset - 1)) != null) {
            int parentIndent;
            result = YAMLCopyPasteProcessor.tryToPasteAsKeySequenceAtMapping(editor, keys, element, caretOffset, indent);
            if (result != null) {
                return result;
            }
            YAMLKeyValue keyValue = YAMLCopyPasteProcessor.getPreviousKeyValuePairBeforeEOL(element);
            if (keyValue != null && keyValue.getValue() == null && indent > (parentIndent = YAMLUtil.getIndentToThisElement((PsiElement)keyValue))) {
                return YAMLElementGenerator.createChainedKey(keys, indent);
            }
        }
        return null;
    }

    @Nullable
    private static YAMLKeyValue getPreviousKeyValuePairBeforeEOL(@NotNull PsiElement element) {
        PsiElement cur;
        if (element == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        if (PsiUtilCore.getElementType((PsiElement)element.getParent()) != YAMLElementTypes.MAPPING) {
            return null;
        }
        boolean eolMet = false;
        for (cur = element; cur != null && YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)cur)); cur = cur.getPrevSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)cur) != YAMLTokenTypes.EOL) continue;
            eolMet = true;
        }
        if (eolMet && PsiUtilCore.getElementType((PsiElement)cur) == YAMLElementTypes.KEY_VALUE_PAIR) {
            return (YAMLKeyValue)cur;
        }
        return null;
    }

    @Nullable
    private static String tryToPasteAsKeySequenceAtMapping(@NotNull Editor editor, @NotNull List<String> keys, @NotNull PsiElement element, int caretOffset, int indent) {
        if (editor == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(15);
        }
        if (keys == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(16);
        }
        if (element == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(17);
        }
        while (true) {
            YAMLKeyValue keyValue;
            YAMLBlockMappingImpl blockMapping;
            if (element.getParent() instanceof YAMLFile) {
                PsiElement prev = element.getPrevSibling();
                if (!(prev instanceof YAMLDocument)) {
                    return null;
                }
                element = ((YAMLDocument)prev).getTopLevelValue();
                if (!(element instanceof YAMLBlockMappingImpl)) {
                    return null;
                }
                blockMapping = (YAMLBlockMappingImpl)element;
            } else {
                blockMapping = (YAMLBlockMappingImpl)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLBlockMappingImpl.class);
            }
            if (blockMapping == null) {
                return null;
            }
            int mappingIndent = YAMLUtil.getIndentToThisElement((PsiElement)blockMapping);
            if (mappingIndent == indent && (keyValue = (YAMLKeyValue)ApplicationManager.getApplication().runWriteAction(() -> {
                YAMLKeyValue lastKeyVal = blockMapping.getOrCreateKeySequence(keys, caretOffset);
                if (lastKeyVal == null) {
                    return null;
                }
                ASTNode colon = lastKeyVal.getNode().findChildByType((IElementType)YAMLTokenTypes.COLON);
                if (colon != null) {
                    int newOffset = colon.getTextRange().getEndOffset();
                    editor.getCaretModel().moveToOffset(newOffset);
                }
                return lastKeyVal;
            })) != null) {
                return "";
            }
            element = blockMapping;
        }
    }

    @NotNull
    private static List<String> separateCompositeKey(@NotNull String text) {
        if (text == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(18);
        }
        text = text.trim();
        text = StringUtil.trimEnd((String)text, (char)':');
        int leadingDotsNumber = StringUtil.countChars((CharSequence)text, (char)'.', (int)0, (boolean)true);
        String dotPrefix = text.substring(0, leadingDotsNumber);
        text = text.substring(leadingDotsNumber);
        List sequence = StringUtil.split((String)text, (String)".");
        if (!dotPrefix.isEmpty() && sequence.size() > 0) {
            sequence.set(0, dotPrefix + (String)sequence.get(0));
        }
        List list = sequence;
        if (list == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/formatter/YAMLCopyPasteProcessor";
                break;
            }
            case 4: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curLineIndent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/formatter/YAMLCopyPasteProcessor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "indentText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "separateCompositeKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indentText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateMinBlockIndent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyLine";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryToPasteAsKeySequence";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousKeyValuePairBeforeEOL";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryToPasteAsKeySequenceAtMapping";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "separateCompositeKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

