/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;

public class JavaTestUtil {
    private static final String TEST_JDK_NAME = "JDK";

    public static String getJavaTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    public static String getRelativeJavaTestDataPath() {
        String absolute = JavaTestUtil.getJavaTestDataPath();
        return StringUtil.trimStart((String)absolute, (String)PathManager.getHomePath());
    }

    public static void setupTestJDK(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JavaTestUtil.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
            Sdk jdk = jdkTable.findJdk(TEST_JDK_NAME);
            if (jdk != null) {
                jdkTable.removeJdk(jdk);
            }
            jdkTable.addJdk(JavaTestUtil.getTestJdk(), parentDisposable);
        });
    }

    public static Sdk getTestJdk() {
        try {
            ProjectJdkImpl jdk = (ProjectJdkImpl)JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk().clone();
            jdk.setName(TEST_JDK_NAME);
            return jdk;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static LanguageLevel getMaxRegisteredLanguageLevel() {
        LanguageLevel[] values = LanguageLevel.values();
        return values[values.length - 1];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/JavaTestUtil", "setupTestJDK"));
    }
}

