/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class CompilerPaths {
    private static final Logger LOG = Logger.getInstance(CompilerPaths.class);

    public static File getGeneratedDataDirectory(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project), ".generated");
    }

    public static File getCacheStoreDirectory(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project), ".caches");
    }

    @NotNull
    public static File getCompilerSystemDirectory(@NotNull Project project) {
        if (project == null) {
            CompilerPaths.$$$reportNull$$$0(0);
        }
        File file = ProjectUtil.getProjectCachePath((Project)project, (String)"compiler").toFile();
        if (file == null) {
            CompilerPaths.$$$reportNull$$$0(1);
        }
        return file;
    }

    @Nullable
    public static VirtualFile getModuleOutputDirectory(@NotNull Module module, boolean forTestClasses) {
        VirtualFile path;
        CompilerModuleExtension compilerModuleExtension;
        if (module == null) {
            CompilerPaths.$$$reportNull$$$0(2);
        }
        if ((compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module)) == null) {
            return null;
        }
        VirtualFile outPath = forTestClasses ? ((path = compilerModuleExtension.getCompilerOutputPathForTests()) != null ? path : compilerModuleExtension.getCompilerOutputPath()) : compilerModuleExtension.getCompilerOutputPath();
        if (outPath == null) {
            return null;
        }
        if (!outPath.isValid()) {
            LOG.info("Requested output path for module " + module.getName() + " is not valid");
            return null;
        }
        return outPath;
    }

    @Nullable
    public static String getModuleOutputPath(Module module, boolean forTestClasses) {
        String url;
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        String outPathUrl = forTestClasses ? (application.isDispatchThread() ? ((url = extension.getCompilerOutputUrlForTests()) != null ? url : extension.getCompilerOutputUrl()) : (String)ReadAction.compute(() -> {
            String url = extension.getCompilerOutputUrlForTests();
            return url != null ? url : extension.getCompilerOutputUrl();
        })) : (application.isDispatchThread() ? extension.getCompilerOutputUrl() : (String)ReadAction.compute(() -> extension.getCompilerOutputUrl()));
        return outPathUrl != null ? VirtualFileManager.extractPath((String)outPathUrl) : null;
    }

    @Nullable
    public static String getAnnotationProcessorsGenerationPath(Module module, boolean forTests) {
        AnnotationProcessingConfiguration config = CompilerConfiguration.getInstance(module.getProject()).getAnnotationProcessingConfiguration(module);
        String sourceDirName = config.getGeneratedSourcesDirectoryName(forTests);
        if (config.isOutputRelativeToContentRoot()) {
            Object[] roots = ModuleRootManager.getInstance((Module)module).getContentRootUrls();
            if (roots.length == 0) {
                return null;
            }
            if (roots.length > 1) {
                Arrays.sort(roots);
            }
            return StringUtil.isEmpty((String)sourceDirName) ? VirtualFileManager.extractPath((String)roots[0]) : VirtualFileManager.extractPath((String)roots[0]) + "/" + sourceDirName;
        }
        String path = CompilerPaths.getModuleOutputPath(module, forTests);
        if (path == null) {
            return null;
        }
        return StringUtil.isEmpty((String)sourceDirName) ? path : path + "/" + sourceDirName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/CompilerPaths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/CompilerPaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerSystemDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerSystemDirectory";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleOutputDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

