/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import com.sun.tools.javac.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;

public class IdeaTestUtil
extends PlatformTestUtil {
    private static final String MOCK_JDK_DIR_NAME_PREFIX = "mockJDK-";

    public static void printDetectedPerformanceTimings() {
        System.out.println(Timings.getStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLevel(@NotNull Module module, @NotNull LanguageLevel level, @NotNull Runnable r) {
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(0);
        }
        if (level == null) {
            IdeaTestUtil.$$$reportNull$$$0(1);
        }
        if (r == null) {
            IdeaTestUtil.$$$reportNull$$$0(2);
        }
        LanguageLevelProjectExtension projectExt = LanguageLevelProjectExtension.getInstance((Project)module.getProject());
        LanguageLevel projectLevel = projectExt.getLanguageLevel();
        LanguageLevel moduleLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        try {
            projectExt.setLanguageLevel(level);
            IdeaTestUtil.setModuleLanguageLevel(module, level);
            r.run();
        }
        finally {
            IdeaTestUtil.setModuleLanguageLevel(module, moduleLevel);
            projectExt.setLanguageLevel(projectLevel);
        }
    }

    public static void setModuleLanguageLevel(@NotNull Module module, @Nullable LanguageLevel level) {
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(3);
        }
        LanguageLevelModuleExtensionImpl modifiable = (LanguageLevelModuleExtensionImpl)LanguageLevelModuleExtensionImpl.getInstance((Module)module).getModifiableModel(true);
        modifiable.setLanguageLevel(level);
        modifiable.commit();
    }

    public static void setModuleLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level, @NotNull Disposable parentDisposable) {
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(4);
        }
        if (level == null) {
            IdeaTestUtil.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            IdeaTestUtil.$$$reportNull$$$0(6);
        }
        LanguageLevel prev = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        IdeaTestUtil.setModuleLanguageLevel(module, level);
        Disposer.register((Disposable)parentDisposable, () -> IdeaTestUtil.setModuleLanguageLevel(module, prev));
    }

    @NotNull
    public static Sdk getMockJdk(@NotNull JavaVersion version) {
        if (version == null) {
            IdeaTestUtil.$$$reportNull$$$0(7);
        }
        int mockJdk = version.feature >= 11 ? 11 : (version.feature >= 9 ? 9 : (version.feature >= 7 ? version.feature : (version.feature >= 5 ? 7 : 4)));
        String path = IdeaTestUtil.getPathForJdkNamed(MOCK_JDK_DIR_NAME_PREFIX + (mockJdk < 11 ? "1." : "") + mockJdk).getPath();
        Sdk sdk = IdeaTestUtil.createMockJdk("java " + version, path);
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(8);
        }
        return sdk;
    }

    @NotNull
    private static Sdk createMockJdk(@NotNull String name, @NotNull String path) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(9);
        }
        if (path == null) {
            IdeaTestUtil.$$$reportNull$$$0(10);
        }
        Sdk sdk = ((JavaSdkImpl)JavaSdk.getInstance()).createMockJdk(name, path, false);
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(11);
        }
        return sdk;
    }

    @NotNull
    public static Sdk getMockJdk14() {
        Sdk sdk = IdeaTestUtil.getMockJdk(JavaVersion.compose((int)4));
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(12);
        }
        return sdk;
    }

    @NotNull
    public static Sdk getMockJdk17() {
        Sdk sdk = IdeaTestUtil.getMockJdk(JavaVersion.compose((int)7));
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(13);
        }
        return sdk;
    }

    @NotNull
    public static Sdk getMockJdk17(@NotNull String name) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(14);
        }
        Sdk sdk = IdeaTestUtil.createMockJdk(name, IdeaTestUtil.getMockJdk17Path().getPath());
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(15);
        }
        return sdk;
    }

    @NotNull
    public static Sdk getMockJdk18() {
        Sdk sdk = IdeaTestUtil.getMockJdk(JavaVersion.compose((int)8));
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(16);
        }
        return sdk;
    }

    @NotNull
    public static Sdk getMockJdk9() {
        Sdk sdk = IdeaTestUtil.getMockJdk(JavaVersion.compose((int)9));
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(17);
        }
        return sdk;
    }

    @NotNull
    public static File getMockJdk14Path() {
        File file = IdeaTestUtil.getPathForJdkNamed("mockJDK-1.4");
        if (file == null) {
            IdeaTestUtil.$$$reportNull$$$0(18);
        }
        return file;
    }

    @NotNull
    public static File getMockJdk17Path() {
        File file = IdeaTestUtil.getPathForJdkNamed("mockJDK-1.7");
        if (file == null) {
            IdeaTestUtil.$$$reportNull$$$0(19);
        }
        return file;
    }

    @NotNull
    public static File getMockJdk18Path() {
        File file = IdeaTestUtil.getPathForJdkNamed("mockJDK-1.8");
        if (file == null) {
            IdeaTestUtil.$$$reportNull$$$0(20);
        }
        return file;
    }

    @NotNull
    public static File getMockJdk9Path() {
        File file = IdeaTestUtil.getPathForJdkNamed("mockJDK-1.9");
        if (file == null) {
            IdeaTestUtil.$$$reportNull$$$0(21);
        }
        return file;
    }

    public static String getMockJdkVersion(@NotNull String path) {
        String name;
        if (path == null) {
            IdeaTestUtil.$$$reportNull$$$0(22);
        }
        if ((name = PathUtil.getFileName((String)path)).startsWith(MOCK_JDK_DIR_NAME_PREFIX)) {
            return "java " + StringUtil.trimStart((String)name, (String)MOCK_JDK_DIR_NAME_PREFIX);
        }
        return null;
    }

    @NotNull
    private static File getPathForJdkNamed(@NotNull String name) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(23);
        }
        File file = new File(PathManager.getCommunityHomePath(), "java/" + name);
        if (file == null) {
            IdeaTestUtil.$$$reportNull$$$0(24);
        }
        return file;
    }

    @NotNull
    public static Sdk getWebMockJdk17() {
        Sdk jdk = IdeaTestUtil.getMockJdk17();
        Sdk sdk = jdk = IdeaTestUtil.addWebJarsTo(jdk);
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(25);
        }
        return sdk;
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addWebJarsTo(@NotNull Sdk jdk) {
        if (jdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(26);
        }
        try {
            jdk = (Sdk)jdk.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/jsp-api.jar"), OrderRootType.CLASSES);
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/servlet-api.jar"), OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        Sdk sdk = jdk;
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(27);
        }
        return sdk;
    }

    @NotNull
    private static VirtualFile findJar(@NotNull String name) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(28);
        }
        String path = PathManager.getHomePath() + '/' + name;
        VirtualFile file = VfsTestUtil.findFileByCaseSensitivePath((String)path);
        VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        assert (jar != null) : "no .jar for: " + path;
        VirtualFile virtualFile = jar;
        if (virtualFile == null) {
            IdeaTestUtil.$$$reportNull$$$0(29);
        }
        return virtualFile;
    }

    public static void setTestVersion(@NotNull JavaSdkVersion testVersion, @NotNull Module module, @NotNull Disposable parentDisposable) {
        if (testVersion == null) {
            IdeaTestUtil.$$$reportNull$$$0(30);
        }
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(31);
        }
        if (parentDisposable == null) {
            IdeaTestUtil.$$$reportNull$$$0(32);
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        Assert.assertNotNull((Object)sdk);
        String oldVersionString = sdk.getVersionString();
        ((SdkModificator)sdk).setVersionString(testVersion.getDescription());
        Assert.assertSame((Object)testVersion, (Object)JavaSdk.getInstance().getVersion(sdk));
        Disposer.register((Disposable)parentDisposable, () -> ((SdkModificator)sdk).setVersionString(oldVersionString));
    }

    @NotNull
    public static String requireRealJdkHome() {
        String javaHome = SystemProperties.getJavaHome();
        List paths = ContainerUtil.packNullables((Object[])new String[]{javaHome, new File(javaHome).getParent(), System.getenv("JDK_16_x64"), System.getenv("JDK_16")});
        for (String path : paths) {
            if (!JdkUtil.checkForJdk((String)path)) continue;
            String string = path;
            if (string == null) {
                IdeaTestUtil.$$$reportNull$$$0(33);
            }
            return string;
        }
        Assume.assumeTrue((String)("Cannot find JDK, checked paths: " + paths), (boolean)false);
        if (null == null) {
            IdeaTestUtil.$$$reportNull$$$0(34);
        }
        return null;
    }

    @NotNull
    public static File findSourceFile(@NotNull String basePath) {
        File testFile;
        if (basePath == null) {
            IdeaTestUtil.$$$reportNull$$$0(35);
        }
        if (!(testFile = new File(basePath + ".java")).exists()) {
            testFile = new File(basePath + ".groovy");
        }
        if (!testFile.exists()) {
            throw new IllegalArgumentException("No test source for " + basePath);
        }
        File file = testFile;
        if (file == null) {
            IdeaTestUtil.$$$reportNull$$$0(36);
        }
        return file;
    }

    public static void compileFile(@NotNull File source, @NotNull File out, String ... options) {
        if (source == null) {
            IdeaTestUtil.$$$reportNull$$$0(37);
        }
        if (out == null) {
            IdeaTestUtil.$$$reportNull$$$0(38);
        }
        if (options == null) {
            IdeaTestUtil.$$$reportNull$$$0(39);
        }
        Assert.assertTrue((String)("source does not exist: " + source.getPath()), (boolean)source.isFile());
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        args.add(out.getAbsolutePath());
        ContainerUtil.addAll(args, (Object[])options);
        args.add(source.getAbsolutePath());
        if (source.getName().endsWith(".groovy")) {
            try {
                FileSystemCompiler.commandLineCompile((String[])ArrayUtil.toStringArray(args));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            int result = Main.compile(ArrayUtil.toStringArray(args));
            if (result != 0) {
                throw new IllegalStateException("javac failed with exit code " + result);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 6: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/IdeaTestUtil";
                break;
            }
            case 9: 
            case 14: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testVersion";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/IdeaTestUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdk";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createMockJdk";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdk14";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdk17";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdk18";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdk9";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdk14Path";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdk17Path";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdk18Path";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdk9Path";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForJdkNamed";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebMockJdk17";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "addWebJarsTo";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findJar";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "requireRealJdkHome";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLevel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setModuleLanguageLevel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdk";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 36: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createMockJdk";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdk17";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdkVersion";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPathForJdkNamed";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addWebJarsTo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findJar";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setTestVersion";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFile";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "compileFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

