/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.yaml.snakeyaml.representer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.org.yaml.snakeyaml.DumperOptions;
import org.gradle.internal.impldep.org.yaml.snakeyaml.error.YAMLException;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.MappingNode;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.Node;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.NodeTuple;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.ScalarNode;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.SequenceNode;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.Tag;
import org.gradle.internal.impldep.org.yaml.snakeyaml.representer.Represent;
import org.gradle.internal.impldep.org.yaml.snakeyaml.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRepresenter {
    protected final Map<Class, Represent> representers = new HashMap<Class, Represent>();
    protected Represent nullRepresenter;
    protected final Map<Class, Represent> multiRepresenters = new HashMap<Class, Represent>();
    private Character defaultStyle;
    protected Boolean defaultFlowStyle;
    protected final Map<Object, Node> representedObjects = new IdentityHashMap<Object, Node>();
    private final Set<Object> objectKeeper = new HashSet<Object>();
    protected Object objectToRepresent;

    public void represent(Serializer serializer, Object data) throws IOException {
        Node node = this.representData(data);
        serializer.serialize(node);
        this.representedObjects.clear();
        this.objectKeeper.clear();
        this.objectToRepresent = null;
    }

    protected Node representData(Object data) {
        Node node;
        this.objectToRepresent = data;
        if (!this.ignoreAliases(data) && this.representedObjects.containsKey(this.objectToRepresent)) {
            Node node2 = this.representedObjects.get(this.objectToRepresent);
            return node2;
        }
        if (data == null) {
            Node node3 = this.nullRepresenter.representData(data);
            return node3;
        }
        Class<?> clazz = data.getClass();
        if (this.representers.containsKey(clazz)) {
            Represent representer = this.representers.get(clazz);
            node = representer.representData(data);
        } else {
            Represent representer;
            for (Class repr : this.multiRepresenters.keySet()) {
                if (!repr.isInstance(data)) continue;
                Represent representer2 = this.multiRepresenters.get(repr);
                Node node4 = representer2.representData(data);
                return node4;
            }
            if (clazz.isArray()) {
                throw new YAMLException("Arrays of primitives are not fully supported.");
            }
            if (this.multiRepresenters.containsKey(null)) {
                representer = this.multiRepresenters.get(null);
                node = representer.representData(data);
            } else {
                representer = this.representers.get(null);
                node = representer.representData(data);
            }
        }
        return node;
    }

    protected Node representScalar(Tag tag, String value, Character style) {
        if (style == null) {
            style = this.defaultStyle;
        }
        ScalarNode node = new ScalarNode(tag, value, null, null, style);
        this.representedObjects.put(this.objectToRepresent, node);
        return node;
    }

    protected Node representScalar(Tag tag, String value) {
        return this.representScalar(tag, value, null);
    }

    protected Node representSequence(Tag tag, List<? extends Object> sequence, Boolean flowStyle) {
        ArrayList<Node> value = new ArrayList<Node>(sequence.size());
        SequenceNode node = new SequenceNode(tag, value, flowStyle);
        this.representedObjects.put(this.objectToRepresent, node);
        boolean bestStyle = true;
        for (Object object : sequence) {
            Node nodeItem = this.representData(object);
            if (!(nodeItem instanceof ScalarNode) || ((ScalarNode)nodeItem).getStyle() != null) {
                bestStyle = false;
            }
            value.add(nodeItem);
        }
        if (flowStyle == null) {
            if (this.defaultFlowStyle != null) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }

    protected Node representMapping(Tag tag, Map<? extends Object, Object> mapping, Boolean flowStyle) {
        ArrayList<NodeTuple> value = new ArrayList<NodeTuple>(mapping.size());
        MappingNode node = new MappingNode(tag, value, flowStyle);
        this.representedObjects.put(this.objectToRepresent, node);
        boolean bestStyle = true;
        for (Object object : mapping.keySet()) {
            Object itemValue = mapping.get(object);
            Node nodeKey = this.representData(object);
            Node nodeValue = this.representData(itemValue);
            if (!(nodeKey instanceof ScalarNode) || ((ScalarNode)nodeKey).getStyle() != null) {
                bestStyle = false;
            }
            if (!(nodeValue instanceof ScalarNode) || ((ScalarNode)nodeValue).getStyle() != null) {
                bestStyle = false;
            }
            value.add(new NodeTuple(nodeKey, nodeValue));
        }
        if (flowStyle == null) {
            if (this.defaultFlowStyle != null) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }

    protected abstract boolean ignoreAliases(Object var1);

    public void setDefaultScalarStyle(DumperOptions.ScalarStyle defaultStyle) {
        this.defaultStyle = defaultStyle.getChar();
    }

    public void setDefaultFlowStyle(DumperOptions.FlowStyle defaultFlowStyle) {
        this.defaultFlowStyle = defaultFlowStyle.getStyleBoolean();
    }
}

