/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectImportNotificationListener
extends ExternalSystemTaskNotificationListenerAdapter {
    public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
        Project project;
        if (id == null) {
            GradleProjectImportNotificationListener.$$$reportNull$$$0(0);
        }
        if (text == null) {
            GradleProjectImportNotificationListener.$$$reportNull$$$0(1);
        }
        if (!stdOut && !StringUtil.isEmpty((String)text) && GradleConstants.SYSTEM_ID.getId().equals(id.getProjectSystemId().getId()) && id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT && (project = id.findProject()) != null && StringUtil.startsWith((CharSequence)text, (CharSequence)"<ij_msg_gr>")) {
            String group = GradleProjectImportNotificationListener.substringBetween(text, "<ij_msg_gr>", "<ij_msg_gr>");
            if (StringUtil.isEmpty((String)group)) {
                return;
            }
            int start = "<ij_msg_gr>".length() * 2 + group.length();
            String path = null;
            String errorMessage = text.substring(start);
            if (StringUtil.startsWith((CharSequence)errorMessage, (CharSequence)"<ij_nav>") && !StringUtil.isEmpty((String)(path = GradleProjectImportNotificationListener.substringBetween(errorMessage, "<ij_nav>", "<ij_nav>")))) {
                start += "<ij_nav>".length() * 2 + path.length();
            }
            errorMessage = text.substring(start).replaceAll("<eol>", "\n");
            NotificationData notification = new NotificationData(group, errorMessage, StringUtil.equals((CharSequence)"Performance statistics", (CharSequence)group) ? NotificationCategory.INFO : NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            if (path != null) {
                notification.setNavigatable((Navigatable)new MyNavigatable(new File(path), project));
            }
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(id.getProjectSystemId(), notification);
        }
    }

    @Nullable
    private static String substringBetween(@NotNull String str, @NotNull String open, @NotNull String close) {
        int start;
        if (str == null) {
            GradleProjectImportNotificationListener.$$$reportNull$$$0(2);
        }
        if (open == null) {
            GradleProjectImportNotificationListener.$$$reportNull$$$0(3);
        }
        if (close == null) {
            GradleProjectImportNotificationListener.$$$reportNull$$$0(4);
        }
        if ((start = str.indexOf(open)) == -1) {
            return null;
        }
        int end = str.indexOf(close, start + open.length());
        return end != -1 ? str.substring(start + open.length(), end) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "open";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "close";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectImportNotificationListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onTaskOutput";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "substringBetween";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyNavigatable
    implements Navigatable {
        @NotNull
        private final File myFile;
        @NotNull
        private final Project myProject;
        private volatile Navigatable openFileDescriptor;

        MyNavigatable(@NotNull File file, @NotNull Project project) {
            if (file == null) {
                MyNavigatable.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyNavigatable.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.myProject = project;
        }

        public void navigate(boolean requestFocus) {
            VirtualFile virtualFile;
            Navigatable fileDescriptor = this.openFileDescriptor;
            if (fileDescriptor == null && (virtualFile = ExternalSystemUtil.findLocalFileByPath((String)this.myFile.getPath())) != null) {
                this.openFileDescriptor = fileDescriptor = PsiNavigationSupport.getInstance().createNavigatable(this.myProject, virtualFile, -1);
            }
            if (fileDescriptor != null && fileDescriptor.canNavigate()) {
                fileDescriptor.navigate(requestFocus);
            }
        }

        public boolean canNavigate() {
            return this.myFile.exists();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectImportNotificationListener$MyNavigatable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

