/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildView;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ViewManager;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowId;
import icons.MavenIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.BuildToolConsoleProcessAdapter;
import org.jetbrains.idea.maven.buildtool.MavenBuildEventProcessor;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenConsoleImpl;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@ApiStatus.Experimental
public class BuildViewMavenConsole
extends MavenConsole {
    private final MavenBuildEventProcessor myEventParser;
    @NotNull
    private final Project myProject;
    @Nullable
    private final BuildView myBuildView;
    @NotNull
    private final String myTitle;
    private final long myExecutionId;

    public BuildViewMavenConsole(@NotNull Project project, @NotNull String title, @NotNull String workingDir, @NotNull String toolWindowId, long executionId) {
        BuildProgressListener buildProgressListener;
        if (project == null) {
            BuildViewMavenConsole.$$$reportNull$$$0(0);
        }
        if (title == null) {
            BuildViewMavenConsole.$$$reportNull$$$0(1);
        }
        if (workingDir == null) {
            BuildViewMavenConsole.$$$reportNull$$$0(2);
        }
        if (toolWindowId == null) {
            BuildViewMavenConsole.$$$reportNull$$$0(3);
        }
        super(BuildViewMavenConsole.getSettings(project).getOutputLevel(), BuildViewMavenConsole.getSettings(project).isPrintErrorStackTraces());
        this.myProject = project;
        this.myTitle = title;
        this.myExecutionId = executionId;
        ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project);
        DefaultBuildDescriptor descriptor = new DefaultBuildDescriptor((Object)taskId, "Run Maven task", workingDir, System.currentTimeMillis());
        if (ToolWindowId.BUILD.equals(toolWindowId)) {
            this.myBuildView = null;
            buildProgressListener = (BuildProgressListener)ServiceManager.getService((Project)project, BuildViewManager.class);
        } else if (ToolWindowId.RUN.equals(toolWindowId)) {
            ConsoleView console = MavenConsoleImpl.createConsoleBuilder(project).getConsole();
            this.myBuildView = BuildViewMavenConsole.createBuildView(project, (ExecutionConsole)console, (BuildDescriptor)descriptor);
            buildProgressListener = this.myBuildView;
        } else {
            throw new AssertionError((Object)("Unsupported toolwindow id: " + toolWindowId));
        }
        this.myEventParser = new MavenBuildEventProcessor(project, workingDir, buildProgressListener, (BuildDescriptor)descriptor, taskId);
    }

    @Override
    public void attachToProcess(ProcessHandler processHandler) {
        processHandler.addProcessListener((ProcessListener)new BuildToolConsoleProcessAdapter(this.myEventParser));
        if (this.myBuildView != null) {
            this.myBuildView.attachToProcess(processHandler);
            ApplicationManager.getApplication().invokeLater(() -> {
                DefaultActionGroup actions = new DefaultActionGroup();
                actions.addAll(this.myBuildView.getSwitchActions());
                JComponent consolePanel = BuildViewMavenConsole.createConsolePanel((ConsoleView)this.myBuildView, (ActionGroup)actions);
                RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)this.myBuildView, processHandler, consolePanel, this.myTitle, MavenIcons.MavenLogo);
                descriptor.setExecutionId(this.myExecutionId);
                Disposer.register((Disposable)descriptor, (Disposable)this.myBuildView);
                ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(DefaultRunExecutor.getRunExecutorInstance(), descriptor);
            });
        }
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public boolean isOutputPaused() {
        return false;
    }

    @Override
    public void setOutputPaused(boolean outputPaused) {
    }

    @Override
    public void finish() {
        this.myEventParser.finish();
    }

    @Override
    public void printException(Throwable throwable) {
        super.printException(throwable);
        this.myEventParser.notifyException(throwable);
    }

    @Override
    protected void doPrint(String text, MavenConsole.OutputType type) {
        this.myEventParser.onTextAvailable(text, type == MavenConsole.OutputType.ERROR);
    }

    private static JComponent createConsolePanel(ConsoleView view, ActionGroup actions) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)view.getComponent(), "Center");
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("MavenConsole", actions, false);
        JComponent toolbar = actionToolbar.getComponent();
        panel.add((Component)toolbar, "West");
        return panel;
    }

    private static MavenGeneralSettings getSettings(Project project) {
        return MavenProjectsManager.getInstance(project).getGeneralSettings();
    }

    public static BuildView createBuildView(@NotNull Project project, @NotNull ExecutionConsole console, @NotNull BuildDescriptor descriptor) {
        if (project == null) {
            BuildViewMavenConsole.$$$reportNull$$$0(4);
        }
        if (console == null) {
            BuildViewMavenConsole.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            BuildViewMavenConsole.$$$reportNull$$$0(6);
        }
        return new BuildView(project, console, descriptor, "build.toolwindow.run.selection.state", new ViewManager(){

            public boolean isConsoleEnabledByDefault() {
                return true;
            }

            public boolean isBuildContentView() {
                return true;
            }
        }){

            public void dispose() {
                super.dispose();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/buildtool/BuildViewMavenConsole";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuildView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

