/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.execution.impl.DefaultJavaProgramRunner;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenResumeAction;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogOutputParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenOutputParserProvider;
import org.jetbrains.idea.maven.project.MavenConsoleImpl;

@ApiStatus.Experimental
public class MavenBuildEventProcessor
implements AnsiEscapeDecoder.ColoredTextAcceptor {
    @NotNull
    private final BuildProgressListener myBuildProgressListener;
    @NotNull
    private final Project myProject;
    @NotNull
    private final BuildOutputInstantReader myInstantReader;
    @NotNull
    private final ExternalSystemTaskId myTaskId;
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myWorkingDir;
    @NotNull
    private final MavenLogOutputParser myParser;
    private final BuildDescriptor myDescriptor;

    public MavenBuildEventProcessor(@NotNull Project project, @NotNull String workingDir, @NotNull BuildProgressListener buildProgressListener, @NotNull BuildDescriptor descriptor, @NotNull ExternalSystemTaskId taskId) {
        if (project == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(0);
        }
        if (workingDir == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(1);
        }
        if (buildProgressListener == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(3);
        }
        if (taskId == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(4);
        }
        this.myBuildProgressListener = buildProgressListener;
        this.myProject = project;
        this.myTaskId = taskId;
        this.myTitle = descriptor.getTitle();
        this.myWorkingDir = workingDir;
        this.myDescriptor = descriptor;
        this.myParser = MavenOutputParserProvider.createMavenOutputParser(this.myTaskId);
        this.myInstantReader = new BuildOutputInstantReaderImpl((Object)this.myTaskId, this.myBuildProgressListener, Collections.singletonList(this.myParser));
    }

    public void finish() {
        this.myInstantReader.close();
        this.myParser.finish(e -> this.myBuildProgressListener.onEvent(e));
    }

    public void start(@Nullable ExecutionEnvironment executionEnvironment, @Nullable ProcessHandler processHandler) {
        StartBuildEventImpl startEvent = new StartBuildEventImpl(this.myDescriptor, "Maven run").withExecutionFilters(MavenConsoleImpl.getMavenConsoleFilters(this.myProject));
        if (executionEnvironment != null && processHandler != null) {
            startEvent.withRestartAction((AnAction)new MavenResumeAction(processHandler, DefaultJavaProgramRunner.getInstance(), executionEnvironment));
        }
        this.myBuildProgressListener.onEvent((BuildEvent)startEvent);
    }

    public void notifyException(Throwable throwable) {
        new Notification("Maven", "Error running maven task", throwable.getMessage(), NotificationType.ERROR, null).notify(this.myProject);
    }

    public void onTextAvailable(String text, boolean stdError) {
        this.myBuildProgressListener.onEvent((BuildEvent)new OutputBuildEventImpl((Object)this.myTaskId, text, !stdError));
        this.myInstantReader.append((CharSequence)text);
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(5);
        }
        if (outputType == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(6);
        }
        boolean stdError = outputType == ProcessOutputTypes.STDERR;
        this.myBuildProgressListener.onEvent((BuildEvent)new OutputBuildEventImpl((Object)this.myTaskId, text, !stdError));
        this.myInstantReader.append((CharSequence)text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildProgressListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/buildtool/MavenBuildEventProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "coloredTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

