/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementAction;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.generate.GenerateDependencyUtil;
import org.jetbrains.idea.maven.dom.generate.MavenGenerateProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class GenerateManagedDependencyAction
extends GenerateDomElementAction {
    public GenerateManagedDependencyAction() {
        super((GenerateDomElementProvider)new MavenOverridingDependencyGenerateProvider(), AllIcons.Nodes.PpLib);
    }

    protected boolean startInWriteAction() {
        return false;
    }

    private static Set<DependencyConflictId> collectExistingDependencies(@NotNull MavenDomProjectModel model) {
        if (model == null) {
            GenerateManagedDependencyAction.$$$reportNull$$$0(0);
        }
        HashSet existingDependencies = new HashSet();
        for (MavenDomDependency dependency : model.getDependencies().getDependencies()) {
            DependencyConflictId id = DependencyConflictId.create(dependency);
            if (id == null) continue;
            existingDependencies.add(id);
        }
        return existingDependencies;
    }

    @NotNull
    public static Map<DependencyConflictId, MavenDomDependency> collectManagingDependencies(@NotNull MavenDomProjectModel model) {
        if (model == null) {
            GenerateManagedDependencyAction.$$$reportNull$$$0(1);
        }
        HashMap dependencies = new HashMap();
        Processor collectProcessor = arg_0 -> GenerateManagedDependencyAction.lambda$collectManagingDependencies$0((Map)dependencies, arg_0);
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(model, (Processor<? super MavenDomDependency>)collectProcessor, model.getManager().getProject());
        HashMap hashMap = dependencies;
        if (hashMap == null) {
            GenerateManagedDependencyAction.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    private static /* synthetic */ boolean lambda$collectManagingDependencies$0(Map dependencies, MavenDomDependency dependency) {
        DependencyConflictId id = DependencyConflictId.create(dependency);
        if (id != null && !dependencies.containsKey(id)) {
            dependencies.put(id, dependency);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/generate/GenerateManagedDependencyAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/generate/GenerateManagedDependencyAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectManagingDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectExistingDependencies";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectManagingDependencies";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MavenOverridingDependencyGenerateProvider
    extends MavenGenerateProvider<MavenDomDependency> {
        MavenOverridingDependencyGenerateProvider() {
            super(MavenDomBundle.message("generate.managed.dependency", new Object[0]), MavenDomDependency.class);
        }

        @Override
        protected MavenDomDependency doGenerate(@NotNull MavenDomProjectModel mavenModel, Editor editor) {
            if (mavenModel == null) {
                MavenOverridingDependencyGenerateProvider.$$$reportNull$$$0(0);
            }
            Set existingDependencies = GenerateManagedDependencyAction.collectExistingDependencies(mavenModel);
            Map<DependencyConflictId, MavenDomDependency> managingDependencies = GenerateManagedDependencyAction.collectManagingDependencies(mavenModel);
            Map unexistManagingDeps = Maps.filterKeys(managingDependencies, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)existingDependencies)));
            List<MavenDomDependency> dependenciesToOverride = GenerateDependencyUtil.chooseDependencies(unexistManagingDeps.values(), mavenModel.getManager().getProject());
            if (!dependenciesToOverride.isEmpty()) {
                return (MavenDomDependency)WriteCommandAction.writeCommandAction((Project)editor.getProject(), (PsiFile[])new PsiFile[]{mavenModel.getXmlTag().getContainingFile()}).compute(() -> {
                    MavenDomDependency dependency = null;
                    for (MavenDomDependency parentDependency : dependenciesToOverride) {
                        String groupId = parentDependency.getGroupId().getStringValue();
                        String artifactId = parentDependency.getArtifactId().getStringValue();
                        if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)artifactId)) continue;
                        dependency = MavenDomUtil.createDomDependency(mavenModel, editor);
                        dependency.getGroupId().setStringValue(groupId);
                        dependency.getArtifactId().setStringValue(artifactId);
                        String typeValue = parentDependency.getType().getStringValue();
                        String classifier = parentDependency.getClassifier().getStringValue();
                        if (!StringUtil.isEmptyOrSpaces((String)typeValue)) {
                            dependency.getType().setStringValue(typeValue);
                        }
                        if (!StringUtil.isEmptyOrSpaces((String)classifier)) {
                            dependency.getClassifier().setStringValue(classifier);
                        }
                        dependency.getVersion().undefine();
                    }
                    return dependency;
                });
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenModel", "org/jetbrains/idea/maven/dom/generate/GenerateManagedDependencyAction$MavenOverridingDependencyGenerateProvider", "doGenerate"));
        }
    }
}

