/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenTestRunningSettings;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

public class MavenJUnitPatcher
extends JUnitPatcher {
    public static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");
    private static final Logger LOG = Logger.getInstance(MavenJUnitPatcher.class);

    public void patchJavaParameters(@Nullable Module module, JavaParameters javaParameters) {
        if (module == null) {
            return;
        }
        MavenProject mavenProject = MavenProjectsManager.getInstance(module.getProject()).findProject(module);
        if (mavenProject == null) {
            return;
        }
        Element config = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-surefire-plugin");
        if (config != null) {
            MavenJUnitPatcher.patchJavaParameters(module, javaParameters, mavenProject, "surefire", config);
        }
        if ((config = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-failsafe-plugin")) != null) {
            MavenJUnitPatcher.patchJavaParameters(module, javaParameters, mavenProject, "failsafe", config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void patchJavaParameters(@NotNull Module module, @NotNull JavaParameters javaParameters, @NotNull MavenProject mavenProject, @NotNull String plugin, @NotNull Element config) {
        Element argLine;
        Element environmentVariables;
        String value;
        if (module == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(0);
        }
        if (javaParameters == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(1);
        }
        if (mavenProject == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(2);
        }
        if (plugin == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(3);
        }
        if (config == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(4);
        }
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel(module.getProject(), mavenProject.getFile());
        MavenTestRunningSettings testRunningSettings = MavenProjectSettings.getInstance(module.getProject()).getTestRunningSettings();
        List<String> paths = MavenJDOMUtil.findChildrenValuesByPath(config, "additionalClasspathElements", "additionalClasspathElement");
        if (paths.size() > 0) {
            for (String string : paths) {
                javaParameters.getClassPath().add(MavenJUnitPatcher.resolvePluginProperties(plugin, string, domModel));
            }
        }
        if (testRunningSettings.isPassSystemProperties()) {
            Element systemPropertiesFile;
            Element systemPropertyVariables;
            if (MavenJUnitPatcher.isEnabled(plugin, "systemPropertyVariables") && (systemPropertyVariables = config.getChild("systemPropertyVariables")) != null) {
                for (Element element : systemPropertyVariables.getChildren()) {
                    String propertyName = element.getName();
                    if (javaParameters.getVMParametersList().hasProperty(propertyName)) continue;
                    value = MavenJUnitPatcher.resolvePluginProperties(plugin, element.getValue(), domModel);
                    value = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value);
                    if (!MavenJUnitPatcher.isResolved(plugin, value)) continue;
                    javaParameters.getVMParametersList().addProperty(propertyName, value);
                }
            }
            if (MavenJUnitPatcher.isEnabled(plugin, "systemPropertiesFile") && (systemPropertiesFile = config.getChild("systemPropertiesFile")) != null) {
                void var9_14;
                String string = systemPropertiesFile.getTextTrim();
                if (StringUtil.isNotEmpty((String)string) && !FileUtil.isAbsolute((String)string)) {
                    String string2 = mavenProject.getDirectory() + '/' + string;
                }
                if (StringUtil.isNotEmpty((String)var9_14) && new File((String)var9_14).exists()) {
                    try (BufferedReader fis = new BufferedReader(new FileReader((String)var9_14));){
                        Map properties = FileUtil.loadProperties((Reader)fis);
                        properties.forEach((pName, pValue) -> javaParameters.getVMParametersList().addProperty(pName, pValue));
                    }
                    catch (IOException e) {
                        LOG.warn("Can't read property file '" + (String)var9_14 + "': " + e.getMessage());
                    }
                }
            }
        }
        if (testRunningSettings.isPassEnvironmentVariables() && MavenJUnitPatcher.isEnabled(plugin, "environmentVariables") && (environmentVariables = config.getChild("environmentVariables")) != null) {
            for (Element element : environmentVariables.getChildren()) {
                String variableName = element.getName();
                if (javaParameters.getEnv().containsKey(variableName)) continue;
                value = MavenJUnitPatcher.resolvePluginProperties(plugin, element.getValue(), domModel);
                value = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value);
                if (!MavenJUnitPatcher.isResolved(plugin, value)) continue;
                javaParameters.addEnv(variableName, value);
            }
        }
        if (testRunningSettings.isPassArgLine() && MavenJUnitPatcher.isEnabled(plugin, "argLine") && (argLine = config.getChild("argLine")) != null) {
            String string3 = MavenJUnitPatcher.resolvePluginProperties(plugin, argLine.getTextTrim(), domModel);
            string3 = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), string3);
            if (StringUtil.isNotEmpty((String)string3) && MavenJUnitPatcher.isResolved(plugin, string3)) {
                if (string3.contains("@{argLine}")) {
                    String parametersString = javaParameters.getVMParametersList().getParametersString();
                    javaParameters.getVMParametersList().clearAll();
                    javaParameters.getVMParametersList().addParametersString(StringUtil.replace((String)string3, (String)"@{argLine}", (String)parametersString));
                } else {
                    javaParameters.getVMParametersList().addParametersString(string3);
                }
            }
        }
    }

    private static String resolvePluginProperties(@NotNull String plugin, @NotNull String value, @Nullable MavenDomProjectModel domModel) {
        if (plugin == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(5);
        }
        if (value == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(6);
        }
        if (domModel != null) {
            value = MavenPropertyResolver.resolve(value, domModel);
        }
        return value.replaceAll("\\$\\{" + plugin + "\\.(forkNumber|threadNumber)\\}", "1");
    }

    private static String resolveVmProperties(@NotNull ParametersList vmParameters, @NotNull String value) {
        if (vmParameters == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(7);
        }
        if (value == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(8);
        }
        Matcher matcher = PROPERTY_PATTERN.matcher(value);
        HashMap toReplace = ContainerUtil.newHashMap();
        while (matcher.find()) {
            String finding = matcher.group();
            String propertyValue = vmParameters.getPropertyValue(finding.substring(2, finding.length() - 1));
            if (propertyValue == null) continue;
            toReplace.put(finding, propertyValue);
        }
        for (Map.Entry entry : toReplace.entrySet()) {
            value = value.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return value;
    }

    private static boolean isEnabled(String plugin, String s) {
        return Boolean.valueOf(System.getProperty("idea.maven." + plugin + ".disable." + s)) == false;
    }

    private static boolean isResolved(String plugin, String s) {
        return !s.contains("${") || Boolean.valueOf(System.getProperty("idea.maven." + plugin + ".allPropertiesAreResolved")) != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmParameters";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenJUnitPatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "patchJavaParameters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvePluginProperties";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveVmProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

