/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenAnnotationProcessorsModuleService;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProfile;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.plugins.api.MavenModelPropertiesPatcher;
import org.jetbrains.idea.maven.project.MavenArtifactIndex;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Path;
import org.jetbrains.jps.util.JpsPathUtil;

public class MavenProject {
    private static final Key<MavenArtifactIndex> DEPENDENCIES_CACHE_KEY = Key.create((String)"MavenProject.DEPENDENCIES_CACHE_KEY");
    private static final Key<List<String>> FILTERS_CACHE_KEY = Key.create((String)"MavenProject.FILTERS_CACHE_KEY");
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private volatile State myState;

    @Nullable
    public static MavenProject read(DataInputStream in) throws IOException {
        String path = in.readUTF();
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            return null;
        }
        ByteArrayInputStream bs = new ByteArrayInputStream(bytes);
        ObjectInputStream os = new ObjectInputStream(bs);
        try {
            MavenProject result = new MavenProject(file);
            result.myState = (State)os.readObject();
            MavenProject mavenProject = result;
            return mavenProject;
        }
        catch (ClassNotFoundException e) {
            IOException ioException = new IOException();
            ioException.initCause(e);
            throw ioException;
        }
        finally {
            os.close();
            bs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@NotNull DataOutputStream out) throws IOException {
        if (out == null) {
            MavenProject.$$$reportNull$$$0(0);
        }
        out.writeUTF(this.getPath());
        BufferExposingByteArrayOutputStream bs = new BufferExposingByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream((OutputStream)bs);
        try {
            os.writeObject(this.myState);
            out.writeInt(bs.size());
            out.write(bs.getInternalBuffer(), 0, bs.size());
        }
        finally {
            os.close();
            bs.close();
        }
    }

    public MavenProject(@NotNull VirtualFile file) {
        if (file == null) {
            MavenProject.$$$reportNull$$$0(1);
        }
        this.myState = new State();
        this.myFile = file;
    }

    @NotNull
    MavenProjectChanges set(@NotNull MavenProjectReaderResult readerResult, @NotNull MavenGeneralSettings settings, boolean updateLastReadStamp, boolean resetArtifacts, boolean resetProfiles) {
        if (readerResult == null) {
            MavenProject.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            MavenProject.$$$reportNull$$$0(3);
        }
        State newState = this.myState.clone();
        if (updateLastReadStamp) {
            newState.myLastReadStamp = this.myState.myLastReadStamp + 1L;
        }
        newState.myReadingProblems = readerResult.readingProblems;
        newState.myLocalRepository = settings.getEffectiveLocalRepository();
        newState.myActivatedProfilesIds = readerResult.activatedProfiles;
        MavenModel model = readerResult.mavenModel;
        newState.myMavenId = model.getMavenId();
        if (model.getParent() != null) {
            newState.myParentId = model.getParent().getMavenId();
        }
        newState.myPackaging = model.getPackaging();
        newState.myName = model.getName();
        newState.myFinalName = model.getBuild().getFinalName();
        newState.myDefaultGoal = model.getBuild().getDefaultGoal();
        newState.myBuildDirectory = model.getBuild().getDirectory();
        newState.myOutputDirectory = model.getBuild().getOutputDirectory();
        newState.myTestOutputDirectory = model.getBuild().getTestOutputDirectory();
        MavenProject.doSetFolders(newState, readerResult);
        newState.myFilters = model.getBuild().getFilters();
        newState.myProperties = model.getProperties();
        MavenProject.doSetResolvedAttributes(newState, readerResult, resetArtifacts);
        MavenModelPropertiesPatcher.patch(newState.myProperties, newState.myPlugins);
        newState.myModulesPathsAndNames = this.collectModulePathsAndNames(model, this.getDirectory());
        Collection<String> newProfiles = MavenProject.collectProfilesIds(model.getProfiles());
        if (resetProfiles || newState.myProfilesIds == null) {
            newState.myProfilesIds = newProfiles;
        } else {
            THashSet mergedProfiles = new THashSet(newState.myProfilesIds);
            mergedProfiles.addAll(newProfiles);
            newState.myProfilesIds = new ArrayList<String>((Collection<String>)mergedProfiles);
        }
        newState.myModelMap = readerResult.nativeModelMap;
        MavenProjectChanges mavenProjectChanges = this.setState(newState);
        if (mavenProjectChanges == null) {
            MavenProject.$$$reportNull$$$0(4);
        }
        return mavenProjectChanges;
    }

    private MavenProjectChanges setState(State newState) {
        MavenProjectChanges changes = this.myState.getChanges(newState);
        this.myState = newState;
        return changes;
    }

    private static void doSetResolvedAttributes(State state, MavenProjectReaderResult readerResult, boolean reset) {
        MavenModel model = readerResult.mavenModel;
        THashSet newUnresolvedArtifacts = new THashSet();
        LinkedHashSet<MavenRemoteRepository> newRepositories = new LinkedHashSet<MavenRemoteRepository>();
        LinkedHashSet<MavenArtifact> newDependencies = new LinkedHashSet<MavenArtifact>();
        LinkedHashSet<MavenArtifactNode> newDependencyTree = new LinkedHashSet<MavenArtifactNode>();
        LinkedHashSet<MavenPlugin> newPlugins = new LinkedHashSet<MavenPlugin>();
        LinkedHashSet<MavenArtifact> newExtensions = new LinkedHashSet<MavenArtifact>();
        LinkedHashSet<MavenArtifact> newAnnotationProcessors = new LinkedHashSet<MavenArtifact>();
        if (!reset) {
            if (state.myUnresolvedArtifactIds != null) {
                newUnresolvedArtifacts.addAll(state.myUnresolvedArtifactIds);
            }
            if (state.myRemoteRepositories != null) {
                newRepositories.addAll(state.myRemoteRepositories);
            }
            if (state.myDependencies != null) {
                newDependencies.addAll(state.myDependencies);
            }
            if (state.myDependencyTree != null) {
                newDependencyTree.addAll(state.myDependencyTree);
            }
            if (state.myPlugins != null) {
                newPlugins.addAll(state.myPlugins);
            }
            if (state.myExtensions != null) {
                newExtensions.addAll(state.myExtensions);
            }
            if (state.myAnnotationProcessors != null) {
                newAnnotationProcessors.addAll(state.myAnnotationProcessors);
            }
        }
        newUnresolvedArtifacts.addAll(readerResult.unresolvedArtifactIds);
        newRepositories.addAll(model.getRemoteRepositories());
        newDependencyTree.addAll(model.getDependencyTree());
        newDependencies.addAll(model.getDependencies());
        newPlugins.addAll(model.getPlugins());
        newExtensions.addAll(model.getExtensions());
        state.myUnresolvedArtifactIds = newUnresolvedArtifacts;
        state.myRemoteRepositories = new ArrayList<MavenRemoteRepository>(newRepositories);
        state.myDependencies = new ArrayList<MavenArtifact>(newDependencies);
        state.myDependencyTree = new ArrayList<MavenArtifactNode>(newDependencyTree);
        state.myPlugins = new ArrayList<MavenPlugin>(newPlugins);
        state.myExtensions = new ArrayList<MavenArtifact>(newExtensions);
        state.myAnnotationProcessors = new ArrayList<MavenArtifact>(newAnnotationProcessors);
    }

    private MavenProjectChanges setFolders(MavenProjectReaderResult readerResult) {
        State newState = this.myState.clone();
        MavenProject.doSetFolders(newState, readerResult);
        return this.setState(newState);
    }

    private static void doSetFolders(State newState, MavenProjectReaderResult readerResult) {
        MavenModel model = readerResult.mavenModel;
        newState.mySources = model.getBuild().getSources();
        newState.myTestSources = model.getBuild().getTestSources();
        newState.myResources = model.getBuild().getResources();
        newState.myTestResources = model.getBuild().getTestResources();
    }

    private Map<String, String> collectModulePathsAndNames(MavenModel mavenModel, String baseDir) {
        String basePath = baseDir + "/";
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> each : this.collectModulesRelativePathsAndNames(mavenModel, basePath).entrySet()) {
            result.put(new Path(basePath + each.getKey()).getPath(), each.getValue());
        }
        return result;
    }

    private Map<String, String> collectModulesRelativePathsAndNames(MavenModel mavenModel, String basePath) {
        String extension = StringUtil.notNullize((String)this.myFile.getExtension());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String name : mavenModel.getModules()) {
            if ((name = name.trim()).length() == 0) continue;
            String originalName = name;
            if (!(name = FileUtil.toSystemIndependentName((String)name)).endsWith('.' + extension)) {
                if (!name.endsWith("/")) {
                    name = name + "/";
                }
                name = name + "pom." + extension;
            } else {
                String systemDependentName = FileUtil.toSystemDependentName((String)(basePath + name));
                if (new File(systemDependentName).isDirectory()) {
                    name = name + "/pom.xml";
                }
            }
            result.put(name, originalName);
        }
        return result;
    }

    private static Collection<String> collectProfilesIds(Collection<MavenProfile> profiles) {
        if (profiles == null) {
            return Collections.emptyList();
        }
        THashSet result = new THashSet(profiles.size());
        for (MavenProfile each : profiles) {
            result.add(each.getId());
        }
        return result;
    }

    public long getLastReadStamp() {
        return this.myState.myLastReadStamp;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            MavenProject.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    public String getPath() {
        String string = this.myFile.getPath();
        if (string == null) {
            MavenProject.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getDirectory() {
        String string = this.myFile.getParent().getPath();
        if (string == null) {
            MavenProject.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public VirtualFile getDirectoryFile() {
        VirtualFile virtualFile = this.myFile.getParent();
        if (virtualFile == null) {
            MavenProject.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    @Nullable
    public VirtualFile getProfilesXmlFile() {
        return MavenUtil.findProfilesXmlFile(this.myFile);
    }

    @Nullable
    public File getProfilesXmlIoFile() {
        return MavenUtil.getProfilesXmlIoFile(this.myFile);
    }

    public boolean hasReadingProblems() {
        return !this.myState.myReadingProblems.isEmpty();
    }

    @Nullable
    public String getName() {
        return this.myState.myName;
    }

    @NotNull
    public String getDisplayName() {
        State state = this.myState;
        if (StringUtil.isEmptyOrSpaces((String)state.myName)) {
            String string = StringUtil.notNullize((String)state.myMavenId.getArtifactId());
            if (string == null) {
                MavenProject.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = state.myName;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public Map<String, String> getModelMap() {
        Map<String, String> map = this.myState.myModelMap;
        if (map == null) {
            MavenProject.$$$reportNull$$$0(11);
        }
        return map;
    }

    @NotNull
    public MavenId getMavenId() {
        MavenId mavenId = this.myState.myMavenId;
        if (mavenId == null) {
            MavenProject.$$$reportNull$$$0(12);
        }
        return mavenId;
    }

    @Nullable
    public MavenId getParentId() {
        return this.myState.myParentId;
    }

    @NotNull
    public String getPackaging() {
        String string = this.myState.myPackaging;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getFinalName() {
        String string = this.myState.myFinalName;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public String getDefaultGoal() {
        return this.myState.myDefaultGoal;
    }

    @NotNull
    public String getBuildDirectory() {
        String string = this.myState.myBuildDirectory;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getGeneratedSourcesDirectory(boolean testSources) {
        String string = this.getBuildDirectory() + (testSources ? "/generated-test-sources" : "/generated-sources");
        if (string == null) {
            MavenProject.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getAnnotationProcessorDirectory(boolean testSources) {
        if (this.getProcMode() == ProcMode.NONE) {
            MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
            Element cfg = this.getPluginGoalConfiguration(bscMavenPlugin, testSources ? "process-test" : "process");
            if (bscMavenPlugin != null && cfg == null) {
                String string = this.getBuildDirectory() + (testSources ? "/generated-sources/apt-test" : "/generated-sources/apt");
                if (string == null) {
                    MavenProject.$$$reportNull$$$0(17);
                }
                return string;
            }
            if (cfg != null) {
                String out = MavenJDOMUtil.findChildValueByPath(cfg, "outputDirectory");
                if (out == null && (out = MavenJDOMUtil.findChildValueByPath(cfg, "defaultOutputDirectory")) == null) {
                    String string = this.getBuildDirectory() + (testSources ? "/generated-sources/apt-test" : "/generated-sources/apt");
                    if (string == null) {
                        MavenProject.$$$reportNull$$$0(18);
                    }
                    return string;
                }
                if (!new File(out).isAbsolute()) {
                    out = this.getDirectory() + '/' + out;
                }
                String string = out;
                if (string == null) {
                    MavenProject.$$$reportNull$$$0(19);
                }
                return string;
            }
        }
        String def = this.getGeneratedSourcesDirectory(testSources) + (testSources ? "/test-annotations" : "/annotations");
        String string = MavenJDOMUtil.findChildValueByPath(this.getCompilerConfig(), testSources ? "generatedTestSourcesDirectory" : "generatedSourcesDirectory", def);
        if (string == null) {
            MavenProject.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public ProcMode getProcMode() {
        Element compilerConfiguration = this.getPluginExecutionConfiguration("org.apache.maven.plugins", "maven-compiler-plugin", "default-compile");
        if (compilerConfiguration == null) {
            compilerConfiguration = this.getCompilerConfig();
        }
        if (compilerConfiguration == null) {
            ProcMode procMode = ProcMode.BOTH;
            if (procMode == null) {
                MavenProject.$$$reportNull$$$0(21);
            }
            return procMode;
        }
        Element procElement = compilerConfiguration.getChild("proc");
        if (procElement != null) {
            String procMode = procElement.getValue();
            ProcMode procMode2 = "only".equalsIgnoreCase(procMode) ? ProcMode.ONLY : ("none".equalsIgnoreCase(procMode) ? ProcMode.NONE : ProcMode.BOTH);
            if (procMode2 == null) {
                MavenProject.$$$reportNull$$$0(22);
            }
            return procMode2;
        }
        String compilerArgument = compilerConfiguration.getChildTextTrim("compilerArgument");
        if ("-proc:none".equals(compilerArgument)) {
            ProcMode procMode = ProcMode.NONE;
            if (procMode == null) {
                MavenProject.$$$reportNull$$$0(23);
            }
            return procMode;
        }
        if ("-proc:only".equals(compilerArgument)) {
            ProcMode procMode = ProcMode.ONLY;
            if (procMode == null) {
                MavenProject.$$$reportNull$$$0(24);
            }
            return procMode;
        }
        Element compilerArguments = compilerConfiguration.getChild("compilerArgs");
        if (compilerArguments != null) {
            for (Element element : compilerArguments.getChildren()) {
                String arg = element.getValue();
                if ("-proc:none".equals(arg)) {
                    ProcMode procMode = ProcMode.NONE;
                    if (procMode == null) {
                        MavenProject.$$$reportNull$$$0(25);
                    }
                    return procMode;
                }
                if (!"-proc:only".equals(arg)) continue;
                ProcMode procMode = ProcMode.ONLY;
                if (procMode == null) {
                    MavenProject.$$$reportNull$$$0(26);
                }
                return procMode;
            }
        }
        ProcMode procMode = ProcMode.BOTH;
        if (procMode == null) {
            MavenProject.$$$reportNull$$$0(27);
        }
        return procMode;
    }

    public Map<String, String> getAnnotationProcessorOptions() {
        Element compilerConfig = this.getCompilerConfig();
        if (compilerConfig == null) {
            return Collections.emptyMap();
        }
        if (this.getProcMode() != ProcMode.NONE) {
            return MavenProject.getAnnotationProcessorOptionsFromCompilerConfig(compilerConfig);
        }
        MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
        if (bscMavenPlugin != null) {
            return MavenProject.getAnnotationProcessorOptionsFromProcessorPlugin(bscMavenPlugin);
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> getAnnotationProcessorOptionsFromCompilerConfig(Element compilerConfig) {
        Element compilerArguments;
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        String compilerArgument = compilerConfig.getChildText("compilerArgument");
        MavenProject.addAnnotationProcessorOptionFomrParametersString(compilerArgument, res);
        Element compilerArgs = compilerConfig.getChild("compilerArgs");
        if (compilerArgs != null) {
            for (Element e : compilerArgs.getChildren()) {
                if (!StringUtil.equals((CharSequence)e.getName(), (CharSequence)"arg")) continue;
                String arg = e.getTextTrim();
                MavenProject.addAnnotationProcessorOption(arg, res);
            }
        }
        if ((compilerArguments = compilerConfig.getChild("compilerArguments")) != null) {
            for (Element e : compilerArguments.getChildren()) {
                String name = e.getName();
                if ((name = StringUtil.trimStart((String)name, (String)"-")).length() <= 1 || name.charAt(0) != 'A') continue;
                res.put(name.substring(1), e.getTextTrim());
            }
        }
        return res;
    }

    private static void addAnnotationProcessorOptionFomrParametersString(String compilerArguments, Map<String, String> res) {
        if (!StringUtil.isEmptyOrSpaces((String)compilerArguments)) {
            ParametersList parametersList = new ParametersList();
            parametersList.addParametersString(compilerArguments);
            for (String param : parametersList.getParameters()) {
                MavenProject.addAnnotationProcessorOption(param, res);
            }
        }
    }

    private static void addAnnotationProcessorOption(String compilerArg, Map<String, String> optionsMap) {
        if (compilerArg == null || compilerArg.trim().isEmpty()) {
            return;
        }
        if (compilerArg.startsWith("-A")) {
            int idx = compilerArg.indexOf(61, 3);
            if (idx >= 0) {
                optionsMap.put(compilerArg.substring(2, idx), compilerArg.substring(idx + 1));
            } else {
                optionsMap.put(compilerArg.substring(2), "");
            }
        }
    }

    private static Map<String, String> getAnnotationProcessorOptionsFromProcessorPlugin(MavenPlugin bscMavenPlugin) {
        Element cfg = bscMavenPlugin.getGoalConfiguration("process");
        if (cfg == null) {
            cfg = bscMavenPlugin.getConfigurationElement();
        }
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        if (cfg != null) {
            String compilerArguments = cfg.getChildText("compilerArguments");
            MavenProject.addAnnotationProcessorOptionFomrParametersString(compilerArguments, res);
            Element optionsElement = cfg.getChild("options");
            if (optionsElement != null) {
                for (Element option : optionsElement.getChildren()) {
                    res.put(option.getName(), option.getText());
                }
            }
        }
        return res;
    }

    @Nullable
    public List<String> getDeclaredAnnotationProcessors() {
        ArrayList<String> result;
        block7: {
            block6: {
                Element compilerConfig = this.getCompilerConfig();
                if (compilerConfig == null) {
                    return null;
                }
                result = new ArrayList<String>();
                if (this.getProcMode() == ProcMode.NONE) break block6;
                Element processors = compilerConfig.getChild("annotationProcessors");
                if (processors == null) break block7;
                for (Element element : processors.getChildren("annotationProcessor")) {
                    String processorClassName = element.getTextTrim();
                    if (processorClassName.isEmpty()) continue;
                    result.add(processorClassName);
                }
                break block7;
            }
            MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
            if (bscMavenPlugin != null) {
                Element bscProcessors;
                Element bscCfg = bscMavenPlugin.getGoalConfiguration("process");
                if (bscCfg == null) {
                    bscCfg = bscMavenPlugin.getConfigurationElement();
                }
                if (bscCfg != null && (bscProcessors = bscCfg.getChild("processors")) != null) {
                    for (Element element : bscProcessors.getChildren("processor")) {
                        String processorClassName = element.getTextTrim();
                        if (processorClassName.isEmpty()) continue;
                        result.add(processorClassName);
                    }
                }
            }
        }
        return result;
    }

    @NotNull
    public String getOutputDirectory() {
        String string = this.myState.myOutputDirectory;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public String getTestOutputDirectory() {
        String string = this.myState.myTestOutputDirectory;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public List<String> getSources() {
        List<String> list = this.myState.mySources;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    public List<String> getTestSources() {
        List<String> list = this.myState.myTestSources;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public List<MavenResource> getResources() {
        List<MavenResource> list = this.myState.myResources;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public List<MavenResource> getTestResources() {
        List<MavenResource> list = this.myState.myTestResources;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    public List<String> getFilters() {
        List<String> list = this.myState.myFilters;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(34);
        }
        return list;
    }

    public List<String> getFilterPropertiesFiles() {
        List<String> res = this.getCachedValue(FILTERS_CACHE_KEY);
        if (res == null) {
            Element files;
            Element propCfg = this.getPluginGoalConfiguration("org.codehaus.mojo", "properties-maven-plugin", "read-project-properties");
            if (propCfg != null && (files = propCfg.getChild("files")) != null) {
                res = new ArrayList<String>();
                for (Element file : files.getChildren("file")) {
                    File f = new File(file.getValue());
                    if (!f.isAbsolute()) {
                        f = new File(this.getDirectory(), file.getValue());
                    }
                    res.add(f.getAbsolutePath());
                }
            }
            if (res == null) {
                res = this.getFilters();
            } else {
                res.addAll(this.getFilters());
            }
            res = this.putCachedValue(FILTERS_CACHE_KEY, res);
        }
        return res;
    }

    @NotNull
    public MavenProjectChanges read(@NotNull MavenGeneralSettings generalSettings, @NotNull MavenExplicitProfiles profiles, @NotNull MavenProjectReader reader, @NotNull MavenProjectReaderProjectLocator locator) {
        if (generalSettings == null) {
            MavenProject.$$$reportNull$$$0(35);
        }
        if (profiles == null) {
            MavenProject.$$$reportNull$$$0(36);
        }
        if (reader == null) {
            MavenProject.$$$reportNull$$$0(37);
        }
        if (locator == null) {
            MavenProject.$$$reportNull$$$0(38);
        }
        MavenProjectChanges mavenProjectChanges = this.set(reader.readProject(generalSettings, this.myFile, profiles, locator), generalSettings, true, false, true);
        if (mavenProjectChanges == null) {
            MavenProject.$$$reportNull$$$0(39);
        }
        return mavenProjectChanges;
    }

    @NotNull
    public Pair<MavenProjectChanges, NativeMavenProjectHolder> resolve(@NotNull Project project, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbedderWrapper embedder, @NotNull MavenProjectReader reader, @NotNull MavenProjectReaderProjectLocator locator, @NotNull ResolveContext context) throws MavenProcessCanceledException {
        if (project == null) {
            MavenProject.$$$reportNull$$$0(40);
        }
        if (generalSettings == null) {
            MavenProject.$$$reportNull$$$0(41);
        }
        if (embedder == null) {
            MavenProject.$$$reportNull$$$0(42);
        }
        if (reader == null) {
            MavenProject.$$$reportNull$$$0(43);
        }
        if (locator == null) {
            MavenProject.$$$reportNull$$$0(44);
        }
        if (context == null) {
            MavenProject.$$$reportNull$$$0(45);
        }
        Collection<MavenProjectReaderResult> results = reader.resolveProject(generalSettings, embedder, Collections.singleton(this.getFile()), this.getActivatedProfilesIds(), locator);
        MavenProjectReaderResult result = results.iterator().next();
        MavenProjectChanges changes = this.set(result, generalSettings, false, result.readingProblems.isEmpty(), false);
        if (result.nativeMavenProject != null) {
            for (MavenImporter eachImporter : this.getSuitableImporters()) {
                eachImporter.resolve(project, this, result.nativeMavenProject, embedder, context);
            }
        }
        Pair pair = Pair.create((Object)changes, (Object)result.nativeMavenProject);
        if (pair == null) {
            MavenProject.$$$reportNull$$$0(46);
        }
        return pair;
    }

    @NotNull
    public Pair<Boolean, MavenProjectChanges> resolveFolders(@NotNull MavenEmbedderWrapper embedder, @NotNull MavenImportingSettings importingSettings, @NotNull MavenConsole console) throws MavenProcessCanceledException {
        MavenProjectReaderResult result;
        if (embedder == null) {
            MavenProject.$$$reportNull$$$0(47);
        }
        if (importingSettings == null) {
            MavenProject.$$$reportNull$$$0(48);
        }
        if (console == null) {
            MavenProject.$$$reportNull$$$0(49);
        }
        if ((result = MavenProjectReader.generateSources(embedder, importingSettings, this.getFile(), this.getActivatedProfilesIds(), console)) == null || !result.readingProblems.isEmpty()) {
            Pair pair = Pair.create((Object)false, (Object)MavenProjectChanges.NONE);
            if (pair == null) {
                MavenProject.$$$reportNull$$$0(50);
            }
            return pair;
        }
        MavenProjectChanges changes = this.setFolders(result);
        Pair pair = Pair.create((Object)true, (Object)changes);
        if (pair == null) {
            MavenProject.$$$reportNull$$$0(51);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        State state = this.myState;
        synchronized (state) {
            this.myState.resetCache();
        }
    }

    public boolean isAggregator() {
        return "pom".equals(this.getPackaging()) || !this.getModulePaths().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<MavenProjectProblem> getProblems() {
        State state;
        State state2 = state = this.myState;
        // MONITORENTER : state2
        if (state.myProblemsCache == null) {
            state.myProblemsCache = MavenProject.collectProblems(this.myFile, state);
        }
        List<MavenProjectProblem> list = state.myProblemsCache;
        // MONITOREXIT : state2
        if (list != null) return list;
        MavenProject.$$$reportNull$$$0(52);
        return list;
    }

    private static List<MavenProjectProblem> collectProblems(VirtualFile file, State state) {
        ArrayList<MavenProjectProblem> result = new ArrayList<MavenProjectProblem>();
        MavenProject.validateParent(file, state, result);
        result.addAll(state.myReadingProblems);
        for (Map.Entry<String, String> each : state.myModulesPathsAndNames.entrySet()) {
            if (LocalFileSystem.getInstance().findFileByPath(each.getKey()) != null) continue;
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.moduleNotFound", each.getValue())));
        }
        MavenProject.validateDependencies(file, state, result);
        MavenProject.validateExtensions(file, state, result);
        MavenProject.validatePlugins(file, state, result);
        return result;
    }

    private static void validateParent(VirtualFile file, State state, List<MavenProjectProblem> result) {
        if (!MavenProject.isParentResolved(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.parentNotFound", state.myParentId)));
        }
    }

    private static void validateDependencies(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenArtifact each : MavenProject.getUnresolvedDependencies(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedDependency", each.getDisplayStringWithType())));
        }
    }

    private static void validateExtensions(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenArtifact each : MavenProject.getUnresolvedExtensions(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedExtension", each.getDisplayStringSimple())));
        }
    }

    private static void validatePlugins(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenPlugin each : MavenProject.getUnresolvedPlugins(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedPlugin", each)));
        }
    }

    private static MavenProjectProblem createDependencyProblem(VirtualFile file, String description) {
        return new MavenProjectProblem(file.getPath(), description, MavenProjectProblem.ProblemType.DEPENDENCY);
    }

    private static boolean isParentResolved(State state) {
        return !state.myUnresolvedArtifactIds.contains(state.myParentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedDependencies(State state) {
        State state2 = state;
        synchronized (state2) {
            if (state.myUnresolvedDependenciesCache == null) {
                ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
                for (MavenArtifact each : state.myDependencies) {
                    if (each.isResolved()) continue;
                    result.add(each);
                }
                state.myUnresolvedDependenciesCache = result;
            }
            return state.myUnresolvedDependenciesCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedExtensions(State state) {
        State state2 = state;
        synchronized (state2) {
            if (state.myUnresolvedExtensionsCache == null) {
                ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
                for (MavenArtifact each : state.myExtensions) {
                    if (!state.myUnresolvedArtifactIds.contains(each.getMavenId()) || MavenProject.pomFileExists(state.myLocalRepository, each)) continue;
                    result.add(each);
                }
                state.myUnresolvedExtensionsCache = result;
            }
            return state.myUnresolvedExtensionsCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedAnnotationProcessors(State state) {
        State state2 = state;
        synchronized (state2) {
            if (state.myUnresolvedAnnotationProcessors == null) {
                ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
                for (MavenArtifact each : state.myAnnotationProcessors) {
                    if (each.isResolved()) continue;
                    result.add(each);
                }
                state.myUnresolvedAnnotationProcessors = result;
            }
            return state.myUnresolvedAnnotationProcessors;
        }
    }

    private static boolean pomFileExists(File localRepository, MavenArtifact artifact) {
        return MavenArtifactUtil.hasArtifactFile(localRepository, artifact.getMavenId(), "pom");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenPlugin> getUnresolvedPlugins(State state) {
        State state2 = state;
        synchronized (state2) {
            if (state.myUnresolvedPluginsCache == null) {
                ArrayList<MavenPlugin> result = new ArrayList<MavenPlugin>();
                for (MavenPlugin each : MavenProject.getDeclaredPlugins(state)) {
                    if (MavenArtifactUtil.hasArtifactFile(state.myLocalRepository, each.getMavenId())) continue;
                    result.add(each);
                }
                state.myUnresolvedPluginsCache = result;
            }
            return state.myUnresolvedPluginsCache;
        }
    }

    @NotNull
    public List<VirtualFile> getExistingModuleFiles() {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        Set<String> pathsInStack = this.getModulePaths();
        for (String each : pathsInStack) {
            VirtualFile f = fs.findFileByPath(each);
            if (f == null) continue;
            result.add(f);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            MavenProject.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    @NotNull
    public Set<String> getModulePaths() {
        Set<String> set = this.getModulesPathsAndNames().keySet();
        if (set == null) {
            MavenProject.$$$reportNull$$$0(54);
        }
        return set;
    }

    @NotNull
    public Map<String, String> getModulesPathsAndNames() {
        Map<String, String> map = this.myState.myModulesPathsAndNames;
        if (map == null) {
            MavenProject.$$$reportNull$$$0(55);
        }
        return map;
    }

    @NotNull
    public Collection<String> getProfilesIds() {
        Collection<String> collection = this.myState.myProfilesIds;
        if (collection == null) {
            MavenProject.$$$reportNull$$$0(56);
        }
        return collection;
    }

    @NotNull
    public MavenExplicitProfiles getActivatedProfilesIds() {
        MavenExplicitProfiles mavenExplicitProfiles = this.myState.myActivatedProfilesIds;
        if (mavenExplicitProfiles == null) {
            MavenProject.$$$reportNull$$$0(57);
        }
        return mavenExplicitProfiles;
    }

    @NotNull
    public List<MavenArtifact> getDependencies() {
        List<MavenArtifact> list = this.myState.myDependencies;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(58);
        }
        return list;
    }

    @NotNull
    public List<MavenArtifact> getExternalAnnotationProcessors() {
        List<MavenArtifact> list = this.myState.myAnnotationProcessors;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(59);
        }
        return list;
    }

    @NotNull
    public String getAnnotationProcessorPath(Project project) {
        StringJoiner annotationProcessorPath = new StringJoiner(File.pathSeparator);
        Consumer resultAppender = path -> annotationProcessorPath.add(FileUtil.toSystemDependentName((String)path));
        for (MavenArtifact artifact : this.getExternalAnnotationProcessors()) {
            resultAppender.consume((Object)artifact.getPath());
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project);
        Module module = projectsManager.findModule(this);
        if (module != null) {
            MavenAnnotationProcessorsModuleService apService = MavenAnnotationProcessorsModuleService.getInstance(module);
            for (String moduleName : apService.getAnnotationProcessorModules()) {
                Module annotationProcessorModule = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
                if (annotationProcessorModule == null) continue;
                OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)annotationProcessorModule).withoutSdk().productionOnly().runtimeOnly().recursively();
                for (String url : enumerator.classes().getUrls()) {
                    resultAppender.consume((Object)JpsPathUtil.urlToPath((String)url));
                }
            }
        }
        String string = annotationProcessorPath.toString();
        if (string == null) {
            MavenProject.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    public List<MavenArtifactNode> getDependencyTree() {
        List<MavenArtifactNode> list = this.myState.myDependencyTree;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(61);
        }
        return list;
    }

    @NotNull
    public Set<String> getSupportedPackagings() {
        HashSet result = ContainerUtil.newHashSet((Object[])new String[]{"pom", "jar", "ejb", "ejb-client", "war", "ear", "bundle", "maven-plugin"});
        for (MavenImporter each : this.getSuitableImporters()) {
            each.getSupportedPackagings(result);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            MavenProject.$$$reportNull$$$0(62);
        }
        return hashSet;
    }

    public Set<String> getDependencyTypesFromImporters(@NotNull SupportedRequestType type) {
        if (type == null) {
            MavenProject.$$$reportNull$$$0(63);
        }
        THashSet res = new THashSet();
        for (MavenImporter each : this.getSuitableImporters()) {
            each.getSupportedDependencyTypes((Collection<String>)res, type);
        }
        return res;
    }

    @NotNull
    public Set<String> getSupportedDependencyScopes() {
        THashSet result = new THashSet(Arrays.asList("compile", "provided", "runtime", "test", "system"));
        for (MavenImporter each : this.getSuitableImporters()) {
            each.getSupportedDependencyScopes((Collection<String>)result);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            MavenProject.$$$reportNull$$$0(64);
        }
        return tHashSet;
    }

    public void addDependency(@NotNull MavenArtifact dependency) {
        if (dependency == null) {
            MavenProject.$$$reportNull$$$0(65);
        }
        State state = this.myState;
        ArrayList<MavenArtifact> dependenciesCopy = new ArrayList<MavenArtifact>(state.myDependencies);
        dependenciesCopy.add(dependency);
        state.myDependencies = dependenciesCopy;
        state.myCache.clear();
    }

    public void addAnnotationProcessors(@NotNull Collection<MavenArtifact> annotationProcessors) {
        if (annotationProcessors == null) {
            MavenProject.$$$reportNull$$$0(66);
        }
        State state = this.myState;
        ArrayList<MavenArtifact> annotationProcessorsCopy = new ArrayList<MavenArtifact>(state.myAnnotationProcessors);
        annotationProcessorsCopy.addAll(annotationProcessors);
        state.myAnnotationProcessors = annotationProcessorsCopy;
        state.myUnresolvedAnnotationProcessors = null;
    }

    @NotNull
    public List<MavenArtifact> findDependencies(@NotNull MavenProject depProject) {
        if (depProject == null) {
            MavenProject.$$$reportNull$$$0(67);
        }
        List<MavenArtifact> list = this.findDependencies(depProject.getMavenId());
        if (list == null) {
            MavenProject.$$$reportNull$$$0(68);
        }
        return list;
    }

    public List<MavenArtifact> findDependencies(@NotNull MavenId id) {
        if (id == null) {
            MavenProject.$$$reportNull$$$0(69);
        }
        return this.getDependencyArtifactIndex().findArtifacts(id);
    }

    @NotNull
    public List<MavenArtifact> findDependencies(@Nullable String groupId, @Nullable String artifactId) {
        List<MavenArtifact> list = this.getDependencyArtifactIndex().findArtifacts(groupId, artifactId);
        if (list == null) {
            MavenProject.$$$reportNull$$$0(70);
        }
        return list;
    }

    public boolean hasUnresolvedArtifacts() {
        State state = this.myState;
        return !MavenProject.isParentResolved(state) || !MavenProject.getUnresolvedDependencies(state).isEmpty() || !MavenProject.getUnresolvedExtensions(state).isEmpty() || !MavenProject.getUnresolvedAnnotationProcessors(state).isEmpty();
    }

    public boolean hasUnresolvedPlugins() {
        return !MavenProject.getUnresolvedPlugins(this.myState).isEmpty();
    }

    @NotNull
    public List<MavenPlugin> getPlugins() {
        List<MavenPlugin> list = this.myState.myPlugins;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(71);
        }
        return list;
    }

    @NotNull
    public List<MavenPlugin> getDeclaredPlugins() {
        List<MavenPlugin> list = MavenProject.getDeclaredPlugins(this.myState);
        if (list == null) {
            MavenProject.$$$reportNull$$$0(72);
        }
        return list;
    }

    private static List<MavenPlugin> getDeclaredPlugins(State state) {
        return ContainerUtil.findAll(state.myPlugins, mavenPlugin -> !mavenPlugin.isDefault());
    }

    @Nullable
    public Element getPluginConfiguration(@Nullable String groupId, @Nullable String artifactId) {
        return this.getPluginGoalConfiguration(groupId, artifactId, null);
    }

    @Nullable
    public Element getPluginGoalConfiguration(@Nullable String groupId, @Nullable String artifactId, @Nullable String goal) {
        return this.getPluginGoalConfiguration(this.findPlugin(groupId, artifactId), goal);
    }

    @Nullable
    public Element getPluginGoalConfiguration(@Nullable MavenPlugin plugin, @Nullable String goal) {
        if (plugin == null) {
            return null;
        }
        return goal == null ? plugin.getConfigurationElement() : plugin.getGoalConfiguration(goal);
    }

    public Element getPluginExecutionConfiguration(@Nullable String groupId, @Nullable String artifactId, @NotNull String executionId) {
        MavenPlugin plugin;
        if (executionId == null) {
            MavenProject.$$$reportNull$$$0(73);
        }
        if ((plugin = this.findPlugin(groupId, artifactId)) == null) {
            return null;
        }
        return plugin.getExecutionConfiguration(executionId);
    }

    @Nullable
    public MavenPlugin findPlugin(@Nullable String groupId, @Nullable String artifactId) {
        return this.findPlugin(groupId, artifactId, false);
    }

    @Nullable
    public MavenPlugin findPlugin(@Nullable String groupId, @Nullable String artifactId, boolean explicitlyDeclaredOnly) {
        List<MavenPlugin> plugins = explicitlyDeclaredOnly ? this.getDeclaredPlugins() : this.getPlugins();
        for (MavenPlugin each : plugins) {
            if (!each.getMavenId().equals(groupId, artifactId)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public String getEncoding() {
        String encoding = this.myState.myProperties.getProperty("project.build.sourceEncoding");
        if (encoding != null) {
            return encoding;
        }
        Element pluginConfiguration = this.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        if (pluginConfiguration != null) {
            return pluginConfiguration.getChildTextTrim("encoding");
        }
        return null;
    }

    @Nullable
    public String getSourceLevel() {
        return this.getCompilerLevel("source");
    }

    @Nullable
    public String getTargetLevel() {
        return this.getCompilerLevel("target");
    }

    @Nullable
    public String getReleaseLevel() {
        return this.getCompilerLevel("release");
    }

    @Nullable
    private String getCompilerLevel(String level) {
        String result = MavenJDOMUtil.findChildValueByPath(this.getCompilerConfig(), level);
        if (result == null) {
            result = this.myState.myProperties.getProperty("maven.compiler." + level);
        }
        return result;
    }

    @Nullable
    private Element getCompilerConfig() {
        Element executionConfiguration = this.getPluginExecutionConfiguration("org.apache.maven.plugins", "maven-compiler-plugin", "default-compile");
        if (executionConfiguration != null) {
            return executionConfiguration;
        }
        return this.getPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    @NotNull
    public Properties getProperties() {
        Properties properties = this.myState.myProperties;
        if (properties == null) {
            MavenProject.$$$reportNull$$$0(74);
        }
        return properties;
    }

    @NotNull
    public Map<String, String> getMavenConfig() {
        Map<String, String> map = this.getPropertiesFromConfig(ConfigFileKind.MAVEN_CONFIG);
        if (map == null) {
            MavenProject.$$$reportNull$$$0(75);
        }
        return map;
    }

    @NotNull
    private Map<String, String> getPropertiesFromConfig(ConfigFileKind kind) {
        Map<String, String> mavenConfig = this.getCachedValue(kind.CACHE_KEY);
        if (mavenConfig == null) {
            mavenConfig = MavenProject.readConfigFile(MavenUtil.getBaseDir(this.getDirectoryFile()), kind);
            this.putCachedValue(kind.CACHE_KEY, mavenConfig);
        }
        Map<String, String> map = mavenConfig;
        if (map == null) {
            MavenProject.$$$reportNull$$$0(76);
        }
        return map;
    }

    @NotNull
    public Map<String, String> getJvmConfig() {
        Map<String, String> map = this.getPropertiesFromConfig(ConfigFileKind.JVM_CONFIG);
        if (map == null) {
            MavenProject.$$$reportNull$$$0(77);
        }
        return map;
    }

    @NotNull
    public static Map<String, String> readConfigFile(File baseDir, ConfigFileKind kind) {
        Map config;
        File configFile = new File(baseDir + FileUtil.toSystemDependentName((String)kind.myRelativeFilePath));
        ParametersList parametersList = new ParametersList();
        if (configFile.isFile()) {
            try {
                parametersList.addParametersString(FileUtil.loadFile((File)configFile, (String)"UTF-8"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Map map = (config = parametersList.getProperties(kind.myValueIfMissing)).isEmpty() ? Collections.emptyMap() : config;
        if (map == null) {
            MavenProject.$$$reportNull$$$0(78);
        }
        return map;
    }

    @NotNull
    public File getLocalRepository() {
        File file = this.myState.myLocalRepository;
        if (file == null) {
            MavenProject.$$$reportNull$$$0(79);
        }
        return file;
    }

    @NotNull
    public List<MavenRemoteRepository> getRemoteRepositories() {
        List<MavenRemoteRepository> list = this.myState.myRemoteRepositories;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(80);
        }
        return list;
    }

    @NotNull
    public List<MavenImporter> getSuitableImporters() {
        List<MavenImporter> list = MavenImporter.getSuitableImporters(this);
        if (list == null) {
            MavenProject.$$$reportNull$$$0(81);
        }
        return list;
    }

    @NotNull
    public ModuleType getModuleType() {
        List<MavenImporter> importers = this.getSuitableImporters();
        ModuleType moduleType = importers.size() > 0 ? importers.get(0).getModuleType() : StdModuleTypes.JAVA;
        if (moduleType == null) {
            MavenProject.$$$reportNull$$$0(82);
        }
        return moduleType;
    }

    @NotNull
    public Pair<String, String> getClassifierAndExtension(@NotNull MavenArtifact artifact, @NotNull MavenExtraArtifactType type) {
        if (artifact == null) {
            MavenProject.$$$reportNull$$$0(83);
        }
        if (type == null) {
            MavenProject.$$$reportNull$$$0(84);
        }
        for (MavenImporter each : this.getSuitableImporters()) {
            Pair<String, String> result = each.getExtraArtifactClassifierAndExtension(artifact, type);
            if (result == null) continue;
            Pair<String, String> pair = result;
            if (pair == null) {
                MavenProject.$$$reportNull$$$0(85);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)type.getDefaultClassifier(), (Object)type.getDefaultExtension());
        if (pair == null) {
            MavenProject.$$$reportNull$$$0(86);
        }
        return pair;
    }

    public MavenArtifactIndex getDependencyArtifactIndex() {
        MavenArtifactIndex res = this.getCachedValue(DEPENDENCIES_CACHE_KEY);
        if (res == null) {
            res = MavenArtifactIndex.build(this.getDependencies());
            res = this.putCachedValue(DEPENDENCIES_CACHE_KEY, res);
        }
        return res;
    }

    @Nullable
    public <V> V getCachedValue(Key<V> key) {
        return (V)this.myState.myCache.get(key);
    }

    @NotNull
    public <V> V putCachedValue(Key<V> key, @NotNull V value) {
        ConcurrentHashMap<Key, Object> map;
        Object oldValue;
        if (value == null) {
            MavenProject.$$$reportNull$$$0(87);
        }
        if ((oldValue = (map = this.myState.myCache).putIfAbsent(key, value)) != null) {
            Object object = oldValue;
            if (object == null) {
                MavenProject.$$$reportNull$$$0(88);
            }
            return (V)object;
        }
        V v = value;
        if (v == null) {
            MavenProject.$$$reportNull$$$0(89);
        }
        return v;
    }

    public String toString() {
        return this.getMavenId().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 88: 
            case 89: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 88: 
            case 89: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readerResult";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 88: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProject";
                break;
            }
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generalSettings";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedder";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 63: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationProcessors";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProject";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionId";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "set";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackaging";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSourcesDirectory";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessorDirectory";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcMode";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputDirectory";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestOutputDirectory";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSources";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestResources";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFolders";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblems";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingModuleFiles";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePaths";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesPathsAndNames";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilesIds";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivatedProfilesIds";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalAnnotationProcessors";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessorPath";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyTree";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedPackagings";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedDependencyScopes";
                break;
            }
            case 68: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencies";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredPlugins";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenConfig";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFromConfig";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmConfig";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "readConfigFile";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepository";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteRepositories";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableImporters";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierAndExtension";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "putCachedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 88: 
            case 89: {
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveFolders";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyTypesFromImporters";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotationProcessors";
                break;
            }
            case 67: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findDependencies";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getPluginExecutionConfiguration";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getClassifierAndExtension";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "putCachedValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 88: 
            case 89: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class State
    implements Cloneable,
    Serializable {
        long myLastReadStamp = 0L;
        MavenId myMavenId;
        MavenId myParentId;
        String myPackaging;
        String myName;
        String myFinalName;
        String myDefaultGoal;
        String myBuildDirectory;
        String myOutputDirectory;
        String myTestOutputDirectory;
        List<String> mySources;
        List<String> myTestSources;
        List<MavenResource> myResources;
        List<MavenResource> myTestResources;
        List<String> myFilters;
        Properties myProperties;
        List<MavenPlugin> myPlugins;
        List<MavenArtifact> myExtensions;
        List<MavenArtifact> myDependencies;
        List<MavenArtifactNode> myDependencyTree;
        List<MavenRemoteRepository> myRemoteRepositories;
        List<MavenArtifact> myAnnotationProcessors;
        Map<String, String> myModulesPathsAndNames;
        Map<String, String> myModelMap;
        Collection<String> myProfilesIds;
        MavenExplicitProfiles myActivatedProfilesIds;
        Collection<MavenProjectProblem> myReadingProblems;
        Set<MavenId> myUnresolvedArtifactIds;
        File myLocalRepository;
        volatile List<MavenProjectProblem> myProblemsCache;
        volatile List<MavenArtifact> myUnresolvedDependenciesCache;
        volatile List<MavenPlugin> myUnresolvedPluginsCache;
        volatile List<MavenArtifact> myUnresolvedExtensionsCache;
        volatile List<MavenArtifact> myUnresolvedAnnotationProcessors;
        transient ConcurrentHashMap<Key, Object> myCache = new ConcurrentHashMap();

        private State() {
        }

        public State clone() {
            try {
                State result = (State)super.clone();
                this.myCache = new ConcurrentHashMap();
                result.resetCache();
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        private void resetCache() {
            this.myProblemsCache = null;
            this.myUnresolvedDependenciesCache = null;
            this.myUnresolvedPluginsCache = null;
            this.myUnresolvedExtensionsCache = null;
            this.myUnresolvedAnnotationProcessors = null;
            this.myCache.clear();
        }

        public MavenProjectChanges getChanges(State other) {
            if (this.myLastReadStamp == 0L) {
                return MavenProjectChanges.ALL;
            }
            MavenProjectChanges result = new MavenProjectChanges();
            result.packaging = !Comparing.equal((String)this.myPackaging, (String)other.myPackaging);
            result.output = !Comparing.equal((String)this.myFinalName, (String)other.myFinalName) || !Comparing.equal((String)this.myBuildDirectory, (String)other.myBuildDirectory) || !Comparing.equal((String)this.myOutputDirectory, (String)other.myOutputDirectory) || !Comparing.equal((String)this.myTestOutputDirectory, (String)other.myTestOutputDirectory);
            result.sources = !Comparing.equal(this.mySources, other.mySources) || !Comparing.equal(this.myTestSources, other.myTestSources) || !Comparing.equal(this.myResources, other.myResources) || !Comparing.equal(this.myTestResources, other.myTestResources);
            boolean repositoryChanged = !Comparing.equal((Object)this.myLocalRepository, (Object)other.myLocalRepository);
            result.dependencies = repositoryChanged || !Comparing.equal(this.myDependencies, other.myDependencies);
            result.plugins = repositoryChanged || !Comparing.equal(this.myPlugins, other.myPlugins);
            return result;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.myCache = new ConcurrentHashMap();
        }
    }

    public static enum ProcMode {
        BOTH,
        ONLY,
        NONE;

    }

    public static enum ConfigFileKind {
        MAVEN_CONFIG("/.mvn/maven.config", "true"),
        JVM_CONFIG("/.mvn/jvm.config", "");

        final Key<Map<String, String>> CACHE_KEY = Key.create((String)("MavenProject." + this.name()));
        final String myRelativeFilePath;
        final String myValueIfMissing;

        private ConfigFileKind(String relativeFilePath, String valueIfMissing) {
            this.myRelativeFilePath = relativeFilePath;
            this.myValueIfMissing = valueIfMissing;
        }
    }
}

