/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/statistics/MavenSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
public final class MavenSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "build.maven.state";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        MavenRunnerSettings runnerSettings;
        MavenImportingSettings importingSettings;
        MavenGeneralSettings generalSettings;
        MavenProjectsManager manager;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        MavenProjectsManager mavenProjectsManager = manager = MavenProjectsManager.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenProjectsManager, (String)"manager");
        if (!mavenProjectsManager.isMavenizedProject()) {
            return SetsKt.emptySet();
        }
        Set usages = new LinkedHashSet();
        MavenGeneralSettings mavenGeneralSettings = generalSettings = manager.getGeneralSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenGeneralSettings, (String)"generalSettings");
        usages.add(StatisticsUtilKt.getEnumUsage((String)"checksumPolicy", (Enum)mavenGeneralSettings.getChecksumPolicy()));
        usages.add(StatisticsUtilKt.getEnumUsage((String)"failureBehavior", (Enum)generalSettings.getFailureBehavior()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"alwaysUpdateSnapshots", (boolean)generalSettings.isAlwaysUpdateSnapshots()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"nonRecursive", (boolean)generalSettings.isNonRecursive()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"printErrorStackTraces", (boolean)generalSettings.isPrintErrorStackTraces()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"usePluginRegistry", (boolean)generalSettings.isUsePluginRegistry()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"workOffline", (boolean)generalSettings.isWorkOffline()));
        usages.add(StatisticsUtilKt.getEnumUsage((String)"outputLevel", (Enum)generalSettings.getOutputLevel()));
        usages.add(StatisticsUtilKt.getEnumUsage((String)"pluginUpdatePolicy", (Enum)generalSettings.getPluginUpdatePolicy()));
        usages.add(StatisticsUtilKt.getEnumUsage((String)"loggingLevel", (Enum)generalSettings.getLoggingLevel()));
        try {
            String mavenVersion = MavenUtil.getMavenVersion(MavenExternalParameters.resolveMavenHome(generalSettings, project, null));
            usages.add(new UsageDescriptor("mavenVersion." + mavenVersion));
        }
        catch (Exception mavenVersion) {
            // empty catch block
        }
        MavenImportingSettings mavenImportingSettings = importingSettings = manager.getImportingSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenImportingSettings, (String)"importingSettings");
        usages.add(StatisticsUtilKt.getEnumUsage((String)"generatedSourcesFolder", (Enum)mavenImportingSettings.getGeneratedSourcesFolder()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"createModuleGroups", (boolean)importingSettings.isCreateModuleGroups()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"createModulesForAggregators", (boolean)importingSettings.isCreateModulesForAggregators()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"downloadDocsAutomatically", (boolean)importingSettings.isDownloadDocsAutomatically()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"downloadSourcesAutomatically", (boolean)importingSettings.isDownloadSourcesAutomatically()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"excludeTargetFolder", (boolean)importingSettings.isExcludeTargetFolder()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"importAutomatically", (boolean)importingSettings.isImportAutomatically()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"keepSourceFolders", (boolean)importingSettings.isKeepSourceFolders()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"lookForNested", (boolean)importingSettings.isLookForNested()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"useMavenOutput", (boolean)importingSettings.isUseMavenOutput()));
        usages.add(new UsageDescriptor("updateFoldersOnImportPhase." + importingSettings.getUpdateFoldersOnImportPhase()));
        MavenRunner mavenRunner = MavenRunner.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenRunner, (String)"MavenRunner.getInstance(project)");
        MavenRunnerSettings mavenRunnerSettings = runnerSettings = mavenRunner.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenRunnerSettings, (String)"runnerSettings");
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"delegateBuildRun", (boolean)mavenRunnerSettings.isDelegateBuildToMaven()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"passParentEnv", (boolean)runnerSettings.isPassParentEnv()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"runMavenInBackground", (boolean)runnerSettings.isRunMavenInBackground()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"skipTests", (boolean)runnerSettings.isSkipTests()));
        return usages;
    }
}

