import{Settings,ObjectWrapper,UIString}from'../common/common.js';import{Widget,UIUtils,SettingsUI,Utils,Toolbar,Icon}from'../ui/ui.js';import{TargetDetachedDialog}from'../components/components.js';import{InspectorFrontendHost,InspectorFrontendHostAPI}from'../host/host.js';import{NetworkPanelIndicator}from'../mobile_throttling/mobile_throttling.js';import{Connections,SDKModel,DebuggerModel,ResourceTreeModel,ChildTargetManager}from'../sdk/sdk.js';class RenderingOptionsView extends Widget.VBox{constructor(){super(true);this.registerRequiredCSS('inspector_main/renderingOptions.css');this._appendCheckbox(ls`Paint flashing`,ls`Highlights areas of the page (green) that need to be repainted. May not be suitable for people prone to photosensitive epilepsy.`,Settings.Settings.instance().moduleSetting('showPaintRects'));this._appendCheckbox(ls`Layout Shift Regions`,ls`Highlights areas of the page (blue) that were shifted. May not be suitable for people prone to photosensitive epilepsy.`,Settings.Settings.instance().moduleSetting('showLayoutShiftRegions'));this._appendCheckbox(ls`Layer borders`,ls`Shows layer borders (orange/olive) and tiles (cyan).`,Settings.Settings.instance().moduleSetting('showDebugBorders'));this._appendCheckbox(ls`FPS meter`,ls`Plots frames per second, frame rate distribution, and GPU memory.`,Settings.Settings.instance().moduleSetting('showFPSCounter'));this._appendCheckbox(ls`Scrolling performance issues`,ls`Highlights elements (teal) that can slow down scrolling, including touch & wheel event handlers and other main-thread scrolling situations.`,Settings.Settings.instance().moduleSetting('showScrollBottleneckRects'));this._appendCheckbox(ls`Highlight ad frames`,ls`Highlights frames (red) detected to be ads.`,Settings.Settings.instance().moduleSetting('showAdHighlights'));this._appendCheckbox(ls`Hit-test borders`,ls`Shows borders around hit-test regions.`,Settings.Settings.instance().moduleSetting('showHitTestBorders'));this.contentElement.createChild('div').classList.add('panel-section-separator');this._appendSelect(ls`Forces media type for testing print and screen styles`,Settings.Settings.instance().moduleSetting('emulatedCSSMedia'));this._appendSelect(ls`Forces CSS prefers-color-scheme media feature`,Settings.Settings.instance().moduleSetting('emulatedCSSMediaFeaturePrefersColorScheme'));this._appendSelect(ls`Forces CSS prefers-reduced-motion media feature`,Settings.Settings.instance().moduleSetting('emulatedCSSMediaFeaturePrefersReducedMotion'));this.contentElement.createChild('div').classList.add('panel-section-separator');this._appendSelect(ls`Forces vision deficiency emulation`,Settings.Settings.instance().moduleSetting('emulatedVisionDeficiency'));}
_appendCheckbox(label,subtitle,setting){const checkboxLabel=UIUtils.CheckboxLabel.create(label,false,subtitle);SettingsUI.bindCheckbox(checkboxLabel.checkboxElement,setting);this.contentElement.appendChild(checkboxLabel);}
_appendSelect(label,setting){const control=SettingsUI.createControlForSetting(setting,label);if(control){this.contentElement.appendChild(control);}}}
var RenderingOptions=Object.freeze({__proto__:null,RenderingOptionsView:RenderingOptionsView});class InspectorMainImpl extends ObjectWrapper.ObjectWrapper{async run(){let firstCall=true;await Connections.initMainConnection(async()=>{const type=Root.Runtime.queryParam('v8only')?SDKModel.Type.Node:SDKModel.Type.Frame;const waitForDebuggerInPage=type===SDKModel.Type.Frame&&Root.Runtime.queryParam('panel')==='sources';const target=SDKModel.TargetManager.instance().createTarget('main',UIString.UIString('Main'),type,null,undefined,waitForDebuggerInPage);if(!firstCall){return;}
firstCall=false;if(waitForDebuggerInPage){const debuggerModel=target.model(DebuggerModel.DebuggerModel);if(!debuggerModel.isReadyToPause()){await debuggerModel.once(DebuggerModel.Events.DebuggerIsReadyToPause);}
debuggerModel.pause();}
target.runtimeAgent().runIfWaitingForDebugger();},TargetDetachedDialog.TargetDetachedDialog.webSocketConnectionLost);new SourcesPanelIndicator();new BackendSettingsSync();new NetworkPanelIndicator.NetworkPanelIndicator();InspectorFrontendHost.InspectorFrontendHostInstance.events.addEventListener(InspectorFrontendHostAPI.Events.ReloadInspectedPage,event=>{const hard=(event.data);ResourceTreeModel.ResourceTreeModel.reloadAllPages(hard);});}}
class ReloadActionDelegate{handleAction(context,actionId){switch(actionId){case'inspector_main.reload':ResourceTreeModel.ResourceTreeModel.reloadAllPages(false);return true;case'inspector_main.hard-reload':ResourceTreeModel.ResourceTreeModel.reloadAllPages(true);return true;}
return false;}}
class FocusDebuggeeActionDelegate{handleAction(context,actionId){SDKModel.TargetManager.instance().mainTarget().pageAgent().bringToFront();return true;}}
class NodeIndicator{constructor(){const element=createElement('div');const shadowRoot=Utils.createShadowRootWithCoreStyles(element,'inspector_main/nodeIcon.css');this._element=shadowRoot.createChild('div','node-icon');element.addEventListener('click',()=>InspectorFrontendHost.InspectorFrontendHostInstance.openNodeFrontend(),false);this._button=new Toolbar.ToolbarItem(element);this._button.setTitle(UIString.UIString('Open dedicated DevTools for Node.js'));SDKModel.TargetManager.instance().addEventListener(SDKModel.Events.AvailableTargetsChanged,event=>this._update((event.data)));this._button.setVisible(false);this._update([]);}
_update(targetInfos){const hasNode=!!targetInfos.find(target=>target.type==='node'&&!target.attached);this._element.classList.toggle('inactive',!hasNode);if(hasNode){this._button.setVisible(true);}}
item(){return this._button;}}
class SourcesPanelIndicator{constructor(){Settings.Settings.instance().moduleSetting('javaScriptDisabled').addChangeListener(javaScriptDisabledChanged);javaScriptDisabledChanged();function javaScriptDisabledChanged(){let icon=null;const javaScriptDisabled=Settings.Settings.instance().moduleSetting('javaScriptDisabled').get();if(javaScriptDisabled){icon=Icon.Icon.create('smallicon-warning');icon.title=UIString.UIString('JavaScript is disabled');}
self.UI.inspectorView.setPanelIcon('sources',icon);}}}
class BackendSettingsSync{constructor(){this._autoAttachSetting=Settings.Settings.instance().moduleSetting('autoAttachToCreatedPages');this._autoAttachSetting.addChangeListener(this._updateAutoAttach,this);this._updateAutoAttach();this._adBlockEnabledSetting=Settings.Settings.instance().moduleSetting('network.adBlockingEnabled');this._adBlockEnabledSetting.addChangeListener(this._update,this);this._emulatePageFocusSetting=Settings.Settings.instance().moduleSetting('emulatePageFocus');this._emulatePageFocusSetting.addChangeListener(this._update,this);SDKModel.TargetManager.instance().observeTargets(this);}
_updateTarget(target){if(target.type()!==SDKModel.Type.Frame||target.parentTarget()){return;}
target.pageAgent().setAdBlockingEnabled(this._adBlockEnabledSetting.get());target.emulationAgent().setFocusEmulationEnabled(this._emulatePageFocusSetting.get());}
_updateAutoAttach(){InspectorFrontendHost.InspectorFrontendHostInstance.setOpenNewWindowForPopups(this._autoAttachSetting.get());}
_update(){for(const target of SDKModel.TargetManager.instance().targets()){this._updateTarget(target);}}
targetAdded(target){this._updateTarget(target);}
targetRemoved(target){}}
ChildTargetManager.ChildTargetManager.install();var InspectorMain=Object.freeze({__proto__:null,InspectorMainImpl:InspectorMainImpl,ReloadActionDelegate:ReloadActionDelegate,FocusDebuggeeActionDelegate:FocusDebuggeeActionDelegate,NodeIndicator:NodeIndicator,SourcesPanelIndicator:SourcesPanelIndicator,BackendSettingsSync:BackendSettingsSync});export{InspectorMain,RenderingOptions};